/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.SystemTopicClientBase;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.ActionType;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPoliciesSystemTopicClient
extends SystemTopicClientBase<PulsarEvent> {
    private static final Logger log = LoggerFactory.getLogger(TopicPoliciesSystemTopicClient.class);

    public TopicPoliciesSystemTopicClient(PulsarClient client, TopicName topicName) {
        super(client, topicName);
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Writer<PulsarEvent>> newWriterAsyncInternal() {
        return this.client.newProducer(Schema.AVRO(PulsarEvent.class)).topic(this.topicName.toString()).enableBatching(false).createAsync().thenApply(producer -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new writer is created", (Object)this.topicName);
            }
            return new TopicPolicyWriter((Producer<PulsarEvent>)producer, this);
        });
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Reader<PulsarEvent>> newReaderAsyncInternal() {
        return this.client.newReader(Schema.AVRO(PulsarEvent.class)).topic(this.topicName.toString()).startMessageId(MessageId.earliest).readCompacted(true).createAsync().thenApply(reader -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new reader is created", (Object)this.topicName);
            }
            return new TopicPolicyReader((Reader<PulsarEvent>)reader, this);
        });
    }

    private static void setReplicateCluster(PulsarEvent event, TypedMessageBuilder<PulsarEvent> builder) {
        if (event.getReplicateTo() != null) {
            builder.replicationClusters(new ArrayList<String>(event.getReplicateTo()));
        }
    }

    private static void validateActionType(PulsarEvent event) {
        if (event == null || !ActionType.DELETE.equals((Object)event.getActionType())) {
            throw new UnsupportedOperationException("The only supported ActionType is DELETE");
        }
    }

    private static class TopicPolicyReader
    implements SystemTopicClient.Reader<PulsarEvent> {
        private final Reader<PulsarEvent> reader;
        private final TopicPoliciesSystemTopicClient systemTopic;

        private TopicPolicyReader(Reader<PulsarEvent> reader, TopicPoliciesSystemTopicClient systemTopic) {
            this.reader = reader;
            this.systemTopic = systemTopic;
        }

        @Override
        public Message<PulsarEvent> readNext() throws PulsarClientException {
            return this.reader.readNext();
        }

        @Override
        public CompletableFuture<Message<PulsarEvent>> readNextAsync() {
            return this.reader.readNextAsync();
        }

        @Override
        public boolean hasMoreEvents() throws PulsarClientException {
            return this.reader.hasMessageAvailable();
        }

        @Override
        public CompletableFuture<Boolean> hasMoreEventsAsync() {
            return this.reader.hasMessageAvailableAsync();
        }

        @Override
        public void close() throws IOException {
            try {
                this.closeAsync().get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new PulsarServerException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.reader.closeAsync().whenComplete((r, ex) -> this.systemTopic.getReaders().remove(this));
        }

        @Override
        public SystemTopicClient<PulsarEvent> getSystemTopic() {
            return this.systemTopic;
        }
    }

    private static class TopicPolicyWriter
    implements SystemTopicClient.Writer<PulsarEvent> {
        private final Producer<PulsarEvent> producer;
        private final SystemTopicClient<PulsarEvent> systemTopicClient;

        private TopicPolicyWriter(Producer<PulsarEvent> producer, SystemTopicClient<PulsarEvent> systemTopicClient) {
            this.producer = producer;
            this.systemTopicClient = systemTopicClient;
        }

        @Override
        public MessageId write(PulsarEvent event) throws PulsarClientException {
            TypedMessageBuilder<PulsarEvent> builder = this.producer.newMessage().key(this.getEventKey(event)).value(event);
            TopicPoliciesSystemTopicClient.setReplicateCluster(event, builder);
            return builder.send();
        }

        @Override
        public CompletableFuture<MessageId> writeAsync(PulsarEvent event) {
            TypedMessageBuilder<PulsarEvent> builder = this.producer.newMessage().key(this.getEventKey(event)).value(event);
            TopicPoliciesSystemTopicClient.setReplicateCluster(event, builder);
            return builder.sendAsync();
        }

        @Override
        public MessageId delete(PulsarEvent event) throws PulsarClientException {
            TopicPoliciesSystemTopicClient.validateActionType(event);
            TypedMessageBuilder<Object> builder = this.producer.newMessage().key(this.getEventKey(event)).value(null);
            TopicPoliciesSystemTopicClient.setReplicateCluster(event, builder);
            return builder.send();
        }

        @Override
        public CompletableFuture<MessageId> deleteAsync(PulsarEvent event) {
            TopicPoliciesSystemTopicClient.validateActionType(event);
            TypedMessageBuilder<Object> builder = this.producer.newMessage().key(this.getEventKey(event)).value(null);
            TopicPoliciesSystemTopicClient.setReplicateCluster(event, builder);
            return builder.sendAsync();
        }

        private String getEventKey(PulsarEvent event) {
            return TopicName.get(event.getTopicPoliciesEvent().getDomain(), event.getTopicPoliciesEvent().getTenant(), event.getTopicPoliciesEvent().getNamespace(), event.getTopicPoliciesEvent().getTopic()).toString();
        }

        @Override
        public void close() throws IOException {
            try {
                this.closeAsync().get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new PulsarServerException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.producer.closeAsync().whenComplete((r, ex) -> this.systemTopicClient.getWriters().remove(this));
        }

        @Override
        public SystemTopicClient<PulsarEvent> getSystemTopicClient() {
            return this.systemTopicClient;
        }
    }
}

