/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferClientStats;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.Counter;
import org.apache.pulsar.shade.io.prometheus.client.Gauge;
import org.apache.pulsar.shade.io.prometheus.client.Summary;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

public final class TransactionBufferClientStatsImpl
implements TransactionBufferClientStats {
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999, 1.0};
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Counter abortFailed;
    private final Counter commitFailed;
    private final Summary abortLatency;
    private final Summary commitLatency;
    private final Gauge pendingRequests;
    private final boolean exposeTopicLevelMetrics;
    private static TransactionBufferClientStats instance;

    private TransactionBufferClientStatsImpl(boolean exposeTopicLevelMetrics, final TransactionBufferHandler handler) {
        String[] stringArray;
        this.exposeTopicLevelMetrics = exposeTopicLevelMetrics;
        if (exposeTopicLevelMetrics) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "namespace";
            stringArray = stringArray2;
            stringArray2[1] = "topic";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "namespace";
        }
        String[] labelNames = stringArray;
        this.abortFailed = (Counter)((Counter.Builder)Counter.build("pulsar_txn_tb_client_abort_failed", "-").labelNames(labelNames)).register();
        this.commitFailed = (Counter)((Counter.Builder)Counter.build("pulsar_txn_tb_client_commit_failed", "-").labelNames(labelNames)).register();
        this.abortLatency = this.buildSummary("pulsar_txn_tb_client_abort_latency", "-", labelNames);
        this.commitLatency = this.buildSummary("pulsar_txn_tb_client_commit_latency", "-", labelNames);
        this.pendingRequests = (Gauge)((Gauge)Gauge.build("pulsar_txn_tb_client_pending_requests", "-").register()).setChild(new Gauge.Child(){

            @Override
            public double get() {
                return null == handler ? 0.0 : (double)handler.getPendingRequestsCount();
            }
        }, new String[0]);
    }

    private Summary buildSummary(String name, String help, String[] labelNames) {
        Summary.Builder builder = (Summary.Builder)Summary.build(name, help).labelNames(labelNames);
        for (double quantile : QUANTILES) {
            builder.quantile(quantile, 0.01);
        }
        return (Summary)builder.register();
    }

    public static synchronized TransactionBufferClientStats getInstance(boolean exposeTopicLevelMetrics, TransactionBufferHandler handler) {
        if (null == instance) {
            instance = new TransactionBufferClientStatsImpl(exposeTopicLevelMetrics, handler);
        }
        return instance;
    }

    @Override
    public void recordAbortFailed(String topic) {
        ((Counter.Child)this.abortFailed.labels(this.labelValues(topic))).inc();
    }

    @Override
    public void recordCommitFailed(String topic) {
        ((Counter.Child)this.commitFailed.labels(this.labelValues(topic))).inc();
    }

    @Override
    public void recordAbortLatency(String topic, long nanos) {
        ((Summary.Child)this.abortLatency.labels(this.labelValues(topic))).observe(nanos);
    }

    @Override
    public void recordCommitLatency(String topic, long nanos) {
        ((Summary.Child)this.commitLatency.labels(this.labelValues(topic))).observe(nanos);
    }

    private String[] labelValues(String topic) {
        try {
            String[] stringArray;
            TopicName topicName = TopicName.get(topic);
            if (this.exposeTopicLevelMetrics) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = topicName.getNamespace();
                stringArray = stringArray2;
                stringArray2[1] = topic;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = topicName.getNamespace();
            }
            return stringArray;
        }
        catch (Throwable t) {
            String[] stringArray;
            if (this.exposeTopicLevelMetrics) {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "unknown";
                stringArray = stringArray4;
                stringArray4[1] = "unknown";
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "unknown";
            }
            return stringArray;
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            instance = null;
            CollectorRegistry.defaultRegistry.unregister(this.abortFailed);
            CollectorRegistry.defaultRegistry.unregister(this.commitFailed);
            CollectorRegistry.defaultRegistry.unregister(this.abortLatency);
            CollectorRegistry.defaultRegistry.unregister(this.commitLatency);
            CollectorRegistry.defaultRegistry.unregister(this.pendingRequests);
        }
    }
}

