/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckHandleStats;
import org.apache.pulsar.shade.io.prometheus.client.Counter;
import org.apache.pulsar.shade.io.prometheus.client.Summary;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

public class PendingAckHandleStatsImpl
implements PendingAckHandleStats {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static Counter commitTxnCounter;
    private static Counter abortTxnCounter;
    private static Summary commitTxnLatency;
    private static boolean exposeTopicLevelMetrics0;
    private final String[] labelSucceed;
    private final String[] labelFailed;
    private final String[] commitLatencyLabel;

    public PendingAckHandleStatsImpl(String topic, String subscription, boolean exposeTopicLevelMetrics) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String namespace;
        PendingAckHandleStatsImpl.initialize(exposeTopicLevelMetrics);
        if (StringUtils.isBlank(topic)) {
            topic = "unknown";
            namespace = "unknown";
        } else {
            try {
                namespace = TopicName.get(topic).getNamespace();
            }
            catch (IllegalArgumentException ex) {
                namespace = "unknown";
            }
        }
        if (exposeTopicLevelMetrics0) {
            String[] stringArray4 = new String[4];
            stringArray4[0] = namespace;
            stringArray4[1] = topic;
            stringArray4[2] = subscription;
            stringArray3 = stringArray4;
            stringArray4[3] = "succeed";
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = namespace;
            stringArray3 = stringArray5;
            stringArray5[1] = "succeed";
        }
        this.labelSucceed = stringArray3;
        if (exposeTopicLevelMetrics0) {
            String[] stringArray6 = new String[4];
            stringArray6[0] = namespace;
            stringArray6[1] = topic;
            stringArray6[2] = subscription;
            stringArray2 = stringArray6;
            stringArray6[3] = "failed";
        } else {
            String[] stringArray7 = new String[2];
            stringArray7[0] = namespace;
            stringArray2 = stringArray7;
            stringArray7[1] = "failed";
        }
        this.labelFailed = stringArray2;
        if (exposeTopicLevelMetrics0) {
            String[] stringArray8 = new String[3];
            stringArray8[0] = namespace;
            stringArray8[1] = topic;
            stringArray = stringArray8;
            stringArray8[2] = subscription;
        } else {
            String[] stringArray9 = new String[1];
            stringArray = stringArray9;
            stringArray9[0] = namespace;
        }
        this.commitLatencyLabel = stringArray;
    }

    @Override
    public void recordCommitTxn(boolean success, long nanos) {
        String[] labels;
        if (success) {
            labels = this.labelSucceed;
            ((Summary.Child)commitTxnLatency.labels(this.commitLatencyLabel)).observe(TimeUnit.NANOSECONDS.toMicros(nanos));
        } else {
            labels = this.labelFailed;
        }
        ((Counter.Child)commitTxnCounter.labels(labels)).inc();
    }

    @Override
    public void recordAbortTxn(boolean success) {
        ((Counter.Child)abortTxnCounter.labels(success ? this.labelSucceed : this.labelFailed)).inc();
    }

    @Override
    public void close() {
        if (exposeTopicLevelMetrics0) {
            commitTxnCounter.remove(this.labelSucceed);
            commitTxnCounter.remove(this.labelFailed);
            abortTxnCounter.remove(this.labelFailed);
            abortTxnCounter.remove(this.labelFailed);
        }
    }

    static void initialize(boolean exposeTopicLevelMetrics) {
        if (INITIALIZED.compareAndSet(false, true)) {
            String[] stringArray;
            String[] stringArray2;
            exposeTopicLevelMetrics0 = exposeTopicLevelMetrics;
            if (exposeTopicLevelMetrics) {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "namespace";
                stringArray3[1] = "topic";
                stringArray3[2] = "subscription";
                stringArray2 = stringArray3;
                stringArray3[3] = "status";
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "namespace";
                stringArray2 = stringArray4;
                stringArray4[1] = "status";
            }
            String[] labelNames = stringArray2;
            commitTxnCounter = (Counter)((Counter.Builder)Counter.build("pulsar_txn_tp_committed_count", "-").labelNames(labelNames)).register();
            abortTxnCounter = (Counter)((Counter.Builder)Counter.build("pulsar_txn_tp_aborted_count", "-").labelNames(labelNames)).register();
            Summary.Builder builder = Summary.build("pulsar_txn_tp_commit_latency", "-").quantile(0.5, 0.01).quantile(0.9, 0.01).quantile(0.99, 0.01).quantile(0.999, 0.01);
            if (exposeTopicLevelMetrics) {
                String[] stringArray5 = new String[3];
                stringArray5[0] = "namespace";
                stringArray5[1] = "topic";
                stringArray = stringArray5;
                stringArray5[2] = "subscription";
            } else {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = "namespace";
            }
            commitTxnLatency = (Summary)((Summary.Builder)builder.labelNames(stringArray)).register();
        }
    }
}

