/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.util;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class LogIndexLagBackoff {
    private final long minLag;
    private final long maxLag;
    private final double exponent;

    public LogIndexLagBackoff(long minLag, long maxLag, double exponent) {
        Preconditions.checkArgument(minLag > 0L, "min lag must be > 0");
        Preconditions.checkArgument(maxLag >= minLag, "maxLag should be >= minLag");
        Preconditions.checkArgument(exponent > 0.0, "exponent must be > 0");
        this.minLag = minLag;
        this.maxLag = maxLag;
        this.exponent = exponent;
    }

    public long next(int indexCount) {
        if (indexCount <= 0) {
            return this.minLag;
        }
        return (long)Math.min((double)this.maxLag, (double)this.minLag * Math.pow(indexCount, this.exponent));
    }

    public long getMinLag() {
        return this.minLag;
    }

    public long getMaxLag() {
        return this.maxLag;
    }

    public double getExponent() {
        return this.exponent;
    }
}

