/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.web.ExceptionHandler;
import org.apache.pulsar.broker.web.RequestWrapper;
import org.apache.pulsar.shade.javax.servlet.Filter;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.FilterConfig;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.InterceptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreInterceptFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PreInterceptFilter.class);
    private final BrokerInterceptor interceptor;
    private final ExceptionHandler exceptionHandler;

    public PreInterceptFilter(BrokerInterceptor interceptor, ExceptionHandler exceptionHandler) {
        this.interceptor = interceptor;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("PreInterceptFilter: path {}, type {}", (Object)servletRequest.getServletContext().getContextPath(), (Object)servletRequest.getContentType());
        }
        if (StringUtils.containsIgnoreCase(servletRequest.getContentType(), "multipart/form-data") || StringUtils.containsIgnoreCase(servletRequest.getContentType(), "application/octet-stream")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            RequestWrapper requestWrapper = new RequestWrapper((HttpServletRequest)servletRequest);
            if (this.interceptor != null) {
                this.interceptor.onWebserviceRequest(requestWrapper);
            }
            filterChain.doFilter(requestWrapper, servletResponse);
        }
        catch (InterceptException e) {
            this.exceptionHandler.handle(servletResponse, e);
        }
    }

    @Override
    public void destroy() {
    }
}

