/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.LookupService;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandLookupTopicResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.lookup.GetTopicsResult;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryProtoLookupService
implements LookupService {
    private final PulsarClientImpl client;
    private final ServiceNameResolver serviceNameResolver;
    private final boolean useTls;
    private final ExecutorService executor;
    private final String listenerName;
    private final int maxLookupRedirects;
    private static final Logger log = LoggerFactory.getLogger(BinaryProtoLookupService.class);

    public BinaryProtoLookupService(PulsarClientImpl client, String serviceUrl, boolean useTls, ExecutorService executor) throws PulsarClientException {
        this(client, serviceUrl, null, useTls, executor);
    }

    public BinaryProtoLookupService(PulsarClientImpl client, String serviceUrl, String listenerName, boolean useTls, ExecutorService executor) throws PulsarClientException {
        this.client = client;
        this.useTls = useTls;
        this.executor = executor;
        this.maxLookupRedirects = client.getConfiguration().getMaxLookupRedirects();
        this.serviceNameResolver = new PulsarServiceNameResolver();
        this.listenerName = listenerName;
        this.updateServiceUrl(serviceUrl);
    }

    @Override
    public void updateServiceUrl(String serviceUrl) throws PulsarClientException {
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
    }

    @Override
    public CompletableFuture<Pair<InetSocketAddress, InetSocketAddress>> getBroker(TopicName topicName) {
        return this.findBroker(this.serviceNameResolver.resolveHost(), false, topicName, 0);
    }

    @Override
    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(TopicName topicName) {
        return this.getPartitionedTopicMetadata(this.serviceNameResolver.resolveHost(), topicName);
    }

    private CompletableFuture<Pair<InetSocketAddress, InetSocketAddress>> findBroker(InetSocketAddress socketAddress, boolean authoritative, TopicName topicName, int redirectCount) {
        CompletableFuture<Pair<InetSocketAddress, InetSocketAddress>> addressFuture = new CompletableFuture<Pair<InetSocketAddress, InetSocketAddress>>();
        if (this.maxLookupRedirects > 0 && redirectCount > this.maxLookupRedirects) {
            addressFuture.completeExceptionally(new PulsarClientException.LookupException("Too many redirects: " + this.maxLookupRedirects));
            return addressFuture;
        }
        ((CompletableFuture)this.client.getCnxPool().getConnection(socketAddress).thenAccept(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newLookup(topicName.toString(), this.listenerName, authoritative, requestId);
            clientCnx.newLookup(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    log.warn("[{}] failed to send lookup request : {}", (Object)topicName, (Object)t.getMessage());
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Lookup response exception: {}", (Object)topicName, t);
                    }
                    addressFuture.completeExceptionally((Throwable)t);
                } else {
                    URI uri = null;
                    try {
                        if (this.useTls) {
                            uri = new URI(r.brokerUrlTls);
                        } else {
                            String serviceUrl = r.brokerUrl;
                            uri = new URI(serviceUrl);
                        }
                        InetSocketAddress responseBrokerAddress = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                        if (r.redirect) {
                            ((CompletableFuture)this.findBroker(responseBrokerAddress, r.authoritative, topicName, redirectCount + 1).thenAccept(addressFuture::complete)).exceptionally(lookupException -> {
                                Throwable cause = FutureUtil.unwrapCompletionException(lookupException);
                                if (redirectCount > 0) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("[{}] lookup redirection failed ({}) : {}", new Object[]{topicName, redirectCount, cause.getMessage()});
                                    }
                                } else {
                                    log.warn("[{}] lookup failed : {}", new Object[]{topicName, cause.getMessage(), cause});
                                }
                                addressFuture.completeExceptionally(cause);
                                return null;
                            });
                        } else if (r.proxyThroughServiceUrl) {
                            addressFuture.complete(Pair.of(responseBrokerAddress, socketAddress));
                        } else {
                            addressFuture.complete(Pair.of(responseBrokerAddress, responseBrokerAddress));
                        }
                    }
                    catch (Exception parseUrlException) {
                        log.warn("[{}] invalid url {} : {}", new Object[]{topicName, uri, parseUrlException.getMessage(), parseUrlException});
                        addressFuture.completeExceptionally(parseUrlException);
                    }
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)clientCnx);
            });
        })).exceptionally(connectionException -> {
            addressFuture.completeExceptionally(FutureUtil.unwrapCompletionException(connectionException));
            return null;
        });
        return addressFuture;
    }

    private CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(InetSocketAddress socketAddress, TopicName topicName) {
        CompletableFuture<PartitionedTopicMetadata> partitionFuture = new CompletableFuture<PartitionedTopicMetadata>();
        ((CompletableFuture)this.client.getCnxPool().getConnection(socketAddress).thenAccept(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newPartitionMetadataRequest(topicName.toString(), requestId);
            clientCnx.newLookup(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    log.warn("[{}] failed to get Partitioned metadata : {}", new Object[]{topicName, t.getMessage(), t});
                    partitionFuture.completeExceptionally((Throwable)t);
                } else {
                    try {
                        partitionFuture.complete(new PartitionedTopicMetadata(r.partitions));
                    }
                    catch (Exception e) {
                        partitionFuture.completeExceptionally(new PulsarClientException.LookupException(String.format("Failed to parse partition-response redirect=%s, topic=%s, partitions with %s, error message %s", r.redirect, topicName, r.partitions, e.getMessage())));
                    }
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)clientCnx);
            });
        })).exceptionally(connectionException -> {
            partitionFuture.completeExceptionally(FutureUtil.unwrapCompletionException(connectionException));
            return null;
        });
        return partitionFuture;
    }

    @Override
    public CompletableFuture<Optional<SchemaInfo>> getSchema(TopicName topicName) {
        return this.getSchema(topicName, null);
    }

    @Override
    public CompletableFuture<Optional<SchemaInfo>> getSchema(TopicName topicName, byte[] version) {
        CompletableFuture<Optional<SchemaInfo>> schemaFuture = new CompletableFuture<Optional<SchemaInfo>>();
        if (version != null && version.length == 0) {
            schemaFuture.completeExceptionally(new SchemaSerializationException("Empty schema version"));
            return schemaFuture;
        }
        InetSocketAddress socketAddress = this.serviceNameResolver.resolveHost();
        ((CompletableFuture)this.client.getCnxPool().getConnection(socketAddress).thenAccept(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newGetSchema(requestId, topicName.toString(), Optional.ofNullable(BytesSchemaVersion.of(version)));
            clientCnx.sendGetSchema(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    log.warn("[{}] failed to get schema : {}", new Object[]{topicName, t.getMessage(), t});
                    schemaFuture.completeExceptionally((Throwable)t);
                } else {
                    schemaFuture.complete((Optional<SchemaInfo>)r);
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)clientCnx);
            });
        })).exceptionally(ex -> {
            schemaFuture.completeExceptionally(FutureUtil.unwrapCompletionException(ex));
            return null;
        });
        return schemaFuture;
    }

    @Override
    public String getServiceUrl() {
        return this.serviceNameResolver.getServiceUrl();
    }

    @Override
    public InetSocketAddress resolveHost() {
        return this.serviceNameResolver.resolveHost();
    }

    @Override
    public CompletableFuture<GetTopicsResult> getTopicsUnderNamespace(NamespaceName namespace, CommandGetTopicsOfNamespace.Mode mode, String topicsPattern, String topicsHash) {
        CompletableFuture<GetTopicsResult> topicsFuture = new CompletableFuture<GetTopicsResult>();
        AtomicLong opTimeoutMs = new AtomicLong(this.client.getConfiguration().getOperationTimeoutMs());
        Backoff backoff = new BackoffBuilder().setInitialTime(100L, TimeUnit.MILLISECONDS).setMandatoryStop(opTimeoutMs.get() * 2L, TimeUnit.MILLISECONDS).setMax(1L, TimeUnit.MINUTES).create();
        this.getTopicsUnderNamespace(this.serviceNameResolver.resolveHost(), namespace, backoff, opTimeoutMs, topicsFuture, mode, topicsPattern, topicsHash);
        return topicsFuture;
    }

    private void getTopicsUnderNamespace(InetSocketAddress socketAddress, NamespaceName namespace, Backoff backoff, AtomicLong remainingTime, CompletableFuture<GetTopicsResult> getTopicsResultFuture, CommandGetTopicsOfNamespace.Mode mode, String topicsPattern, String topicsHash) {
        ((CompletableFuture)this.client.getCnxPool().getConnection(socketAddress).thenAccept(clientCnx -> {
            long requestId = this.client.newRequestId();
            ByteBuf request = Commands.newGetTopicsOfNamespaceRequest(namespace.toString(), requestId, mode, topicsPattern, topicsHash);
            clientCnx.newGetTopicsOfNamespace(request, requestId).whenComplete((r, t) -> {
                if (t != null) {
                    getTopicsResultFuture.completeExceptionally((Throwable)t);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("[namespace: {}] Success get topics list in request: {}", (Object)namespace, (Object)requestId);
                    }
                    ArrayList<String> result = new ArrayList<String>();
                    r.getTopics().forEach(topic -> {
                        String filtered = TopicName.get(topic).getPartitionedTopicName();
                        if (!result.contains(filtered)) {
                            result.add(filtered);
                        }
                    });
                    getTopicsResultFuture.complete(new GetTopicsResult(result, r.getTopicsHash(), r.isFiltered(), r.isChanged()));
                }
                this.client.getCnxPool().releaseConnection((ClientCnx)clientCnx);
            });
        })).exceptionally(e -> {
            long nextDelay = Math.min(backoff.next(), remainingTime.get());
            if (nextDelay <= 0L) {
                getTopicsResultFuture.completeExceptionally(new PulsarClientException.TimeoutException(String.format("Could not get topics of namespace %s within configured timeout", namespace.toString())));
                return null;
            }
            ((ScheduledExecutorService)this.executor).schedule(() -> {
                log.warn("[namespace: {}] Could not get connection while getTopicsUnderNamespace -- Will try again in {} ms", (Object)namespace, (Object)nextDelay);
                remainingTime.addAndGet(-nextDelay);
                this.getTopicsUnderNamespace(socketAddress, namespace, backoff, remainingTime, getTopicsResultFuture, mode, topicsPattern, topicsHash);
            }, nextDelay, TimeUnit.MILLISECONDS);
            return null;
        });
    }

    @Override
    public void close() throws Exception {
    }

    public static class LookupDataResult {
        public final String brokerUrl;
        public final String brokerUrlTls;
        public final int partitions;
        public final boolean authoritative;
        public final boolean proxyThroughServiceUrl;
        public final boolean redirect;

        public LookupDataResult(CommandLookupTopicResponse result) {
            this.brokerUrl = result.hasBrokerServiceUrl() ? result.getBrokerServiceUrl() : null;
            this.brokerUrlTls = result.hasBrokerServiceUrlTls() ? result.getBrokerServiceUrlTls() : null;
            this.authoritative = result.isAuthoritative();
            this.redirect = result.hasResponse() && result.getResponse() == CommandLookupTopicResponse.LookupType.Redirect;
            this.proxyThroughServiceUrl = result.isProxyThroughServiceUrl();
            this.partitions = -1;
        }

        public LookupDataResult(int partitions) {
            this.partitions = partitions;
            this.brokerUrl = null;
            this.brokerUrlTls = null;
            this.authoritative = false;
            this.proxyThroughServiceUrl = false;
            this.redirect = false;
        }
    }
}

