/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.pulsar.broker.authentication.AuthenticationParameters;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.utils.ComponentTypeUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionConfigUtils;
import org.apache.pulsar.functions.utils.FunctionMetaDataUtils;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionsManager;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.RestUtils;
import org.apache.pulsar.functions.worker.rest.api.ComponentImpl;
import org.apache.pulsar.functions.worker.service.api.Functions;
import org.apache.pulsar.shade.com.google.protobuf.ByteString;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.javax.ws.rs.core.UriBuilder;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ExceptionInformation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImpl
extends ComponentImpl
implements Functions<PulsarWorkerService> {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImpl.class);

    public FunctionsImpl(Supplier<PulsarWorkerService> workerServiceSupplier) {
        super(workerServiceSupplier, Function.FunctionDetails.ComponentType.FUNCTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunction(String tenant, String namespace, String functionName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String functionPkgUrl, FunctionConfig functionConfig, AuthenticationParameters authParams) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (functionName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function name is not provided");
        }
        if (functionConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function config is not provided");
        }
        this.throwRestExceptionIfUnauthorizedForNamespace(tenant, namespace, functionName, "register", authParams);
        try {
            String qualifiedNamespaceWithCluster;
            this.worker().getBrokerAdmin().tenants().getTenantInfo(tenant);
            String qualifiedNamespace = tenant + "/" + namespace;
            List<String> namespaces = this.worker().getBrokerAdmin().namespaces().getNamespaces(tenant);
            if (namespaces != null && !namespaces.contains(qualifiedNamespace) && !namespaces.contains(qualifiedNamespaceWithCluster = String.format("%s/%s/%s", tenant, this.worker().getWorkerConfig().getPulsarFunctionsCluster(), namespace))) {
                log.error("{}/{}/{} Namespace {} does not exist", new Object[]{tenant, namespace, functionName, namespace});
                throw new RestException(Response.Status.BAD_REQUEST, "Namespace does not exist");
            }
        }
        catch (PulsarAdminException.NotAuthorizedException e) {
            log.error("{}/{}/{} Client is not authorized to operate {} on tenant", new Object[]{tenant, namespace, functionName, ComponentTypeUtils.toString(this.componentType)});
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        catch (PulsarAdminException.NotFoundException e) {
            log.error("{}/{}/{} Tenant {} does not exist", new Object[]{tenant, namespace, functionName, tenant});
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant does not exist");
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Issues getting tenant data", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (functionMetaDataManager.containsFunction(tenant, namespace, functionName)) {
            log.error("{} {}/{}/{} already exists", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s already exists", ComponentTypeUtils.toString(this.componentType), functionName));
        }
        boolean isPkgUrlProvided = StringUtils.isNotBlank(functionPkgUrl);
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            Function.FunctionDetails functionDetails;
            block30: {
                try {
                    if (isPkgUrlProvided) {
                        if (Utils.hasPackageTypePrefix(functionPkgUrl)) {
                            componentPackageFile = this.downloadPackageFile(functionPkgUrl);
                        } else {
                            if (!Utils.isFunctionPackageUrlSupported(functionPkgUrl)) {
                                throw new IllegalArgumentException("Function Package url is not valid.supported url (http/https/file)");
                            }
                            try {
                                componentPackageFile = FunctionCommon.extractFileFromPkgURL(functionPkgUrl);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString(this.componentType), functionPkgUrl), e);
                            }
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, functionConfig, componentPackageFile);
                        break block30;
                    }
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                    }
                    if (!(FunctionCommon.isFunctionCodeBuiltin(functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, functionConfig, componentPackageFile)) || componentPackageFile != null && fileDetail != null)) {
                        throw new IllegalArgumentException(ComponentTypeUtils.toString(this.componentType) + " Package is not provided");
                    }
                }
                catch (Exception e) {
                    log.error("Invalid register {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName, e});
                    throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
                }
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("{} {}/{}/{} cannot be admitted by the runtime factory", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString(this.componentType), functionName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().setFunctionDetails(functionDetails).setCreateTime(System.currentTimeMillis()).setVersion(0L);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (authParams.getClientAuthenticationDataSource() != null) {
                        try {
                            Optional<FunctionAuthData> functionAuthData = functionAuthProvider.cacheAuthData(finalFunctionDetails, authParams.getClientAuthenticationDataSource());
                            functionAuthData.ifPresent(authData -> functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom(authData.getData())).build()));
                        }
                        catch (Exception e) {
                            log.error("Error caching authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString(this.componentType), functionName, e.getMessage()));
                        }
                    }
                });
            }
            try {
                packageLocationMetaDataBuilder = this.getFunctionPackageLocation(functionMetaDataBuilder.build(), functionPkgUrl, fileDetail, componentPackageFile);
            }
            catch (Exception e) {
                log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName, e});
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(null, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (functionPkgUrl == null || !functionPkgUrl.startsWith("file"))) {
                componentPackageFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFunction(String tenant, String namespace, String functionName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String functionPkgUrl, FunctionConfig functionConfig, AuthenticationParameters authParams, UpdateOptionsImpl updateOptions) {
        FunctionConfig mergedConfig;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (functionName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function name is not provided");
        }
        if (functionConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function config is not provided");
        }
        this.throwRestExceptionIfUnauthorizedForNamespace(tenant, namespace, functionName, "update", authParams);
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, functionName)) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s doesn't exist", ComponentTypeUtils.toString(this.componentType), functionName));
        }
        Function.FunctionMetaData existingComponent = functionMetaDataManager.getFunctionMetaData(tenant, namespace, functionName);
        if (!InstanceUtils.calculateSubjectType(existingComponent.getFunctionDetails()).equals(this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, functionName, ComponentTypeUtils.toString(this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString(this.componentType), functionName));
        }
        FunctionConfig existingFunctionConfig = FunctionConfigUtils.convertFromDetails(existingComponent.getFunctionDetails());
        functionConfig.setTenant(tenant);
        functionConfig.setNamespace(namespace);
        functionConfig.setName(functionName);
        try {
            mergedConfig = FunctionConfigUtils.validateUpdate(existingFunctionConfig, functionConfig);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        if (existingFunctionConfig.equals(mergedConfig) && StringUtils.isBlank(functionPkgUrl) && uploadedInputStream == null) {
            log.error("{}/{}/{} Update contains no changes", new Object[]{tenant, namespace, functionName});
            throw new RestException(Response.Status.BAD_REQUEST, "Update contains no change");
        }
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            Function.FunctionDetails functionDetails;
            block38: {
                try {
                    if (StringUtils.isNotBlank(functionPkgUrl)) {
                        if (Utils.hasPackageTypePrefix(functionPkgUrl)) {
                            componentPackageFile = this.downloadPackageFile(functionPkgUrl);
                        } else {
                            try {
                                componentPackageFile = FunctionCommon.extractFileFromPkgURL(functionPkgUrl);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString(this.componentType), functionPkgUrl));
                            }
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                        break block38;
                    }
                    if (existingComponent.getPackageLocation().getPackagePath().startsWith("file") || existingComponent.getPackageLocation().getPackagePath().startsWith("http")) {
                        try {
                            componentPackageFile = FunctionCommon.extractFileFromPkgURL(existingComponent.getPackageLocation().getPackagePath());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString(this.componentType), functionPkgUrl));
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                        break block38;
                    }
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                    } else if (existingComponent.getPackageLocation().getPackagePath().startsWith("builtin")) {
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                        if (!(FunctionCommon.isFunctionCodeBuiltin(functionDetails) || componentPackageFile != null && fileDetail != null)) {
                            throw new IllegalArgumentException(ComponentTypeUtils.toString(this.componentType) + " Package is not provided");
                        }
                    } else {
                        componentPackageFile = FunctionCommon.createPkgTempFile();
                        componentPackageFile.deleteOnExit();
                        if (this.worker().getWorkerConfig().isFunctionsWorkerEnablePackageManagement()) {
                            this.worker().getBrokerAdmin().packages().download(existingComponent.getPackageLocation().getPackagePath(), componentPackageFile.getAbsolutePath());
                        } else {
                            WorkerUtils.downloadFromBookkeeper(this.worker().getDlogNamespace(), componentPackageFile, existingComponent.getPackageLocation().getPackagePath());
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                    }
                }
                catch (Exception e) {
                    log.error("Invalid update {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName, e});
                    throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
                }
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("Updated {} {}/{}/{} cannot be submitted to runtime factory", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString(this.componentType), functionName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().mergeFrom(existingComponent).setFunctionDetails(functionDetails);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (authParams.getClientAuthenticationDataSource() != null && updateOptions != null && updateOptions.isUpdateAuthData()) {
                        Optional<FunctionAuthData> existingFunctionAuthData = Optional.empty();
                        if (functionMetaDataBuilder.hasFunctionAuthSpec()) {
                            existingFunctionAuthData = Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(functionMetaDataBuilder.getFunctionAuthSpec())));
                        }
                        try {
                            Optional<FunctionAuthData> newFunctionAuthData = functionAuthProvider.updateAuthData(finalFunctionDetails, existingFunctionAuthData, authParams.getClientAuthenticationDataSource());
                            if (newFunctionAuthData.isPresent()) {
                                functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom(newFunctionAuthData.get().getData())).build());
                            } else {
                                functionMetaDataBuilder.clearFunctionAuthSpec();
                            }
                        }
                        catch (Exception e) {
                            log.error("Error updating authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString(this.componentType), functionName, e.getMessage()));
                        }
                    }
                });
            }
            if (StringUtils.isNotBlank(functionPkgUrl) || uploadedInputStream != null) {
                Function.FunctionMetaData metaData = functionMetaDataBuilder.build();
                metaData = FunctionMetaDataUtils.incrMetadataVersion(metaData, metaData);
                try {
                    packageLocationMetaDataBuilder = this.getFunctionPackageLocation(metaData, functionPkgUrl, fileDetail, componentPackageFile);
                }
                catch (Exception e) {
                    log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString(this.componentType), tenant, namespace, functionName, e});
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            } else {
                packageLocationMetaDataBuilder = Function.PackageLocationMetaData.newBuilder().mergeFrom(existingComponent.getPackageLocation());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(existingComponent, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (functionPkgUrl != null && !functionPkgUrl.startsWith("file") || uploadedInputStream != null)) {
                componentPackageFile.delete();
            }
        }
    }

    private ExceptionInformation getExceptionInformation(InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry) {
        ExceptionInformation exceptionInformation = new ExceptionInformation();
        exceptionInformation.setTimestampMs(exceptionEntry.getMsSinceEpoch());
        exceptionInformation.setExceptionString(exceptionEntry.getExceptionString());
        return exceptionInformation;
    }

    @Override
    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionInstanceStatus(String tenant, String namespace, String componentName, String instanceId, URI uri, AuthenticationParameters authParams) {
        FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData;
        this.componentInstanceStatusRequestValidate(tenant, namespace, componentName, Integer.parseInt(instanceId), authParams);
        try {
            functionInstanceStatusData = (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)new GetFunctionStatus().getComponentInstanceStatus(tenant, namespace, componentName, Integer.parseInt(instanceId), uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return functionInstanceStatusData;
    }

    @Override
    public FunctionStatus getFunctionStatus(String tenant, String namespace, String componentName, URI uri, AuthenticationParameters authParams) {
        FunctionStatus functionStatus;
        this.componentStatusRequestValidate(tenant, namespace, componentName, authParams);
        try {
            functionStatus = (FunctionStatus)new GetFunctionStatus().getComponentStatus(tenant, namespace, componentName, uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return functionStatus;
    }

    @Override
    public void updateFunctionOnWorkerLeader(String tenant, String namespace, String functionName, InputStream uploadedInputStream, boolean delete, URI uri, AuthenticationParameters authParams) {
        Function.FunctionMetaData functionMetaData;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(authParams)) {
            log.error("{}/{}/{} Client with role [{}] and originalPrincipal [{}] is not superuser to update on worker leader {}", new Object[]{tenant, namespace, functionName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource(), ComponentTypeUtils.toString(this.componentType)});
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (functionName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function name is not provided");
        }
        try {
            functionMetaData = Function.FunctionMetaData.parseFrom(uploadedInputStream);
        }
        catch (IOException e) {
            throw new RestException(Response.Status.BAD_REQUEST, "Corrupt Function MetaData");
        }
        if (!this.worker().getLeaderService().isLeader()) {
            WorkerInfo workerInfo = this.worker().getMembershipManager().getLeader();
            if (workerInfo == null || workerInfo.getWorkerId().equals(this.worker().getWorkerConfig().getWorkerId())) {
                throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Leader not yet ready. Please retry again");
            }
            URI redirect = UriBuilder.fromUri(uri).host(workerInfo.getWorkerHostname()).port(workerInfo.getPort()).build(new Object[0]);
            throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        try {
            functionMetaDataManager.updateFunctionOnLeader(functionMetaData, delete);
        }
        catch (IllegalStateException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function.FunctionDetails validateUpdateRequestParams(String tenant, String namespace, String componentName, FunctionConfig functionConfig, File componentPackageFile) {
        Function.FunctionDetails functionDetails;
        block10: {
            boolean shouldCloseClassLoader;
            ClassLoader classLoader;
            block8: {
                Function.FunctionDetails functionDetails2;
                block9: {
                    functionConfig.setTenant(tenant);
                    functionConfig.setNamespace(namespace);
                    functionConfig.setName(componentName);
                    FunctionConfigUtils.inferMissingArguments(functionConfig, this.worker().getWorkerConfig().isForwardSourceMessageProperty());
                    String archive = functionConfig.getJar();
                    classLoader = null;
                    if (!StringUtils.isEmpty(archive) && archive.startsWith("builtin")) {
                        archive = archive.replaceFirst("^builtin://", "");
                        FunctionsManager functionsManager = this.worker().getFunctionsManager();
                        FunctionArchive function = functionsManager.getFunction(archive);
                        if (function == null) {
                            throw new IllegalArgumentException(String.format("No Function %s found", archive));
                        }
                        classLoader = function.getClassLoader();
                    }
                    shouldCloseClassLoader = false;
                    try {
                        if (functionConfig.getRuntime() != FunctionConfig.Runtime.JAVA) break block8;
                        if (classLoader == null && componentPackageFile != null) {
                            classLoader = this.getClassLoaderFromPackage(functionConfig.getClassName(), componentPackageFile, this.worker().getWorkerConfig().getNarExtractionDirectory());
                            shouldCloseClassLoader = true;
                        }
                        if (classLoader == null) {
                            throw new IllegalArgumentException("Function package is not provided");
                        }
                        FunctionConfigUtils.ExtractedFunctionDetails functionDetails3 = FunctionConfigUtils.validateJavaFunction(functionConfig, classLoader);
                        functionDetails2 = FunctionConfigUtils.convert(functionConfig, functionDetails3);
                        if (!shouldCloseClassLoader) break block9;
                    }
                    catch (Throwable throwable) {
                        if (shouldCloseClassLoader) {
                            ClassLoaderUtils.closeClassLoader(classLoader);
                        }
                        throw throwable;
                    }
                    ClassLoaderUtils.closeClassLoader(classLoader);
                }
                return functionDetails2;
            }
            classLoader = FunctionConfigUtils.validate(functionConfig, componentPackageFile);
            shouldCloseClassLoader = true;
            functionDetails = FunctionConfigUtils.convert(functionConfig, classLoader);
            if (!shouldCloseClassLoader) break block10;
            ClassLoaderUtils.closeClassLoader(classLoader);
        }
        return functionDetails;
    }

    private File downloadPackageFile(String packageName) throws IOException, PulsarAdminException {
        return FunctionsImpl.downloadPackageFile(this.worker(), packageName);
    }

    static File downloadPackageFile(PulsarWorkerService worker, String packageName) throws IOException, PulsarAdminException {
        Path tempDirectory = worker.getWorkerConfig().getDownloadDirectory() != null ? Paths.get(worker.getWorkerConfig().getDownloadDirectory(), new String[0]) : Paths.get(worker.getWorkerConfig().getNarExtractionDirectory(), new String[0]);
        Files.createDirectories(tempDirectory, new FileAttribute[0]);
        File file = Files.createTempFile(tempDirectory, "function", ".tmp", new FileAttribute[0]).toFile();
        worker.getBrokerAdmin().packages().download(packageName, file.toString());
        return file;
    }

    private class GetFunctionStatus
    extends ComponentImpl.GetStatus<FunctionStatus, FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> {
        private GetFunctionStatus() {
            super(FunctionsImpl.this);
        }

        @Override
        public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData notScheduledInstance() {
            FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
            functionInstanceStatusData.setRunning(false);
            functionInstanceStatusData.setError("Function has not been scheduled");
            return functionInstanceStatusData;
        }

        @Override
        public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData fromFunctionStatusProto(InstanceCommunication.FunctionStatus status, String assignedWorkerId) {
            ExceptionInformation exceptionInformation;
            FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
            functionInstanceStatusData.setRunning(status.getRunning());
            functionInstanceStatusData.setError(status.getFailureException());
            functionInstanceStatusData.setNumRestarts(status.getNumRestarts());
            functionInstanceStatusData.setNumReceived(status.getNumReceived());
            functionInstanceStatusData.setNumSuccessfullyProcessed(status.getNumSuccessfullyProcessed());
            functionInstanceStatusData.setNumUserExceptions(status.getNumUserExceptions());
            LinkedList<ExceptionInformation> userExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestUserExceptionsList()) {
                ExceptionInformation exceptionInformation2 = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                userExceptionInformationList.add(exceptionInformation2);
            }
            functionInstanceStatusData.setLatestUserExceptions(userExceptionInformationList);
            functionInstanceStatusData.setNumSystemExceptions(status.getNumSystemExceptions() + status.getNumSourceExceptions() + status.getNumSinkExceptions());
            LinkedList<ExceptionInformation> systemExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSystemExceptionsList()) {
                exceptionInformation = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSourceExceptionsList()) {
                exceptionInformation = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSinkExceptionsList()) {
                exceptionInformation = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            functionInstanceStatusData.setLatestSystemExceptions(systemExceptionInformationList);
            functionInstanceStatusData.setAverageLatency(status.getAverageLatency());
            functionInstanceStatusData.setLastInvocationTime(status.getLastInvocationTime());
            functionInstanceStatusData.setWorkerId(assignedWorkerId);
            return functionInstanceStatusData;
        }

        @Override
        public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData notRunning(String assignedWorkerId, String error) {
            FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
            functionInstanceStatusData.setRunning(false);
            if (error != null) {
                functionInstanceStatusData.setError(error);
            }
            functionInstanceStatusData.setWorkerId(assignedWorkerId);
            return functionInstanceStatusData;
        }

        @Override
        public FunctionStatus getStatus(String tenant, String namespace, String name, Collection<Function.Assignment> assignments, URI uri) throws PulsarAdminException {
            FunctionStatus functionStatus = new FunctionStatus();
            for (Function.Assignment assignment : assignments) {
                boolean isOwner = FunctionsImpl.this.worker().getWorkerConfig().getWorkerId().equals(assignment.getWorkerId());
                FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = isOwner ? (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, assignment.getInstance().getInstanceId(), null) : FunctionsImpl.this.worker().getFunctionAdmin().functions().getFunctionStatus(assignment.getInstance().getFunctionMetaData().getFunctionDetails().getTenant(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getNamespace(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getName(), assignment.getInstance().getInstanceId());
                FunctionStatus.FunctionInstanceStatus instanceStatus = new FunctionStatus.FunctionInstanceStatus();
                instanceStatus.setInstanceId(assignment.getInstance().getInstanceId());
                instanceStatus.setStatus(functionInstanceStatusData);
                functionStatus.addInstance(instanceStatus);
            }
            functionStatus.setNumInstances(functionStatus.instances.size());
            functionStatus.getInstances().forEach(functionInstanceStatus -> {
                if (functionInstanceStatus.getStatus().isRunning()) {
                    ++functionStatus.numRunning;
                }
            });
            return functionStatus;
        }

        @Override
        public FunctionStatus getStatusExternal(String tenant, String namespace, String name, int parallelism) {
            FunctionStatus functionStatus = new FunctionStatus();
            for (int i = 0; i < parallelism; ++i) {
                FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, i, null);
                FunctionStatus.FunctionInstanceStatus functionInstanceStatus2 = new FunctionStatus.FunctionInstanceStatus();
                functionInstanceStatus2.setInstanceId(i);
                functionInstanceStatus2.setStatus(functionInstanceStatusData);
                functionStatus.addInstance(functionInstanceStatus2);
            }
            functionStatus.setNumInstances(functionStatus.instances.size());
            functionStatus.getInstances().forEach(functionInstanceStatus -> {
                if (functionInstanceStatus.getStatus().isRunning()) {
                    ++functionStatus.numRunning;
                }
            });
            return functionStatus;
        }

        @Override
        public FunctionStatus emptyStatus(int parallelism) {
            FunctionStatus functionStatus = new FunctionStatus();
            functionStatus.setNumInstances(parallelism);
            functionStatus.setNumRunning(0);
            for (int i = 0; i < parallelism; ++i) {
                FunctionStatus.FunctionInstanceStatus functionInstanceStatus = new FunctionStatus.FunctionInstanceStatus();
                functionInstanceStatus.setInstanceId(i);
                FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
                functionInstanceStatusData.setRunning(false);
                functionInstanceStatusData.setError("Function has not been scheduled");
                functionInstanceStatus.setStatus(functionInstanceStatusData);
                functionStatus.addInstance(functionInstanceStatus);
            }
            return functionStatus;
        }
    }
}

