/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Arrays;
import org.apache.pulsar.shade.com.carrotsearch.hppc.FloatCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.FloatLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.FloatCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.FloatPredicate;

abstract class AbstractFloatCollection
implements FloatCollection {
    AbstractFloatCollection() {
    }

    @Override
    public int removeAll(FloatLookupContainer c) {
        return this.removeAll(c::contains);
    }

    @Override
    public int retainAll(FloatLookupContainer c) {
        return this.removeAll((float k) -> !c.contains(k));
    }

    @Override
    public int retainAll(FloatPredicate predicate) {
        return this.removeAll((float value) -> !predicate.apply(value));
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size()];
        int i = 0;
        for (FloatCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

