/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Arrays;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ShortCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ShortPredicate;

abstract class AbstractShortCollection
implements ShortCollection {
    AbstractShortCollection() {
    }

    @Override
    public int removeAll(ShortLookupContainer c) {
        return this.removeAll(c::contains);
    }

    @Override
    public int retainAll(ShortLookupContainer c) {
        return this.removeAll((short k) -> !c.contains(k));
    }

    @Override
    public int retainAll(ShortPredicate predicate) {
        return this.removeAll((short value) -> !predicate.apply(value));
    }

    @Override
    public short[] toArray() {
        short[] array = new short[this.size()];
        int i = 0;
        for (ShortCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

