/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectIntAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectIntHashMap;

public class ObjectIntIdentityHashMap<KType>
extends ObjectIntHashMap<KType> {
    public ObjectIntIdentityHashMap() {
        this(4);
    }

    public ObjectIntIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectIntIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectIntIdentityHashMap(ObjectIntAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mixPhi(System.identityHashCode(key));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectIntIdentityHashMap<KType> from(KType[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectIntIdentityHashMap<KType> map = new ObjectIntIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

