/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractCharCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractLongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.CharContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCharAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCharHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCharMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.LongCharComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.LongComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.CharCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongCharCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.CharPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongCharPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.CharProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongCharProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.sorting.QuickSort;

public class SortedIterationLongCharHashMap
implements LongCharMap {
    public final LongCharHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongCharHashMap(LongCharHashMap delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongCharHashMap(LongCharHashMap delegate, LongCharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongCharComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final char[] values;
            {
                this.keys = SortedIterationLongCharHashMap.this.delegate.keys;
                this.values = SortedIterationLongCharHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongCharCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongCharPredicate predicate) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public <T extends LongCharProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongCharPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public CharContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public char get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public char getOrDefault(long key, char defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public char put(long key, char value) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongCharAssociativeContainer container) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongCharCursor> iterable) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public char putOrAdd(long key, char putValue, char incrementValue) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public char addTo(long key, char additionValue) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public char remove(long key) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public char indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public char indexReplace(int index, char newValue) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, char value) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public char indexRemove(int index) {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongCharHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongCharCursor> {
        private final LongCharCursor cursor = new LongCharCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongCharCursor fetch() {
            if (this.index < SortedIterationLongCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongCharHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongCharHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongCharCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongCharHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongCharHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final SortedIterationLongCharHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (LongCharCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongCharHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationLongCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongCharHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

