/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractLongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractObjectCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongObjectAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongObjectHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongObjectMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.LongComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.LongObjectComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongObjectCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongObjectPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ObjectPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongObjectProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ObjectProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.sorting.QuickSort;

public class SortedIterationLongObjectHashMap<VType>
implements LongObjectMap<VType> {
    public final LongObjectHashMap<VType> delegate;
    public final int[] iterationOrder;

    public SortedIterationLongObjectHashMap(LongObjectHashMap<VType> delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongObjectHashMap(LongObjectHashMap<VType> delegate, LongObjectComparator<VType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongObjectComparator<VType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final VType[] values;
            {
                this.keys = SortedIterationLongObjectHashMap.this.delegate.keys;
                this.values = SortedIterationLongObjectHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongObjectPredicate<? super VType> predicate) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public <T extends LongObjectProcedure<? super VType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], (Object)values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongObjectPredicate<? super VType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], (Object)values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public VType get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public VType getOrDefault(long key, VType defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public VType put(long key, VType value) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongObjectAssociativeContainer<? extends VType> container) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongObjectCursor<? extends VType>> iterable) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public VType remove(long key) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public VType indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, VType value) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public VType indexRemove(int index) {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongObjectHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        private final LongObjectCursor<VType> cursor = new LongObjectCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongObjectCursor<VType> fetch() {
            if (this.index < SortedIterationLongObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongObjectHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongObjectCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongObjectHashMap<VType> owner;

        private KeysContainer() {
            this.owner = SortedIterationLongObjectHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final SortedIterationLongObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (LongObjectCursor c : this.owner) {
                if (!Objects.equals(value, c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(VType e) {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.index < SortedIterationLongObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongObjectHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

