/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractByteCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractShortCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ByteContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortByteAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortByteHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortByteMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.ShortByteComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.ShortComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ByteCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ShortByteCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ShortCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.BytePredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ShortBytePredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ShortPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ByteProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ShortByteProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ShortProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.sorting.QuickSort;

public class SortedIterationShortByteHashMap
implements ShortByteMap {
    public final ShortByteHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortByteHashMap(ShortByteHashMap delegate, ShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortByteHashMap(ShortByteHashMap delegate, ShortByteComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortByteComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final byte[] values;
            {
                this.keys = SortedIterationShortByteHashMap.this.delegate.keys;
                this.values = SortedIterationShortByteHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortByteCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortBytePredicate predicate) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortByteProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortBytePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ByteContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public byte get(short key) {
        return this.delegate.get(key);
    }

    @Override
    public byte getOrDefault(short key, byte defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public byte put(short key, byte value) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortByteAssociativeContainer container) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortByteCursor> iterable) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public byte putOrAdd(short key, byte putValue, byte incrementValue) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public byte addTo(short key, byte additionValue) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public byte remove(short key) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public byte indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key, byte value) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public byte indexRemove(int index) {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortByteHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortByteCursor> {
        private final ShortByteCursor cursor = new ShortByteCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortByteCursor fetch() {
            if (this.index < SortedIterationShortByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortByteHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortByteHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortByteCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortByteHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortByteHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final SortedIterationShortByteHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (ShortByteCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortByteHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ByteCursor fetch() {
            if (this.index < SortedIterationShortByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortByteHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

