/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.shade.com.yahoo.sketches.ResizeFactor;
import org.apache.pulsar.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.DirectQuickSelectSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.HeapAlphaSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.HeapQuickSelectSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.theta.UpdateSketch;

public class UpdateSketchBuilder {
    private int bLgNomLongs = Integer.numberOfTrailingZeros(4096);
    private long bSeed = 9001L;
    private ResizeFactor bRF = ResizeFactor.X8;
    private Family bFam = Family.QUICKSELECT;
    private float bP = 1.0f;
    private Memory bDstMem = null;

    public UpdateSketchBuilder setNominalEntries(int nomEntries) {
        this.bLgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries));
        return this;
    }

    public int getLgNominalEntries() {
        return this.bLgNomLongs;
    }

    public UpdateSketchBuilder setSeed(long seed) {
        this.bSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.bSeed;
    }

    public UpdateSketchBuilder setP(float p) {
        if ((double)p <= 0.0 || (double)p > 1.0) {
            throw new SketchesArgumentException("p must be > 0 and <= 1.0: " + p);
        }
        this.bP = p;
        return this;
    }

    public float getP() {
        return this.bP;
    }

    public UpdateSketchBuilder setResizeFactor(ResizeFactor rf) {
        this.bRF = rf;
        return this;
    }

    public ResizeFactor getResizeFactor() {
        return this.bRF;
    }

    public UpdateSketchBuilder setFamily(Family family) {
        this.bFam = family;
        return this;
    }

    public Family getFamily() {
        return this.bFam;
    }

    public UpdateSketchBuilder initMemory(Memory dstMem) {
        this.bDstMem = dstMem;
        return this;
    }

    public Memory getMemory() {
        return this.bDstMem;
    }

    public UpdateSketch build() {
        UpdateSketch sketch = null;
        switch (this.bFam) {
            case ALPHA: {
                if (this.bDstMem == null) {
                    sketch = HeapAlphaSketch.getInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF);
                    break;
                }
                throw new SketchesArgumentException("AlphaSketch cannot be made Direct to Memory.");
            }
            case QUICKSELECT: {
                if (this.bDstMem == null) {
                    sketch = HeapQuickSelectSketch.getInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, false);
                    break;
                }
                sketch = DirectQuickSelectSketch.getInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, this.bDstMem, false);
                break;
            }
            default: {
                throw new SketchesArgumentException("Given Family cannot be built as a Theta Sketch: " + this.bFam.toString());
            }
        }
        return sketch;
    }

    public UpdateSketch build(int nomEntries) {
        this.bLgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries));
        return this.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSketchBuilder configuration:").append(Util.LS).append("LgK:").append('\t').append(this.bLgNomLongs).append(Util.LS).append("K:").append('\t').append(1 << this.bLgNomLongs).append(Util.LS).append("Seed:").append('\t').append(this.bSeed).append(Util.LS).append("p:").append('\t').append(this.bP).append(Util.LS).append("ResizeFactor:").append('\t').append((Object)this.bRF).append(Util.LS).append("Family:").append('\t').append((Object)this.bFam).append(Util.LS).append("DstMemory:").append('\t').append(this.bDstMem != null).append(Util.LS);
        return sb.toString();
    }
}

