/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.FileInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileInfoBackingCache {
    private static final Logger log = LoggerFactory.getLogger(FileInfoBackingCache.class);
    static final int DEAD_REF = -57005;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final ConcurrentLongHashMap<CachedFileInfo> fileInfos = ConcurrentLongHashMap.newBuilder().build();
    final FileLoader fileLoader;
    final int fileInfoVersionToWrite;

    FileInfoBackingCache(FileLoader fileLoader, int fileInfoVersionToWrite) {
        this.fileLoader = fileLoader;
        this.fileInfoVersionToWrite = fileInfoVersionToWrite;
    }

    private static CachedFileInfo tryRetainFileInfo(CachedFileInfo fi) throws IOException {
        boolean retained = fi.tryRetain();
        if (!retained) {
            throw new IOException("FileInfo " + fi + " is already marked dead");
        }
        if (fi.isDeleted()) {
            throw new Bookie.NoLedgerException(fi.ledgerId);
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedFileInfo loadFileInfo(long ledgerId, byte[] masterKey) throws IOException {
        this.lock.readLock().lock();
        try {
            CachedFileInfo fi = this.fileInfos.get(ledgerId);
            if (fi != null) {
                CachedFileInfo cachedFileInfo = FileInfoBackingCache.tryRetainFileInfo(fi);
                return cachedFileInfo;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        File backingFile = this.fileLoader.load(ledgerId, masterKey != null);
        CachedFileInfo newFi = new CachedFileInfo(ledgerId, backingFile, masterKey);
        this.lock.writeLock().lock();
        try {
            CachedFileInfo fi = this.fileInfos.get(ledgerId);
            if (fi != null) {
                newFi.recycle();
            } else {
                this.fileInfos.put(ledgerId, newFi);
                fi = newFi;
            }
            CachedFileInfo cachedFileInfo = FileInfoBackingCache.tryRetainFileInfo(fi);
            return cachedFileInfo;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFileInfo(long ledgerId, CachedFileInfo fileInfo) {
        this.lock.writeLock().lock();
        try {
            if (fileInfo.markDead()) {
                fileInfo.close(true);
                this.fileInfos.remove(ledgerId, fileInfo);
            }
        }
        catch (IOException ioe) {
            log.error("Error evicting file info({}) for ledger {} from backing cache", new Object[]{fileInfo, ledgerId, ioe});
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void closeAllWithoutFlushing() throws IOException {
        try {
            this.fileInfos.forEach((key, fileInfo) -> {
                try {
                    fileInfo.close(false);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException uioe) {
            throw uioe.getCause();
        }
    }

    static interface FileLoader {
        public File load(long var1, boolean var3) throws IOException;
    }

    class CachedFileInfo
    extends FileInfo {
        final long ledgerId;
        final AtomicInteger refCount;

        CachedFileInfo(long ledgerId, File lf, byte[] masterKey) throws IOException {
            super(lf, masterKey, FileInfoBackingCache.this.fileInfoVersionToWrite);
            this.ledgerId = ledgerId;
            this.refCount = new AtomicInteger(0);
        }

        private boolean markDead() {
            return this.refCount.compareAndSet(0, -57005);
        }

        boolean tryRetain() {
            int count;
            do {
                if ((count = this.refCount.get()) >= 0) continue;
                return false;
            } while (!this.refCount.compareAndSet(count, count + 1));
            return true;
        }

        int getRefCount() {
            return this.refCount.get();
        }

        void release() {
            if (this.refCount.decrementAndGet() == 0) {
                FileInfoBackingCache.this.releaseFileInfo(this.ledgerId, this);
            }
        }

        public String toString() {
            return "CachedFileInfo(ledger=" + this.ledgerId + ",refCount=" + this.refCount.get() + ",closed=" + this.isClosed() + ",id=" + System.identityHashCode(this) + ")";
        }
    }
}

