/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.EntryLogMetadataMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.LongWrapper;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentEntryLogMetadataMap
implements EntryLogMetadataMap {
    private static final Logger log = LoggerFactory.getLogger(PersistentEntryLogMetadataMap.class);
    private final KeyValueStorage metadataMapDB;
    private AtomicBoolean isClosed = new AtomicBoolean(false);
    private static final FastThreadLocal<ByteArrayOutputStream> baos = new FastThreadLocal<ByteArrayOutputStream>(){

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream();
        }
    };
    private static final FastThreadLocal<ByteArrayInputStream> bais = new FastThreadLocal<ByteArrayInputStream>(){

        @Override
        protected ByteArrayInputStream initialValue() {
            return new ByteArrayInputStream(new byte[1]);
        }
    };
    private static final FastThreadLocal<DataOutputStream> dataos = new FastThreadLocal<DataOutputStream>(){

        @Override
        protected DataOutputStream initialValue() {
            return new DataOutputStream((OutputStream)baos.get());
        }
    };
    private static final FastThreadLocal<DataInputStream> datais = new FastThreadLocal<DataInputStream>(){

        @Override
        protected DataInputStream initialValue() {
            return new DataInputStream((InputStream)bais.get());
        }
    };

    public PersistentEntryLogMetadataMap(String metadataPath, ServerConfiguration conf) throws IOException {
        log.info("Loading persistent entrylog metadata-map from {}/{}", (Object)metadataPath, (Object)"metadata-cache");
        File dir = new File(metadataPath);
        if (!dir.mkdirs() && !dir.exists()) {
            String err = "Unable to create directory " + dir;
            log.error(err);
            throw new IOException(err);
        }
        this.metadataMapDB = KeyValueStorageRocksDB.factory.newKeyValueStorage(metadataPath, "metadata-cache", KeyValueStorageFactory.DbConfigType.Default, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long entryLogId) throws BookieException.EntryLogMetadataMapException {
        this.throwIfClosed();
        LongWrapper key = LongWrapper.get(entryLogId);
        try {
            boolean isExist;
            try {
                isExist = this.metadataMapDB.get(key.array) != null;
            }
            catch (IOException e) {
                throw new BookieException.EntryLogMetadataMapException(e);
            }
            boolean bl = isExist;
            return bl;
        }
        finally {
            key.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(long entryLogId, EntryLogMetadata entryLogMeta) throws BookieException.EntryLogMetadataMapException {
        this.throwIfClosed();
        LongWrapper key = LongWrapper.get(entryLogId);
        try {
            baos.get().reset();
            try {
                entryLogMeta.serialize(dataos.get());
                this.metadataMapDB.put(key.array, baos.get().toByteArray());
            }
            catch (IOException | IllegalStateException e) {
                log.error("Failed to serialize entrylog-metadata, entryLogId {}", (Object)entryLogId);
                throw new BookieException.EntryLogMetadataMapException(e);
            }
        }
        finally {
            key.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<Long, EntryLogMetadata> action) throws BookieException.EntryLogMetadataMapException {
        this.throwIfClosed();
        KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>> iterator = this.metadataMapDB.iterator();
        try {
            while (iterator.hasNext()) {
                if (this.isClosed.get()) {
                    break;
                }
                Map.Entry<byte[], byte[]> entry = iterator.next();
                long entryLogId = ArrayUtil.getLong(entry.getKey(), 0);
                EntryLogMetadata.EntryLogMetadataRecyclable metadata = this.getEntryLogMetadataRecyclable(entry.getValue());
                try {
                    action.accept(entryLogId, metadata);
                }
                finally {
                    metadata.recycle();
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to iterate over entry-log metadata map {}", (Object)e.getMessage(), (Object)e);
            throw new BookieException.EntryLogMetadataMapException(e);
        }
        finally {
            try {
                iterator.close();
            }
            catch (IOException e) {
                log.error("Failed to close entry-log metadata-map rocksDB iterator {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forKey(long entryLogId, BiConsumer<Long, EntryLogMetadata> action) throws BookieException.EntryLogMetadataMapException {
        this.throwIfClosed();
        LongWrapper key = LongWrapper.get(entryLogId);
        try {
            byte[] value = this.metadataMapDB.get(key.array);
            if (value == null || value.length == 0) {
                action.accept(entryLogId, null);
                return;
            }
            EntryLogMetadata.EntryLogMetadataRecyclable metadata = this.getEntryLogMetadataRecyclable(value);
            try {
                action.accept(entryLogId, metadata);
            }
            finally {
                metadata.recycle();
            }
        }
        catch (IOException e) {
            log.error("Failed to get metadata for entryLogId {}: {}", new Object[]{entryLogId, e.getMessage(), e});
            throw new BookieException.EntryLogMetadataMapException(e);
        }
        finally {
            key.recycle();
        }
    }

    private EntryLogMetadata.EntryLogMetadataRecyclable getEntryLogMetadataRecyclable(byte[] value) throws IOException {
        ByteArrayInputStream localBais = bais.get();
        DataInputStream localDatais = datais.get();
        if (localBais.available() < value.length) {
            localBais.close();
            localDatais.close();
            ByteArrayInputStream newBais = new ByteArrayInputStream(value);
            bais.set(newBais);
            datais.set(new DataInputStream(newBais));
        } else {
            localBais.read(value, 0, value.length);
        }
        localBais.reset();
        localDatais.reset();
        EntryLogMetadata.EntryLogMetadataRecyclable metadata = EntryLogMetadata.deserialize(datais.get());
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long entryLogId) throws BookieException.EntryLogMetadataMapException {
        this.throwIfClosed();
        LongWrapper key = LongWrapper.get(entryLogId);
        try {
            try {
                this.metadataMapDB.delete(key.array);
            }
            catch (IOException e) {
                throw new BookieException.EntryLogMetadataMapException(e);
            }
        }
        finally {
            key.recycle();
        }
    }

    @Override
    public int size() throws BookieException.EntryLogMetadataMapException {
        this.throwIfClosed();
        try {
            return (int)this.metadataMapDB.count();
        }
        catch (IOException e) {
            throw new BookieException.EntryLogMetadataMapException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.metadataMapDB.close();
        } else {
            log.warn("Attempted to close already closed PersistentEntryLogMetadataMap");
        }
    }

    public void throwIfClosed() throws BookieException.EntryLogMetadataMapException {
        if (this.isClosed.get()) {
            String msg = "Attempted to use PersistentEntryLogMetadataMap after it was closed";
            log.error("Attempted to use PersistentEntryLogMetadataMap after it was closed");
            throw new BookieException.EntryLogMetadataMapException(new IOException("Attempted to use PersistentEntryLogMetadataMap after it was closed"));
        }
    }
}

