/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.util;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.exceptions.ObjectClosedException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.CompletableRunnable;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T> CompletableFuture<T> callAndHandleClosedAsync(String componentName, boolean isClosed, CompletableRunnable<T> callable) {
        CompletableFuture future = FutureUtils.createFuture();
        if (isClosed) {
            future.completeExceptionally(new ObjectClosedException(componentName));
        } else {
            callable.run(future);
        }
        return future;
    }

    public static IOException toIOException(Throwable cause) {
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof ExecutionException || cause instanceof CompletionException) {
            return ExceptionUtils.toIOException(cause.getCause());
        }
        return new IOException(cause);
    }
}

