/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.io.IOException;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.AbstractHierarchicalLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LegacyHierarchicalLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LongHierarchicalLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.StringUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HierarchicalLedgerManager
extends AbstractHierarchicalLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(HierarchicalLedgerManager.class);
    LegacyHierarchicalLedgerManager legacyLM;
    LongHierarchicalLedgerManager longLM;

    public HierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
        this.legacyLM = new LegacyHierarchicalLedgerManager(conf, zk);
        this.longLM = new LongHierarchicalLedgerManager(conf, zk);
    }

    @Override
    public void asyncProcessLedgers(final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.legacyLM.asyncProcessLedgers(processor, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                if (rc == failureRc) {
                    finalCb.processResult(rc, path, ctx);
                } else {
                    HierarchicalLedgerManager.this.longLM.asyncProcessLedgers(processor, finalCb, context, successRc, failureRc);
                }
            }
        }, context, successRc, failureRc);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        return this.ledgerRootPath + StringUtils.getHybridHierarchicalLedgerPath(ledgerId);
    }

    @Override
    protected long getLedgerId(String ledgerPath) throws IOException {
        if (!ledgerPath.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + ledgerPath);
        }
        String hierarchicalPath = ledgerPath.substring(this.ledgerRootPath.length() + 1);
        return StringUtils.stringToLongHierarchicalLedgerId(hierarchicalPath);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges(long zkOpTimeoutMs) {
        LedgerManager.LedgerRangeIterator legacyLedgerRangeIterator = this.legacyLM.getLedgerRanges(zkOpTimeoutMs);
        LedgerManager.LedgerRangeIterator longLedgerRangeIterator = this.longLM.getLedgerRanges(zkOpTimeoutMs);
        return new HierarchicalLedgerRangeIterator(legacyLedgerRangeIterator, longLedgerRangeIterator);
    }

    @Override
    protected String getLedgerParentNodeRegex() {
        return "\\d{2,3}";
    }

    @Override
    public void close() {
        super.close();
        if (this.legacyLM != null) {
            this.legacyLM.close();
        }
        if (this.longLM != null) {
            this.longLM.close();
        }
    }

    private static class HierarchicalLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        LedgerManager.LedgerRangeIterator legacyLedgerRangeIterator;
        LedgerManager.LedgerRangeIterator longLedgerRangeIterator;

        HierarchicalLedgerRangeIterator(LedgerManager.LedgerRangeIterator legacyLedgerRangeIterator, LedgerManager.LedgerRangeIterator longLedgerRangeIterator) {
            this.legacyLedgerRangeIterator = legacyLedgerRangeIterator;
            this.longLedgerRangeIterator = longLedgerRangeIterator;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.legacyLedgerRangeIterator.hasNext() || this.longLedgerRangeIterator.hasNext();
        }

        @Override
        public LedgerManager.LedgerRange next() throws IOException {
            if (this.legacyLedgerRangeIterator.hasNext()) {
                return this.legacyLedgerRangeIterator.next();
            }
            return this.longLedgerRangeIterator.next();
        }
    }
}

