/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheManagerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;

public class EntryCacheDisabled
implements EntryCache {
    private final ManagedLedgerImpl ml;
    private final ManagedLedgerInterceptor interceptor;

    public EntryCacheDisabled(ManagedLedgerImpl ml) {
        this.ml = ml;
        this.interceptor = ml.getManagedLedgerInterceptor();
    }

    @Override
    public String getName() {
        return this.ml.getName();
    }

    @Override
    public boolean insert(EntryImpl entry) {
        return false;
    }

    @Override
    public void invalidateEntries(PositionImpl lastPosition) {
    }

    @Override
    public void invalidateAllEntries(long ledgerId) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Pair<Integer, Long> evictEntries(long sizeToFree) {
        return Pair.of(0, 0L);
    }

    @Override
    public void invalidateEntriesBeforeTimestamp(long timestamp) {
    }

    @Override
    public void asyncReadEntry(ReadHandle lh, long firstEntry, long lastEntry, boolean isSlowestReader, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        ((CompletableFuture)lh.readAsync(firstEntry, lastEntry).thenAcceptAsync(ledgerEntries -> {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            long totalSize = 0L;
            try {
                for (LedgerEntry e : ledgerEntries) {
                    EntryImpl entry = RangeEntryCacheManagerImpl.create(e, this.interceptor);
                    entries.add(entry);
                    totalSize += (long)entry.getLength();
                }
            }
            finally {
                ledgerEntries.close();
            }
            this.ml.getFactory().getMbean().recordCacheMiss(entries.size(), totalSize);
            this.ml.getMbean().addReadEntriesSample(entries.size(), totalSize);
            callback.readEntriesComplete(entries, ctx);
        }, (Executor)this.ml.getExecutor().chooseThread(this.ml.getName()))).exceptionally(exception -> {
            callback.readEntriesFailed(ManagedLedgerImpl.createManagedLedgerException(exception), ctx);
            return null;
        });
    }

    @Override
    public void asyncReadEntry(ReadHandle lh, PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        lh.readAsync(position.getEntryId(), position.getEntryId()).whenCompleteAsync((ledgerEntries, exception) -> {
            if (exception != null) {
                this.ml.invalidateLedgerHandle(lh);
                callback.readEntryFailed(ManagedLedgerImpl.createManagedLedgerException(exception), ctx);
                return;
            }
            try {
                Iterator<LedgerEntry> iterator = ledgerEntries.iterator();
                if (iterator.hasNext()) {
                    LedgerEntry ledgerEntry = iterator.next();
                    EntryImpl returnEntry = RangeEntryCacheManagerImpl.create(ledgerEntry, this.interceptor);
                    this.ml.getFactory().getMbean().recordCacheMiss(1, returnEntry.getLength());
                    this.ml.getMbean().addReadEntriesSample(1, returnEntry.getLength());
                    callback.readEntryComplete(returnEntry, ctx);
                } else {
                    callback.readEntryFailed(new ManagedLedgerException("Could not read given position"), ctx);
                }
            }
            finally {
                ledgerEntries.close();
            }
        }, (Executor)this.ml.getExecutor().chooseThread(this.ml.getName()));
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public int compareTo(EntryCache other) {
        return Long.compare(this.getSize(), other.getSize());
    }
}

