/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.pulsar.shade.com.google.protobuf.CodedOutputStream;
import org.apache.pulsar.shade.com.google.protobuf.ExtensionRegistry;
import org.apache.pulsar.shade.com.google.protobuf.ExtensionRegistryLite;
import org.apache.pulsar.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.shade.com.google.protobuf.MessageLite;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufInputStream;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufOutputStream;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.shade.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.pulsar.shade.io.netty.channel.ChannelPromise;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.checksum.MacDigestManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieProtoEncoding {
    private static final Logger LOG = LoggerFactory.getLogger(BookieProtoEncoding.class);

    private static ByteBuf serializeProtobuf(MessageLite msg, ByteBufAllocator allocator) {
        int size = msg.getSerializedSize();
        int frameSize = size + 4;
        ByteBuf buf = allocator.directBuffer(frameSize, frameSize);
        buf.writeInt(size);
        try {
            msg.writeTo(CodedOutputStream.newInstance(buf.nioBuffer(buf.writerIndex(), size)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buf.writerIndex(frameSize);
        return buf;
    }

    @ChannelHandler.Sharable
    public static class ResponseDecoder
    extends ChannelInboundHandlerAdapter {
        final EnDecoder repPreV3;
        final EnDecoder repV3;
        final boolean useV2Protocol;
        final boolean tlsEnabled;
        boolean usingV3Protocol;

        ResponseDecoder(ExtensionRegistry extensionRegistry, boolean useV2Protocol, boolean tlsEnabled) {
            this.repPreV3 = new ResponseEnDeCoderPreV3(extensionRegistry);
            this.repV3 = new ResponseEnDecoderV3(extensionRegistry);
            this.useV2Protocol = useV2Protocol;
            this.tlsEnabled = tlsEnabled;
            this.usingV3Protocol = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received response {} from channel {} to decode.", msg, (Object)ctx.channel());
            }
            try {
                Object result;
                block13: {
                    if (!(msg instanceof ByteBuf)) {
                        LOG.error("Received invalid response {} from channel {} to decode.", msg, (Object)ctx.channel());
                        ctx.fireChannelRead(msg);
                        return;
                    }
                    ByteBuf buffer = (ByteBuf)msg;
                    buffer.markReaderIndex();
                    if (!this.useV2Protocol) {
                        result = this.repV3.decode(buffer);
                    } else if (this.tlsEnabled && this.usingV3Protocol) {
                        try {
                            result = this.repV3.decode(buffer);
                            if (!(result instanceof BookkeeperProtocol.Response) || BookkeeperProtocol.OperationType.START_TLS != ((BookkeeperProtocol.Response)result).getHeader().getOperation()) break block13;
                            this.usingV3Protocol = false;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Degrade bookkeeper to v2 after starting TLS.");
                            }
                        }
                        catch (InvalidProtocolBufferException e) {
                            this.usingV3Protocol = false;
                            buffer.resetReaderIndex();
                            result = this.repPreV3.decode(buffer);
                        }
                    } else {
                        result = this.repPreV3.decode(buffer);
                    }
                }
                ctx.fireChannelRead(result);
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class ResponseEncoder
    extends ChannelOutboundHandlerAdapter {
        final EnDecoder repPreV3;
        final EnDecoder repV3;

        ResponseEncoder(ExtensionRegistry extensionRegistry) {
            this.repPreV3 = new ResponseEnDeCoderPreV3(extensionRegistry);
            this.repV3 = new ResponseEnDecoderV3(extensionRegistry);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encode response {} to channel {}.", msg, (Object)ctx.channel());
            }
            if (msg instanceof BookkeeperProtocol.Response) {
                ctx.write(this.repV3.encode(msg, ctx.alloc()), promise);
            } else if (msg instanceof BookieProtocol.Response) {
                ctx.write(this.repPreV3.encode(msg, ctx.alloc()), promise);
            } else {
                LOG.error("Invalid response to encode to {}: {}", (Object)ctx.channel(), (Object)msg.getClass().getName());
                ctx.write(msg, promise);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class RequestDecoder
    extends ChannelInboundHandlerAdapter {
        final EnDecoder reqPreV3;
        final EnDecoder reqV3;
        boolean usingV3Protocol;

        RequestDecoder(ExtensionRegistry extensionRegistry) {
            this.reqPreV3 = new RequestEnDeCoderPreV3(extensionRegistry);
            this.reqV3 = new RequestEnDecoderV3(extensionRegistry);
            this.usingV3Protocol = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received request {} from channel {} to decode.", msg, (Object)ctx.channel());
            }
            try {
                Object result;
                if (!(msg instanceof ByteBuf)) {
                    LOG.error("Received invalid request {} from channel {} to decode.", msg, (Object)ctx.channel());
                    ctx.fireChannelRead(msg);
                    return;
                }
                ByteBuf buffer = (ByteBuf)msg;
                buffer.markReaderIndex();
                if (this.usingV3Protocol) {
                    try {
                        result = this.reqV3.decode(buffer);
                    }
                    catch (InvalidProtocolBufferException e) {
                        this.usingV3Protocol = false;
                        buffer.resetReaderIndex();
                        result = this.reqPreV3.decode(buffer);
                    }
                } else {
                    result = this.reqPreV3.decode(buffer);
                }
                ctx.fireChannelRead(result);
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class RequestEncoder
    extends ChannelOutboundHandlerAdapter {
        final EnDecoder reqPreV3;
        final EnDecoder reqV3;

        public RequestEncoder(ExtensionRegistry extensionRegistry) {
            this.reqPreV3 = new RequestEnDeCoderPreV3(extensionRegistry);
            this.reqV3 = new RequestEnDecoderV3(extensionRegistry);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encode request {} to channel {}.", msg, (Object)ctx.channel());
            }
            if (msg instanceof BookkeeperProtocol.Request) {
                ctx.write(this.reqV3.encode(msg, ctx.alloc()), promise);
            } else if (msg instanceof BookieProtocol.Request) {
                ctx.write(this.reqPreV3.encode(msg, ctx.alloc()), promise);
            } else {
                LOG.error("Invalid request to encode to {}: {}", (Object)ctx.channel(), (Object)msg.getClass().getName());
                ctx.write(msg, promise);
            }
        }
    }

    public static class ResponseEnDecoderV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;

        public ResponseEnDecoderV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        @Override
        public Object decode(ByteBuf packet) throws Exception {
            return BookkeeperProtocol.Response.parseFrom(new ByteBufInputStream(packet), (ExtensionRegistryLite)this.extensionRegistry);
        }

        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)msg;
            return BookieProtoEncoding.serializeProtobuf(response, allocator);
        }
    }

    public static class RequestEnDecoderV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;

        public RequestEnDecoderV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        @Override
        public Object decode(ByteBuf packet) throws Exception {
            return BookkeeperProtocol.Request.parseFrom(new ByteBufInputStream(packet), (ExtensionRegistryLite)this.extensionRegistry);
        }

        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            BookkeeperProtocol.Request request = (BookkeeperProtocol.Request)msg;
            return BookieProtoEncoding.serializeProtobuf(request, allocator);
        }
    }

    public static class ResponseEnDeCoderPreV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;
        private static final int RESPONSE_HEADERS_SIZE = 24;

        public ResponseEnDeCoderPreV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            if (!(msg instanceof BookieProtocol.Response)) {
                return msg;
            }
            BookieProtocol.Response r = (BookieProtocol.Response)msg;
            ByteBuf buf = allocator.buffer(28);
            buf.writerIndex(4);
            buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), (short)0));
            try {
                if (msg instanceof BookieProtocol.ReadResponse) {
                    buf.writeInt(r.getErrorCode());
                    buf.writeLong(r.getLedgerId());
                    buf.writeLong(r.getEntryId());
                    BookieProtocol.ReadResponse rr = (BookieProtocol.ReadResponse)r;
                    if (rr.hasData()) {
                        int frameSize = 24 + rr.getData().readableBytes();
                        buf.setInt(0, frameSize);
                        ByteBufList byteBufList = ByteBufList.get(buf, rr.getData());
                        return byteBufList;
                    }
                    buf.setInt(0, 24);
                    ByteBuf frameSize = buf;
                    return frameSize;
                }
                if (msg instanceof BookieProtocol.AddResponse) {
                    buf.writeInt(r.getErrorCode());
                    buf.writeLong(r.getLedgerId());
                    buf.writeLong(r.getEntryId());
                    buf.setInt(0, 24);
                    ByteBuf rr = buf;
                    return rr;
                }
                if (msg instanceof BookieProtocol.AuthResponse) {
                    BookkeeperProtocol.AuthMessage am = ((BookieProtocol.AuthResponse)r).getAuthMessage();
                    ByteBuf payload = Unpooled.wrappedBuffer(am.toByteArray());
                    int frameSize = 4 + payload.readableBytes();
                    buf.setInt(0, frameSize);
                    ByteBufList byteBufList = ByteBufList.get(buf, payload);
                    return byteBufList;
                }
                LOG.error("Cannot encode unknown response type {}", (Object)msg.getClass().getName());
                Object object = msg;
                return object;
            }
            finally {
                r.recycle();
            }
        }

        @Override
        public Object decode(ByteBuf buffer) throws Exception {
            int packetHeader = buffer.readInt();
            byte version = BookieProtocol.PacketHeader.getVersion(packetHeader);
            byte opCode = BookieProtocol.PacketHeader.getOpCode(packetHeader);
            switch (opCode) {
                case 1: {
                    int rc = buffer.readInt();
                    long ledgerId = buffer.readLong();
                    long entryId = buffer.readLong();
                    return BookieProtocol.AddResponse.create(version, rc, ledgerId, entryId);
                }
                case 2: {
                    int rc = buffer.readInt();
                    long ledgerId = buffer.readLong();
                    long entryId = buffer.readLong();
                    return new BookieProtocol.ReadResponse(version, rc, ledgerId, entryId, buffer.retainedSlice());
                }
                case 3: {
                    ByteBufInputStream bufStream = new ByteBufInputStream(buffer);
                    BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder();
                    builder.mergeFrom(bufStream, (ExtensionRegistryLite)this.extensionRegistry);
                    BookkeeperProtocol.AuthMessage am = builder.build();
                    return new BookieProtocol.AuthResponse(version, am);
                }
            }
            throw new IllegalStateException("Received unknown response : op code = " + opCode);
        }
    }

    public static class RequestEnDeCoderPreV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;
        private static final byte[] emptyPasswordMasterKey;

        public RequestEnDeCoderPreV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            if (!(msg instanceof BookieProtocol.Request)) {
                return msg;
            }
            BookieProtocol.Request r = (BookieProtocol.Request)msg;
            if (r instanceof BookieProtocol.AddRequest) {
                BookieProtocol.AddRequest ar = (BookieProtocol.AddRequest)r;
                ByteBufList data = ar.getData();
                int totalHeaderSize = 24;
                int totalPayloadSize = totalHeaderSize + data.readableBytes();
                ByteBuf buf = allocator.buffer(totalHeaderSize + 4);
                buf.writeInt(totalPayloadSize);
                buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), r.getFlags()));
                buf.writeBytes(r.getMasterKey(), 0, 20);
                ar.recycle();
                data.prepend(buf);
                return data;
            }
            if (r instanceof BookieProtocol.ReadRequest) {
                int totalHeaderSize = 20;
                if (r.hasMasterKey()) {
                    totalHeaderSize += 20;
                }
                ByteBuf buf = allocator.buffer(totalHeaderSize + 4);
                buf.writeInt(totalHeaderSize);
                buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), r.getFlags()));
                buf.writeLong(r.getLedgerId());
                buf.writeLong(r.getEntryId());
                if (r.hasMasterKey()) {
                    buf.writeBytes(r.getMasterKey(), 0, 20);
                }
                return buf;
            }
            if (r instanceof BookieProtocol.AuthRequest) {
                BookkeeperProtocol.AuthMessage am = ((BookieProtocol.AuthRequest)r).getAuthMessage();
                int totalHeaderSize = 4;
                int totalSize = totalHeaderSize + am.getSerializedSize();
                ByteBuf buf = allocator.buffer(totalSize + 4);
                buf.writeInt(totalSize);
                buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), r.getFlags()));
                ByteBufOutputStream bufStream = new ByteBufOutputStream(buf);
                am.writeTo(bufStream);
                return buf;
            }
            return msg;
        }

        @Override
        public Object decode(ByteBuf packet) throws Exception {
            int packetHeader = packet.readInt();
            byte version = BookieProtocol.PacketHeader.getVersion(packetHeader);
            byte opCode = BookieProtocol.PacketHeader.getOpCode(packetHeader);
            short flags = BookieProtocol.PacketHeader.getFlags(packetHeader);
            long ledgerId = -1L;
            long entryId = -1L;
            switch (opCode) {
                case 1: {
                    byte[] masterKey = RequestEnDeCoderPreV3.readMasterKey(packet);
                    ledgerId = packet.getLong(packet.readerIndex());
                    entryId = packet.getLong(packet.readerIndex() + 8);
                    packet.markReaderIndex();
                    return BookieProtocol.ParsedAddRequest.create(version, ledgerId, entryId, flags, masterKey, packet);
                }
                case 2: {
                    ledgerId = packet.readLong();
                    entryId = packet.readLong();
                    if ((flags & 1) == 1 && version >= 2) {
                        byte[] masterKey = RequestEnDeCoderPreV3.readMasterKey(packet);
                        return new BookieProtocol.ReadRequest(version, ledgerId, entryId, flags, masterKey);
                    }
                    return new BookieProtocol.ReadRequest(version, ledgerId, entryId, flags, null);
                }
                case 3: {
                    BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder();
                    builder.mergeFrom(new ByteBufInputStream(packet), (ExtensionRegistryLite)this.extensionRegistry);
                    return new BookieProtocol.AuthRequest(version, builder.build());
                }
            }
            throw new IllegalStateException("Received unknown request op code = " + opCode);
        }

        private static byte[] readMasterKey(ByteBuf packet) {
            byte[] masterKey = null;
            boolean isEmptyKey = true;
            for (int i = 0; i < 20; ++i) {
                if (packet.getByte(packet.readerIndex() + i) == emptyPasswordMasterKey[i]) continue;
                isEmptyKey = false;
                break;
            }
            if (isEmptyKey) {
                masterKey = emptyPasswordMasterKey;
                packet.readerIndex(packet.readerIndex() + 20);
            } else {
                masterKey = new byte[20];
                packet.readBytes(masterKey, 0, 20);
            }
            return masterKey;
        }

        static {
            try {
                emptyPasswordMasterKey = MacDigestManager.genDigest("ledger", new byte[0]);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface EnDecoder {
        public Object encode(Object var1, ByteBufAllocator var2) throws Exception;

        public Object decode(ByteBuf var1) throws Exception;
    }
}

