/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import java.util.Iterator;
import lombok.NonNull;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInfoService
implements HttpEndpointService {
    private static final Logger log = LoggerFactory.getLogger(ClusterInfoService.class);
    @NonNull
    private final BookKeeperAdmin bka;
    @NonNull
    private final LedgerManagerFactory ledgerManagerFactory;

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Only GET is supported.");
            return response;
        }
        ClusterInfo info = new ClusterInfo();
        this.fillUReplicatedInfo(info);
        this.fillAuditorInfo(info);
        this.fillBookiesInfo(info);
        String jsonResponse = JsonUtil.toJson(info);
        response.setBody(jsonResponse);
        response.setCode(HttpServer.StatusCode.OK);
        return response;
    }

    private void fillBookiesInfo(ClusterInfo info) {
        int totalBookiesCount = this.bka.getAllBookies().size();
        int writableBookiesCount = this.bka.getAvailableBookies().size();
        int readonlyBookiesCount = this.bka.getReadOnlyBookies().size();
        int unavailableBookiesCount = totalBookiesCount - writableBookiesCount - readonlyBookiesCount;
        info.setTotalBookiesCount(totalBookiesCount);
        info.setWritableBookiesCount(writableBookiesCount);
        info.setReadonlyBookiesCount(readonlyBookiesCount);
        info.setUnavailableBookiesCount(unavailableBookiesCount);
    }

    private void fillAuditorInfo(ClusterInfo info) {
        try {
            BookieId currentAuditor = this.bka.getCurrentAuditor();
            info.setAuditorElected(currentAuditor != null);
            info.setAuditorId(currentAuditor == null ? "" : currentAuditor.getId());
        }
        catch (Exception e) {
            log.error("Could not get Auditor info", (Throwable)e);
            info.setAuditorElected(false);
            info.setAuditorId("");
        }
    }

    private void fillUReplicatedInfo(ClusterInfo info) {
        try (LedgerUnderreplicationManager underreplicationManager = this.ledgerManagerFactory.newLedgerUnderreplicationManager();){
            Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(null);
            info.setClusterUnderReplicated(iter.hasNext());
            info.setLedgerReplicationEnabled(underreplicationManager.isLedgerReplicationEnabled());
        }
    }

    public ClusterInfoService(@NonNull BookKeeperAdmin bka, @NonNull LedgerManagerFactory ledgerManagerFactory) {
        if (bka == null) {
            throw new NullPointerException("bka is marked non-null but is null");
        }
        if (ledgerManagerFactory == null) {
            throw new NullPointerException("ledgerManagerFactory is marked non-null but is null");
        }
        this.bka = bka;
        this.ledgerManagerFactory = ledgerManagerFactory;
    }

    public static class ClusterInfo {
        private boolean auditorElected;
        private String auditorId;
        private boolean clusterUnderReplicated;
        private boolean ledgerReplicationEnabled;
        private int totalBookiesCount;
        private int writableBookiesCount;
        private int readonlyBookiesCount;
        private int unavailableBookiesCount;

        public boolean isAuditorElected() {
            return this.auditorElected;
        }

        public String getAuditorId() {
            return this.auditorId;
        }

        public boolean isClusterUnderReplicated() {
            return this.clusterUnderReplicated;
        }

        public boolean isLedgerReplicationEnabled() {
            return this.ledgerReplicationEnabled;
        }

        public int getTotalBookiesCount() {
            return this.totalBookiesCount;
        }

        public int getWritableBookiesCount() {
            return this.writableBookiesCount;
        }

        public int getReadonlyBookiesCount() {
            return this.readonlyBookiesCount;
        }

        public int getUnavailableBookiesCount() {
            return this.unavailableBookiesCount;
        }

        public void setAuditorElected(boolean auditorElected) {
            this.auditorElected = auditorElected;
        }

        public void setAuditorId(String auditorId) {
            this.auditorId = auditorId;
        }

        public void setClusterUnderReplicated(boolean clusterUnderReplicated) {
            this.clusterUnderReplicated = clusterUnderReplicated;
        }

        public void setLedgerReplicationEnabled(boolean ledgerReplicationEnabled) {
            this.ledgerReplicationEnabled = ledgerReplicationEnabled;
        }

        public void setTotalBookiesCount(int totalBookiesCount) {
            this.totalBookiesCount = totalBookiesCount;
        }

        public void setWritableBookiesCount(int writableBookiesCount) {
            this.writableBookiesCount = writableBookiesCount;
        }

        public void setReadonlyBookiesCount(int readonlyBookiesCount) {
            this.readonlyBookiesCount = readonlyBookiesCount;
        }

        public void setUnavailableBookiesCount(int unavailableBookiesCount) {
            this.unavailableBookiesCount = unavailableBookiesCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterInfo)) {
                return false;
            }
            ClusterInfo other = (ClusterInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAuditorElected() != other.isAuditorElected()) {
                return false;
            }
            if (this.isClusterUnderReplicated() != other.isClusterUnderReplicated()) {
                return false;
            }
            if (this.isLedgerReplicationEnabled() != other.isLedgerReplicationEnabled()) {
                return false;
            }
            if (this.getTotalBookiesCount() != other.getTotalBookiesCount()) {
                return false;
            }
            if (this.getWritableBookiesCount() != other.getWritableBookiesCount()) {
                return false;
            }
            if (this.getReadonlyBookiesCount() != other.getReadonlyBookiesCount()) {
                return false;
            }
            if (this.getUnavailableBookiesCount() != other.getUnavailableBookiesCount()) {
                return false;
            }
            String this$auditorId = this.getAuditorId();
            String other$auditorId = other.getAuditorId();
            return !(this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuditorElected() ? 79 : 97);
            result = result * 59 + (this.isClusterUnderReplicated() ? 79 : 97);
            result = result * 59 + (this.isLedgerReplicationEnabled() ? 79 : 97);
            result = result * 59 + this.getTotalBookiesCount();
            result = result * 59 + this.getWritableBookiesCount();
            result = result * 59 + this.getReadonlyBookiesCount();
            result = result * 59 + this.getUnavailableBookiesCount();
            String $auditorId = this.getAuditorId();
            result = result * 59 + ($auditorId == null ? 43 : $auditorId.hashCode());
            return result;
        }

        public String toString() {
            return "ClusterInfoService.ClusterInfo(auditorElected=" + this.isAuditorElected() + ", auditorId=" + this.getAuditorId() + ", clusterUnderReplicated=" + this.isClusterUnderReplicated() + ", ledgerReplicationEnabled=" + this.isLedgerReplicationEnabled() + ", totalBookiesCount=" + this.getTotalBookiesCount() + ", writableBookiesCount=" + this.getWritableBookiesCount() + ", readonlyBookiesCount=" + this.getReadonlyBookiesCount() + ", unavailableBookiesCount=" + this.getUnavailableBookiesCount() + ")";
        }
    }
}

