/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnderReplicatedLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListUnderReplicatedLedgerService.class);
    protected ServerConfiguration conf;
    private final LedgerManagerFactory ledgerManagerFactory;

    public ListUnderReplicatedLedgerService(ServerConfiguration conf, LedgerManagerFactory ledgerManagerFactory) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.ledgerManagerFactory = ledgerManagerFactory;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map<String, String> params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod()) {
            boolean printMissingReplica = false;
            String includingBookieId = params != null && params.containsKey("missingreplica") ? params.get("missingreplica") : null;
            String excludingBookieId = params != null && params.containsKey("excludingmissingreplica") ? params.get("excludingmissingreplica") : null;
            if (params != null && params.containsKey("printmissingreplica")) {
                printMissingReplica = true;
            }
            Predicate<List<String>> predicate = null;
            if (!StringUtils.isBlank(includingBookieId) && !StringUtils.isBlank(excludingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId) && !replicasList.contains(excludingBookieId);
            } else if (!StringUtils.isBlank(includingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId);
            } else if (!StringUtils.isBlank(excludingBookieId)) {
                predicate = replicasList -> !replicasList.contains(excludingBookieId);
            }
            try {
                boolean hasURLedgers = false;
                ArrayList<Long> outputLedgers = null;
                LinkedHashMap<Long, List<String>> outputLedgersWithMissingReplica = null;
                LedgerUnderreplicationManager underreplicationManager = this.ledgerManagerFactory.newLedgerUnderreplicationManager();
                Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(predicate);
                hasURLedgers = iter.hasNext();
                if (hasURLedgers) {
                    if (printMissingReplica) {
                        outputLedgersWithMissingReplica = new LinkedHashMap<Long, List<String>>();
                    } else {
                        outputLedgers = Lists.newArrayList();
                    }
                }
                while (iter.hasNext()) {
                    if (printMissingReplica) {
                        UnderreplicatedLedger underreplicatedLedger = iter.next();
                        outputLedgersWithMissingReplica.put(underreplicatedLedger.getLedgerId(), underreplicatedLedger.getReplicaList());
                        continue;
                    }
                    outputLedgers.add(iter.next().getLedgerId());
                }
                if (!hasURLedgers) {
                    response.setCode(HttpServer.StatusCode.NOT_FOUND);
                    response.setBody("No under replicated ledgers found");
                    return response;
                }
                response.setCode(HttpServer.StatusCode.OK);
                String jsonResponse = JsonUtil.toJson(printMissingReplica ? outputLedgersWithMissingReplica : outputLedgers);
                LOG.debug("output body: " + jsonResponse);
                response.setBody(jsonResponse);
                return response;
            }
            catch (Exception e) {
                LOG.error("Exception occurred while listing under replicated ledgers", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when get." + e.getMessage());
                return response;
            }
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

