/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;

public class CachingStatsLogger
implements StatsLogger {
    protected final StatsLogger underlying;
    protected final ConcurrentMap<String, Counter> counters;
    protected final ConcurrentMap<String, OpStatsLogger> opStatsLoggers;
    protected final ConcurrentMap<String, StatsLogger> scopeStatsLoggers;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public CachingStatsLogger(StatsLogger statsLogger) {
        this.underlying = statsLogger;
        this.counters = new ConcurrentHashMap<String, Counter>();
        this.opStatsLoggers = new ConcurrentHashMap<String, OpStatsLogger>();
        this.scopeStatsLoggers = new ConcurrentHashMap<String, StatsLogger>();
    }

    public int hashCode() {
        return this.underlying.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CachingStatsLogger)) {
            return false;
        }
        CachingStatsLogger another = (CachingStatsLogger)obj;
        return this.underlying.equals(another.underlying);
    }

    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public OpStatsLogger getOpStatsLogger(String name) {
        OpStatsLogger opStatsLogger = (OpStatsLogger)this.opStatsLoggers.get(name);
        if (null == opStatsLogger) {
            OpStatsLogger newOpStatsLogger = this.underlying.getOpStatsLogger(name);
            OpStatsLogger oldOpStatsLogger = this.opStatsLoggers.putIfAbsent(name, newOpStatsLogger);
            opStatsLogger = null == oldOpStatsLogger ? newOpStatsLogger : oldOpStatsLogger;
        }
        return opStatsLogger;
    }

    @Override
    public Counter getCounter(String name) {
        Counter counter = (Counter)this.counters.get(name);
        if (null == counter) {
            Counter newCounter = this.underlying.getCounter(name);
            Counter oldCounter = this.counters.putIfAbsent(name, newCounter);
            counter = null == oldCounter ? newCounter : oldCounter;
        }
        return counter;
    }

    @Override
    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.underlying.registerGauge(name, gauge);
    }

    @Override
    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
        this.underlying.unregisterGauge(name, gauge);
    }

    @Override
    public StatsLogger scope(String name) {
        StatsLogger statsLogger = (StatsLogger)this.scopeStatsLoggers.get(name);
        if (null == statsLogger) {
            CachingStatsLogger newStatsLogger = new CachingStatsLogger(this.underlying.scope(name));
            StatsLogger oldStatsLogger = this.scopeStatsLoggers.putIfAbsent(name, newStatsLogger);
            statsLogger = null == oldStatsLogger ? newStatsLogger : oldStatsLogger;
        }
        return statsLogger;
    }

    @Override
    public void removeScope(String name, StatsLogger statsLogger) {
        this.scopeStatsLoggers.remove(name, statsLogger);
    }

    @Override
    public OpStatsLogger getThreadScopedOpStatsLogger(String name) {
        return this.getOpStatsLogger(name);
    }

    @Override
    public Counter getThreadScopedCounter(String name) {
        return this.getCounter(name);
    }
}

