/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.shade.com.google.common.hash.HashFunction;
import org.apache.pulsar.shade.com.google.common.hash.Hashing;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class SchemaHash {
    private static final HashFunction hashFunction = Hashing.sha256();
    private static final SchemaHash EMPTY_SCHEMA_HASH = new SchemaHash(hashFunction.hashBytes(new byte[0]), null);
    private final HashCode hash;
    private final SchemaType schemaType;

    private SchemaHash(HashCode hash, SchemaType schemaType) {
        this.hash = hash;
        this.schemaType = schemaType;
    }

    public static SchemaHash of(Schema schema) {
        if (schema == null || schema.getSchemaInfo() == null) {
            return EMPTY_SCHEMA_HASH;
        }
        return ((SchemaInfoImpl)schema.getSchemaInfo()).getSchemaHash();
    }

    public static SchemaHash of(SchemaData schemaData) {
        return SchemaHash.of(schemaData.getData(), schemaData.getType());
    }

    public static SchemaHash of(SchemaInfo schemaInfo) {
        if (schemaInfo == null) {
            return EMPTY_SCHEMA_HASH;
        }
        return ((SchemaInfoImpl)schemaInfo).getSchemaHash();
    }

    public static SchemaHash empty() {
        return EMPTY_SCHEMA_HASH;
    }

    public static SchemaHash of(byte[] schemaBytes, SchemaType schemaType) {
        return new SchemaHash(hashFunction.hashBytes(schemaBytes == null ? new byte[]{} : schemaBytes), schemaType);
    }

    public byte[] asBytes() {
        return this.hash.asBytes();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaHash)) {
            return false;
        }
        SchemaHash other = (SchemaHash)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashCode this$hash = this.hash;
        HashCode other$hash = other.hash;
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        SchemaType this$schemaType = this.schemaType;
        SchemaType other$schemaType = other.schemaType;
        return !(this$schemaType == null ? other$schemaType != null : !((Object)((Object)this$schemaType)).equals((Object)other$schemaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaHash;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashCode $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        SchemaType $schemaType = this.schemaType;
        result = result * 59 + ($schemaType == null ? 43 : ((Object)((Object)$schemaType)).hashCode());
        return result;
    }
}

