/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.admin;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.shade.org.apache.zookeeper.server.admin.ReadAheadEndpoint;
import org.apache.pulsar.shade.org.eclipse.jetty.io.Connection;
import org.apache.pulsar.shade.org.eclipse.jetty.io.EndPoint;
import org.apache.pulsar.shade.org.eclipse.jetty.io.ssl.SslConnection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.AbstractConnectionFactory;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ConnectionFactory;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Connector;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UnifiedConnectionFactory.class);
    private final SslContextFactory sslContextFactory;
    private final String nextProtocol;

    public UnifiedConnectionFactory(String nextProtocol) {
        this((SslContextFactory)null, nextProtocol);
    }

    public UnifiedConnectionFactory(SslContextFactory factory, String nextProtocol) {
        super("SSL");
        this.sslContextFactory = factory == null ? new SslContextFactory.Server() : factory;
        this.nextProtocol = nextProtocol;
        this.addBean(this.sslContextFactory);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SSLEngine engine = this.sslContextFactory.newSSLEngine();
        SSLSession session = engine.getSession();
        engine.setUseClientMode(false);
        if (session.getPacketBufferSize() > this.getInputBufferSize()) {
            this.setInputBufferSize(session.getPacketBufferSize());
        }
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint realEndPoint) {
        EndPoint plainEndpoint;
        SslConnection sslConnection;
        boolean isSSL;
        ReadAheadEndpoint aheadEndpoint = new ReadAheadEndpoint(realEndPoint, 1);
        byte[] bytes = aheadEndpoint.getBytes();
        if (bytes == null || bytes.length == 0) {
            isSSL = false;
            LOG.warn("Incoming connection has no data");
        } else {
            byte b = bytes[0];
            isSSL = b == 22;
        }
        LOG.debug(String.format("UnifiedConnectionFactory: newConnection() with SSL = %b", isSSL));
        if (isSSL) {
            SSLEngine engine = this.sslContextFactory.newSSLEngine(aheadEndpoint.getRemoteAddress());
            engine.setUseClientMode(false);
            sslConnection = this.newSslConnection(connector, aheadEndpoint, engine);
            sslConnection.setRenegotiationAllowed(this.sslContextFactory.isRenegotiationAllowed());
            this.configure(sslConnection, connector, aheadEndpoint);
            plainEndpoint = sslConnection.getDecryptedEndPoint();
        } else {
            sslConnection = null;
            plainEndpoint = aheadEndpoint;
            ServerMetrics.getMetrics().INSECURE_ADMIN.add(1L);
        }
        ConnectionFactory next = connector.getConnectionFactory(this.nextProtocol);
        Connection connection = next.newConnection(connector, plainEndpoint);
        plainEndpoint.setConnection(connection);
        return sslConnection == null ? connection : sslConnection;
    }

    protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
        return new SslConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, engine);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s->%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this.nextProtocol);
    }
}

