/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.shade.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.pulsar.shade.org.apache.zookeeper.server.DataTreeBean;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerCnxn;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZKDatabase;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.pulsar.shade.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.Learner;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;

public abstract class LearnerZooKeeperServer
extends QuorumZooKeeperServer {
    protected CommitProcessor commitProcessor;
    protected SyncRequestProcessor syncProcessor;

    public LearnerZooKeeperServer(FileTxnSnapLog logFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, int listenBacklog, ZKDatabase zkDb, QuorumPeer self) throws IOException {
        super(logFactory, tickTime, minSessionTimeout, maxSessionTimeout, listenBacklog, zkDb, self);
    }

    public abstract Learner getLearner();

    protected Map<Long, Integer> getTouchSnapshot() {
        if (this.sessionTracker != null) {
            return ((LearnerSessionTracker)this.sessionTracker).snapshot();
        }
        Map<Long, Integer> map = Collections.emptyMap();
        return map;
    }

    @Override
    public long getServerId() {
        return this.self.getMyId();
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LearnerSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getMyId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        if (this.upgradeableSessionTracker.isLocalSession(sessionId)) {
            super.revalidateSession(cnxn, sessionId, sessionTimeout);
        } else {
            this.getLearner().validateSession(cnxn, sessionId, sessionTimeout);
        }
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Learner peer) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        LOG.info("Shutting down");
        try {
            super.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception during shutdown", (Throwable)e);
        }
        try {
            if (this.syncProcessor != null) {
                this.syncProcessor.shutdown();
            }
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception in syncprocessor shutdown", (Throwable)e);
        }
    }
}

