/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.rocksdb;

import org.apache.pulsar.shade.org.rocksdb.Cache;
import org.apache.pulsar.shade.org.rocksdb.ChecksumType;
import org.apache.pulsar.shade.org.rocksdb.DataBlockIndexType;
import org.apache.pulsar.shade.org.rocksdb.Filter;
import org.apache.pulsar.shade.org.rocksdb.IndexShorteningMode;
import org.apache.pulsar.shade.org.rocksdb.IndexType;
import org.apache.pulsar.shade.org.rocksdb.PersistentCache;
import org.apache.pulsar.shade.org.rocksdb.TableFormatConfig;

public class BlockBasedTableConfig
extends TableFormatConfig {
    private boolean cacheIndexAndFilterBlocks = false;
    private boolean cacheIndexAndFilterBlocksWithHighPriority = true;
    private boolean pinL0FilterAndIndexBlocksInCache = false;
    private boolean pinTopLevelIndexAndFilter = true;
    private IndexType indexType = IndexType.kBinarySearch;
    private DataBlockIndexType dataBlockIndexType = DataBlockIndexType.kDataBlockBinarySearch;
    private double dataBlockHashTableUtilRatio = 0.75;
    private ChecksumType checksumType = ChecksumType.kCRC32c;
    private boolean noBlockCache = false;
    private Cache blockCache = null;
    private PersistentCache persistentCache = null;
    private Cache blockCacheCompressed = null;
    private long blockSize = 4096L;
    private int blockSizeDeviation = 10;
    private int blockRestartInterval = 16;
    private int indexBlockRestartInterval = 1;
    private long metadataBlockSize = 4096L;
    private boolean partitionFilters = false;
    private boolean optimizeFiltersForMemory = false;
    private boolean useDeltaEncoding = true;
    private Filter filterPolicy = null;
    private boolean wholeKeyFiltering = true;
    private boolean verifyCompression = false;
    private int readAmpBytesPerBit = 0;
    private int formatVersion = 5;
    private boolean enableIndexCompression = true;
    private boolean blockAlign = false;
    private IndexShorteningMode indexShortening = IndexShorteningMode.kShortenSeparators;
    @Deprecated
    private long blockCacheSize = 0x800000L;
    @Deprecated
    private int blockCacheNumShardBits = 0;
    @Deprecated
    private long blockCacheCompressedSize = 0L;
    @Deprecated
    private int blockCacheCompressedNumShardBits = 0;

    public boolean cacheIndexAndFilterBlocks() {
        return this.cacheIndexAndFilterBlocks;
    }

    public BlockBasedTableConfig setCacheIndexAndFilterBlocks(boolean bl) {
        this.cacheIndexAndFilterBlocks = bl;
        return this;
    }

    public boolean cacheIndexAndFilterBlocksWithHighPriority() {
        return this.cacheIndexAndFilterBlocksWithHighPriority;
    }

    public BlockBasedTableConfig setCacheIndexAndFilterBlocksWithHighPriority(boolean bl) {
        this.cacheIndexAndFilterBlocksWithHighPriority = bl;
        return this;
    }

    public boolean pinL0FilterAndIndexBlocksInCache() {
        return this.pinL0FilterAndIndexBlocksInCache;
    }

    public BlockBasedTableConfig setPinL0FilterAndIndexBlocksInCache(boolean bl) {
        this.pinL0FilterAndIndexBlocksInCache = bl;
        return this;
    }

    public boolean pinTopLevelIndexAndFilter() {
        return this.pinTopLevelIndexAndFilter;
    }

    public BlockBasedTableConfig setPinTopLevelIndexAndFilter(boolean bl) {
        this.pinTopLevelIndexAndFilter = bl;
        return this;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public BlockBasedTableConfig setIndexType(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    public DataBlockIndexType dataBlockIndexType() {
        return this.dataBlockIndexType;
    }

    public BlockBasedTableConfig setDataBlockIndexType(DataBlockIndexType dataBlockIndexType) {
        this.dataBlockIndexType = dataBlockIndexType;
        return this;
    }

    public double dataBlockHashTableUtilRatio() {
        return this.dataBlockHashTableUtilRatio;
    }

    public BlockBasedTableConfig setDataBlockHashTableUtilRatio(double d) {
        this.dataBlockHashTableUtilRatio = d;
        return this;
    }

    public ChecksumType checksumType() {
        return this.checksumType;
    }

    public BlockBasedTableConfig setChecksumType(ChecksumType checksumType) {
        this.checksumType = checksumType;
        return this;
    }

    public boolean noBlockCache() {
        return this.noBlockCache;
    }

    public BlockBasedTableConfig setNoBlockCache(boolean bl) {
        this.noBlockCache = bl;
        return this;
    }

    public BlockBasedTableConfig setBlockCache(Cache cache) {
        this.blockCache = cache;
        return this;
    }

    public BlockBasedTableConfig setPersistentCache(PersistentCache persistentCache) {
        this.persistentCache = persistentCache;
        return this;
    }

    public BlockBasedTableConfig setBlockCacheCompressed(Cache cache) {
        this.blockCacheCompressed = cache;
        return this;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public BlockBasedTableConfig setBlockSize(long l) {
        this.blockSize = l;
        return this;
    }

    public int blockSizeDeviation() {
        return this.blockSizeDeviation;
    }

    public BlockBasedTableConfig setBlockSizeDeviation(int n) {
        this.blockSizeDeviation = n;
        return this;
    }

    public int blockRestartInterval() {
        return this.blockRestartInterval;
    }

    public BlockBasedTableConfig setBlockRestartInterval(int n) {
        this.blockRestartInterval = n;
        return this;
    }

    public int indexBlockRestartInterval() {
        return this.indexBlockRestartInterval;
    }

    public BlockBasedTableConfig setIndexBlockRestartInterval(int n) {
        this.indexBlockRestartInterval = n;
        return this;
    }

    public long metadataBlockSize() {
        return this.metadataBlockSize;
    }

    public BlockBasedTableConfig setMetadataBlockSize(long l) {
        this.metadataBlockSize = l;
        return this;
    }

    public boolean partitionFilters() {
        return this.partitionFilters;
    }

    public BlockBasedTableConfig setPartitionFilters(boolean bl) {
        this.partitionFilters = bl;
        return this;
    }

    public boolean optimizeFiltersForMemory() {
        return this.optimizeFiltersForMemory;
    }

    public BlockBasedTableConfig setOptimizeFiltersForMemory(boolean bl) {
        this.optimizeFiltersForMemory = bl;
        return this;
    }

    public boolean useDeltaEncoding() {
        return this.useDeltaEncoding;
    }

    public BlockBasedTableConfig setUseDeltaEncoding(boolean bl) {
        this.useDeltaEncoding = bl;
        return this;
    }

    public Filter filterPolicy() {
        return this.filterPolicy;
    }

    public BlockBasedTableConfig setFilterPolicy(Filter filter) {
        this.filterPolicy = filter;
        return this;
    }

    @Deprecated
    public BlockBasedTableConfig setFilter(Filter filter) {
        return this.setFilterPolicy(filter);
    }

    public boolean wholeKeyFiltering() {
        return this.wholeKeyFiltering;
    }

    public BlockBasedTableConfig setWholeKeyFiltering(boolean bl) {
        this.wholeKeyFiltering = bl;
        return this;
    }

    public boolean verifyCompression() {
        return this.verifyCompression;
    }

    public BlockBasedTableConfig setVerifyCompression(boolean bl) {
        this.verifyCompression = bl;
        return this;
    }

    public int readAmpBytesPerBit() {
        return this.readAmpBytesPerBit;
    }

    public BlockBasedTableConfig setReadAmpBytesPerBit(int n) {
        this.readAmpBytesPerBit = n;
        return this;
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public BlockBasedTableConfig setFormatVersion(int n) {
        assert (n >= 0);
        this.formatVersion = n;
        return this;
    }

    public boolean enableIndexCompression() {
        return this.enableIndexCompression;
    }

    public BlockBasedTableConfig setEnableIndexCompression(boolean bl) {
        this.enableIndexCompression = bl;
        return this;
    }

    public boolean blockAlign() {
        return this.blockAlign;
    }

    public BlockBasedTableConfig setBlockAlign(boolean bl) {
        this.blockAlign = bl;
        return this;
    }

    public IndexShorteningMode indexShortening() {
        return this.indexShortening;
    }

    public BlockBasedTableConfig setIndexShortening(IndexShorteningMode indexShorteningMode) {
        this.indexShortening = indexShorteningMode;
        return this;
    }

    @Deprecated
    public long blockCacheSize() {
        return this.blockCacheSize;
    }

    @Deprecated
    public BlockBasedTableConfig setBlockCacheSize(long l) {
        this.blockCacheSize = l;
        return this;
    }

    @Deprecated
    public int cacheNumShardBits() {
        return this.blockCacheNumShardBits;
    }

    @Deprecated
    public BlockBasedTableConfig setCacheNumShardBits(int n) {
        this.blockCacheNumShardBits = n;
        return this;
    }

    @Deprecated
    public long blockCacheCompressedSize() {
        return this.blockCacheCompressedSize;
    }

    @Deprecated
    public BlockBasedTableConfig setBlockCacheCompressedSize(long l) {
        this.blockCacheCompressedSize = l;
        return this;
    }

    @Deprecated
    public int blockCacheCompressedNumShardBits() {
        return this.blockCacheCompressedNumShardBits;
    }

    @Deprecated
    public BlockBasedTableConfig setBlockCacheCompressedNumShardBits(int n) {
        this.blockCacheCompressedNumShardBits = n;
        return this;
    }

    @Deprecated
    public boolean hashIndexAllowCollision() {
        return true;
    }

    @Deprecated
    public BlockBasedTableConfig setHashIndexAllowCollision(boolean bl) {
        return this;
    }

    @Override
    protected long newTableFactoryHandle() {
        long l = this.filterPolicy != null ? this.filterPolicy.nativeHandle_ : 0L;
        long l2 = this.blockCache != null ? this.blockCache.nativeHandle_ : 0L;
        long l3 = this.persistentCache != null ? this.persistentCache.nativeHandle_ : 0L;
        long l4 = this.blockCacheCompressed != null ? this.blockCacheCompressed.nativeHandle_ : 0L;
        return this.newTableFactoryHandle(this.cacheIndexAndFilterBlocks, this.cacheIndexAndFilterBlocksWithHighPriority, this.pinL0FilterAndIndexBlocksInCache, this.pinTopLevelIndexAndFilter, this.indexType.getValue(), this.dataBlockIndexType.getValue(), this.dataBlockHashTableUtilRatio, this.checksumType.getValue(), this.noBlockCache, l2, l3, l4, this.blockSize, this.blockSizeDeviation, this.blockRestartInterval, this.indexBlockRestartInterval, this.metadataBlockSize, this.partitionFilters, this.optimizeFiltersForMemory, this.useDeltaEncoding, l, this.wholeKeyFiltering, this.verifyCompression, this.readAmpBytesPerBit, this.formatVersion, this.enableIndexCompression, this.blockAlign, this.indexShortening.getValue(), this.blockCacheSize, this.blockCacheNumShardBits, this.blockCacheCompressedSize, this.blockCacheCompressedNumShardBits);
    }

    private native long newTableFactoryHandle(boolean var1, boolean var2, boolean var3, boolean var4, byte var5, byte var6, double var7, byte var9, boolean var10, long var11, long var13, long var15, long var17, int var19, int var20, int var21, long var22, boolean var24, boolean var25, boolean var26, long var27, boolean var29, boolean var30, int var31, int var32, boolean var33, boolean var34, byte var35, @Deprecated long var36, @Deprecated int var38, @Deprecated long var39, @Deprecated int var41);
}

