/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.Timer;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionLog;
import org.apache.pulsar.transaction.coordinator.TransactionLogReplayCallback;
import org.apache.pulsar.transaction.coordinator.impl.TxnBatchedPositionImpl;
import org.apache.pulsar.transaction.coordinator.impl.TxnLogBufferedWriter;
import org.apache.pulsar.transaction.coordinator.impl.TxnLogBufferedWriterConfig;
import org.apache.pulsar.transaction.coordinator.proto.BatchedTransactionMetadataEntry;
import org.apache.pulsar.transaction.coordinator.proto.TransactionMetadataEntry;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLTransactionLogImpl
implements TransactionLog {
    private static final Logger log = LoggerFactory.getLogger(MLTransactionLogImpl.class);
    private final ManagedLedgerFactory managedLedgerFactory;
    private final ManagedLedgerConfig managedLedgerConfig;
    private ManagedLedger managedLedger;
    public static final String TRANSACTION_LOG_PREFIX = "__transaction_log_";
    private ManagedCursor cursor;
    public static final String TRANSACTION_SUBSCRIPTION_NAME = "transaction.subscription";
    private final SpscArrayQueue<Entry> entryQueue;
    private final long tcId;
    private final TopicName topicName;
    private TxnLogBufferedWriter<TransactionMetadataEntry> bufferedWriter;
    private final Timer timer;
    private final TxnLogBufferedWriterConfig txnLogBufferedWriterConfig;
    private static final FastThreadLocal<BatchedTransactionMetadataEntry> localBatchedTransactionLogCache = new FastThreadLocal<BatchedTransactionMetadataEntry>(){

        @Override
        protected BatchedTransactionMetadataEntry initialValue() throws Exception {
            return new BatchedTransactionMetadataEntry();
        }
    };

    public MLTransactionLogImpl(TransactionCoordinatorID tcID, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig, TxnLogBufferedWriterConfig txnLogBufferedWriterConfig, Timer timer) {
        this.topicName = MLTransactionLogImpl.getMLTransactionLogName(tcID);
        this.tcId = tcID.getId();
        this.managedLedgerFactory = managedLedgerFactory;
        this.managedLedgerConfig = managedLedgerConfig;
        this.timer = timer;
        this.txnLogBufferedWriterConfig = txnLogBufferedWriterConfig;
        if (txnLogBufferedWriterConfig.isBatchEnabled()) {
            this.managedLedgerConfig.setDeletionAtBatchIndexLevelEnabled(true);
        }
        this.entryQueue = new SpscArrayQueue(2000);
    }

    public static TopicName getMLTransactionLogName(TransactionCoordinatorID tcID) {
        return TopicName.get(TopicDomain.persistent.value(), NamespaceName.SYSTEM_NAMESPACE, TRANSACTION_LOG_PREFIX + tcID.getId());
    }

    @Override
    public CompletableFuture<Void> initialize() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.managedLedgerFactory.asyncOpen(this.topicName.getPersistenceNamingEncoding(), this.managedLedgerConfig, new AsyncCallbacks.OpenLedgerCallback(){

            @Override
            public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                MLTransactionLogImpl.this.managedLedger = ledger;
                MLTransactionLogImpl.this.bufferedWriter = new TxnLogBufferedWriter<TransactionMetadataEntry>(MLTransactionLogImpl.this.managedLedger, ((ManagedLedgerImpl)MLTransactionLogImpl.this.managedLedger).getExecutor(), MLTransactionLogImpl.this.timer, TransactionLogDataSerializer.INSTANCE, MLTransactionLogImpl.this.txnLogBufferedWriterConfig.getBatchedWriteMaxRecords(), MLTransactionLogImpl.this.txnLogBufferedWriterConfig.getBatchedWriteMaxSize(), MLTransactionLogImpl.this.txnLogBufferedWriterConfig.getBatchedWriteMaxDelayInMillis(), MLTransactionLogImpl.this.txnLogBufferedWriterConfig.isBatchEnabled());
                MLTransactionLogImpl.this.managedLedger.asyncOpenCursor(MLTransactionLogImpl.TRANSACTION_SUBSCRIPTION_NAME, CommandSubscribe.InitialPosition.Earliest, new AsyncCallbacks.OpenCursorCallback(){

                    @Override
                    public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                        MLTransactionLogImpl.this.cursor = cursor;
                        future.complete(null);
                    }

                    @Override
                    public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                        future.completeExceptionally(exception);
                    }
                }, null);
            }

            @Override
            public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null, null);
        return future;
    }

    @Override
    public void replayAsync(TransactionLogReplayCallback transactionLogReplayCallback) {
        new TransactionLogReplayer(transactionLogReplayCallback).start();
    }

    private void readAsync(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback readEntriesCallback) {
        this.cursor.asyncReadEntries(numberOfEntriesToRead, readEntriesCallback, System.nanoTime(), PositionImpl.LATEST);
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.managedLedger.asyncClose(new AsyncCallbacks.CloseCallback(){

            @Override
            public void closeComplete(Object ctx) {
                log.info("Transaction log with tcId : {} close managedLedger successful!", (Object)MLTransactionLogImpl.this.tcId);
                completableFuture.complete(null);
                MLTransactionLogImpl.this.bufferedWriter.close();
            }

            @Override
            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Transaction log with tcId : {} close managedLedger fail!", (Object)MLTransactionLogImpl.this.tcId);
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Position> append(TransactionMetadataEntry transactionMetadataEntry) {
        final CompletableFuture<Position> completableFuture = new CompletableFuture<Position>();
        this.bufferedWriter.asyncAddData(transactionMetadataEntry, new TxnLogBufferedWriter.AddDataCallback(){

            @Override
            public void addComplete(Position position, Object context) {
                completableFuture.complete(position);
            }

            @Override
            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Transaction log write transaction operation error", (Throwable)exception);
                if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
                    MLTransactionLogImpl.this.managedLedger.readyToCreateNewLedger();
                }
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    public CompletableFuture<Void> deletePosition(List<Position> positions) {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        for (Position position : positions) {
            if (!(position instanceof TxnBatchedPositionImpl)) continue;
            TxnBatchedPositionImpl batchedPosition = (TxnBatchedPositionImpl)position;
            batchedPosition.setAckSetByIndex();
        }
        this.cursor.asyncDelete(positions, new AsyncCallbacks.DeleteCallback(){

            @Override
            public void deleteComplete(Object position) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Deleted message at {}", new Object[]{MLTransactionLogImpl.this.topicName, MLTransactionLogImpl.TRANSACTION_SUBSCRIPTION_NAME, position});
                }
                completableFuture.complete(null);
            }

            @Override
            public void deleteFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}][{}] Failed to delete message at {}", new Object[]{MLTransactionLogImpl.this.topicName, MLTransactionLogImpl.TRANSACTION_SUBSCRIPTION_NAME, ctx, exception});
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    public ManagedLedger getManagedLedger() {
        return this.managedLedger;
    }

    public static List<TransactionMetadataEntry> deserializeEntry(ByteBuf buffer) {
        buffer.markReaderIndex();
        short magicNum = buffer.readShort();
        buffer.resetReaderIndex();
        if (magicNum == 3585) {
            buffer.skipBytes(4);
            BatchedTransactionMetadataEntry batchedLog = new BatchedTransactionMetadataEntry();
            batchedLog.parseFrom(buffer, buffer.readableBytes());
            return batchedLog.getTransactionLogsList();
        }
        TransactionMetadataEntry log = new TransactionMetadataEntry();
        log.parseFrom(buffer, buffer.readableBytes());
        return Collections.singletonList(log);
    }

    public static List<TransactionMetadataEntry> deserializeEntry(Entry entry) {
        return MLTransactionLogImpl.deserializeEntry(entry.getDataBuffer());
    }

    class TransactionLogReplayer {
        private final FillEntryQueueCallback fillEntryQueueCallback;
        private final TransactionLogReplayCallback transactionLogReplayCallback;

        TransactionLogReplayer(TransactionLogReplayCallback transactionLogReplayCallback) {
            this.fillEntryQueueCallback = new FillEntryQueueCallback();
            this.transactionLogReplayCallback = transactionLogReplayCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            while (this.fillEntryQueueCallback.fillQueue() || MLTransactionLogImpl.this.entryQueue.size() > 0) {
                Entry entry = (Entry)MLTransactionLogImpl.this.entryQueue.poll();
                if (entry != null) {
                    try {
                        List<TransactionMetadataEntry> logs = MLTransactionLogImpl.deserializeEntry(entry);
                        if (logs.isEmpty()) continue;
                        if (logs.size() == 1) {
                            TransactionMetadataEntry log = logs.get(0);
                            this.transactionLogReplayCallback.handleMetadataEntry(entry.getPosition(), log);
                            continue;
                        }
                        long[] ackSetAlreadyAck = MLTransactionLogImpl.this.cursor.getDeletedBatchIndexesAsLongArray(PositionImpl.get(entry.getLedgerId(), entry.getEntryId()));
                        BitSetRecyclable bitSetAlreadyAck = null;
                        if (ackSetAlreadyAck != null) {
                            bitSetAlreadyAck = BitSetRecyclable.valueOf(ackSetAlreadyAck);
                        }
                        int batchSize = logs.size();
                        for (int batchIndex = 0; batchIndex < batchSize; ++batchIndex) {
                            if (bitSetAlreadyAck != null && !bitSetAlreadyAck.get(batchIndex)) continue;
                            TransactionMetadataEntry log = logs.get(batchIndex);
                            TxnBatchedPositionImpl batchedPosition = new TxnBatchedPositionImpl(entry.getLedgerId(), entry.getEntryId(), batchSize, batchIndex);
                            this.transactionLogReplayCallback.handleMetadataEntry(batchedPosition, log);
                        }
                        if (ackSetAlreadyAck == null) continue;
                        bitSetAlreadyAck.recycle();
                        continue;
                    }
                    finally {
                        entry.release();
                        continue;
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.transactionLogReplayCallback.replayComplete();
        }
    }

    private static class TransactionLogDataSerializer
    implements TxnLogBufferedWriter.DataSerializer<TransactionMetadataEntry> {
        private static final TransactionLogDataSerializer INSTANCE = new TransactionLogDataSerializer();

        private TransactionLogDataSerializer() {
        }

        @Override
        public int getSerializedSize(TransactionMetadataEntry data) {
            return data.getSerializedSize();
        }

        @Override
        public ByteBuf serialize(TransactionMetadataEntry data) {
            int transactionMetadataEntrySize = data.getSerializedSize();
            ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(transactionMetadataEntrySize, transactionMetadataEntrySize);
            data.writeTo(buf);
            return buf;
        }

        @Override
        public ByteBuf serialize(ArrayList<TransactionMetadataEntry> transactionLogArray) {
            BatchedTransactionMetadataEntry data = localBatchedTransactionLogCache.get();
            data.clear();
            data.addAllTransactionLogs(transactionLogArray);
            int bytesSize = data.getSerializedSize();
            ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(bytesSize, bytesSize);
            data.writeTo(buf);
            return buf;
        }
    }

    class FillEntryQueueCallback
    implements AsyncCallbacks.ReadEntriesCallback {
        private final AtomicLong outstandingReadsRequests = new AtomicLong(0L);
        private volatile boolean isReadable = true;
        private static final int NUMBER_OF_PER_READ_ENTRY = 100;

        FillEntryQueueCallback() {
        }

        boolean fillQueue() {
            if (MLTransactionLogImpl.this.entryQueue.size() + 100 < MLTransactionLogImpl.this.entryQueue.capacity() && this.outstandingReadsRequests.get() == 0L) {
                if (MLTransactionLogImpl.this.cursor.hasMoreEntries()) {
                    this.outstandingReadsRequests.incrementAndGet();
                    MLTransactionLogImpl.this.readAsync(100, this);
                    return this.isReadable;
                }
                return false;
            }
            return this.isReadable;
        }

        @Override
        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            MLTransactionLogImpl.this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.decrementAndGet();
        }

        @Override
        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            if (MLTransactionLogImpl.this.managedLedgerConfig.isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException || exception instanceof ManagedLedgerException.ManagedLedgerFencedException || exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
                this.isReadable = false;
            } else {
                this.outstandingReadsRequests.decrementAndGet();
            }
            log.error("Transaction log init fail error!", (Throwable)exception);
        }
    }
}

