/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.base.Splitter;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.api.Session;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.apache.pulsar.websocket.WebSocketError;
import org.apache.pulsar.websocket.WebSocketHttpServletRequestWrapper;
import org.apache.pulsar.websocket.WebSocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketHandler
extends WebSocketAdapter
implements Closeable {
    protected final WebSocketService service;
    protected final HttpServletRequest request;
    protected final TopicName topic;
    protected final Map<String, String> queryParams;
    private static final String PULSAR_AUTH_METHOD_NAME = "X-Pulsar-Auth-Method-Name";
    private ScheduledFuture<?> pingFuture;
    private static final Logger log = LoggerFactory.getLogger(AbstractWebSocketHandler.class);

    public AbstractWebSocketHandler(WebSocketService service, HttpServletRequest request, ServletUpgradeResponse response) {
        this.service = service;
        this.request = new WebSocketHttpServletRequestWrapper(request);
        this.topic = this.extractTopicName(request);
        this.queryParams = new TreeMap<String, String>();
        request.getParameterMap().forEach((key, values) -> this.queryParams.put((String)key, values[0]));
    }

    protected boolean checkAuth(ServletUpgradeResponse response) {
        String authRole = "<none>";
        String authMethodName = this.request.getHeader(PULSAR_AUTH_METHOD_NAME);
        AuthenticationState authenticationState = null;
        if (this.service.isAuthenticationEnabled()) {
            try {
                if (authMethodName != null && this.service.getAuthenticationService().getAuthenticationProvider(authMethodName) != null) {
                    authenticationState = this.service.getAuthenticationService().getAuthenticationProvider(authMethodName).newHttpAuthState(this.request);
                }
                authRole = authenticationState != null ? this.service.getAuthenticationService().authenticateHttpRequest(this.request, authenticationState.getAuthDataSource()) : this.service.getAuthenticationService().authenticateHttpRequest(this.request);
                log.info("[{}:{}] Authenticated WebSocket client {} on topic {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic});
            }
            catch (AuthenticationException e) {
                log.warn("[{}:{}] Failed to authenticated WebSocket client {} on topic {}: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic, e.getMessage()});
                try {
                    response.sendError(401, "Failed to authenticate");
                }
                catch (IOException e1) {
                    log.warn("[{}:{}] Failed to send error: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), e1.getMessage(), e1});
                }
                return false;
            }
        }
        if (this.service.isAuthorizationEnabled()) {
            AuthenticationDataSource authenticationData = authenticationState != null ? authenticationState.getAuthDataSource() : new AuthenticationDataHttps(this.request);
            try {
                if (!this.isAuthorized(authRole, authenticationData).booleanValue()) {
                    log.warn("[{}:{}] WebSocket Client [{}] is not authorized on topic {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic});
                    response.sendError(403, "Not authorized");
                    return false;
                }
            }
            catch (Exception e) {
                log.warn("[{}:{}] Got an exception when authorizing WebSocket client {} on topic {} on: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), authRole, this.topic, e.getMessage()});
                try {
                    response.sendError(500, "Server error");
                }
                catch (IOException e1) {
                    log.warn("[{}:{}] Failed to send error: {}", new Object[]{this.request.getRemoteAddr(), this.request.getRemotePort(), e1.getMessage(), e1});
                }
                return false;
            }
        }
        return true;
    }

    protected static int getErrorCode(Exception e) {
        if (e instanceof IllegalArgumentException) {
            return 400;
        }
        if (e instanceof PulsarClientException.AuthenticationException) {
            return 401;
        }
        if (e instanceof PulsarClientException.AuthorizationException) {
            return 403;
        }
        if (e instanceof PulsarClientException.NotFoundException || e instanceof PulsarClientException.TopicDoesNotExistException) {
            return 404;
        }
        if (e instanceof PulsarClientException.ProducerBusyException || e instanceof PulsarClientException.ConsumerBusyException || e instanceof PulsarClientException.ProducerFencedException || e instanceof PulsarClientException.IncompatibleSchemaException) {
            return 409;
        }
        if (e instanceof PulsarClientException.TooManyRequestsException) {
            return 429;
        }
        if (e instanceof PulsarClientException.ProducerBlockedQuotaExceededError || e instanceof PulsarClientException.ProducerBlockedQuotaExceededException || e instanceof PulsarClientException.TopicTerminatedException) {
            return 503;
        }
        if (e instanceof PulsarClientException.TimeoutException) {
            return 504;
        }
        return 500;
    }

    protected static String getErrorMessage(Exception e) {
        if (e instanceof IllegalArgumentException) {
            return "Invalid query params: " + e.getMessage();
        }
        return "Failed to create producer/consumer: " + e.getMessage();
    }

    private void closePingFuture() {
        if (this.pingFuture != null && !this.pingFuture.isDone()) {
            this.pingFuture.cancel(true);
        }
    }

    @Override
    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        int webSocketPingDurationSeconds = this.service.getConfig().getWebSocketPingDurationSeconds();
        if (webSocketPingDurationSeconds > 0) {
            this.pingFuture = this.service.getExecutor().scheduleAtFixedRate(() -> {
                try {
                    session.getRemote().sendPing(ByteBuffer.wrap("PING".getBytes(StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    log.warn("[{}] WebSocket send ping", (Object)this.getSession().getRemoteAddress(), (Object)e);
                }
            }, webSocketPingDurationSeconds, webSocketPingDurationSeconds, TimeUnit.SECONDS);
        }
        log.info("[{}] New WebSocket session on topic {}", (Object)session.getRemoteAddress(), (Object)this.topic);
    }

    @Override
    public void onWebSocketError(Throwable cause) {
        super.onWebSocketError(cause);
        log.info("[{}] WebSocket error on topic {} : {}", new Object[]{this.getSession().getRemoteAddress(), this.topic, cause.getMessage()});
        try {
            this.closePingFuture();
            this.close();
        }
        catch (IOException e) {
            log.error("Failed in closing WebSocket session for topic {} with error: {}", (Object)this.topic, (Object)e.getMessage());
        }
    }

    @Override
    public void onWebSocketClose(int statusCode, String reason) {
        log.info("[{}] Closed WebSocket session on topic {}. status: {} - reason: {}", new Object[]{this.getSession().getRemoteAddress(), this.topic, statusCode, reason});
        try {
            this.closePingFuture();
            this.close();
        }
        catch (IOException e) {
            log.warn("[{}] Failed to close handler for topic {}. ", new Object[]{this.getSession().getRemoteAddress(), this.topic, e});
        }
    }

    public void close(WebSocketError error) {
        log.warn("[{}] Closing WebSocket session for topic {} - code: [{}], reason: [{}]", new Object[]{this.getSession().getRemoteAddress(), this.topic, error.getCode(), error.getDescription()});
        this.getSession().close(error.getCode(), error.getDescription());
    }

    public void close(WebSocketError error, String message) {
        log.warn("[{}] Closing WebSocket session for topic {} - code: [{}], reason: [{}]", new Object[]{this.getSession().getRemoteAddress(), this.topic, error.getCode(), error.getDescription() + ": " + message});
        this.getSession().close(error.getCode(), error.getDescription() + ": " + message);
    }

    protected String checkAuthentication() {
        return null;
    }

    private TopicName extractTopicName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        List<String> parts = Splitter.on("/").splitToList(uri);
        Preconditions.checkArgument(parts.size() >= 8, "Invalid topic name format");
        Preconditions.checkArgument(parts.get(1).equals("ws"));
        boolean isV2Format = parts.get(2).equals("v2");
        int domainIndex = isV2Format ? 4 : 3;
        Preconditions.checkArgument(parts.get(domainIndex).equals("persistent") || parts.get(domainIndex).equals("non-persistent"));
        String domain = parts.get(domainIndex);
        NamespaceName namespace = isV2Format ? NamespaceName.get(parts.get(5), parts.get(6)) : NamespaceName.get(parts.get(4), parts.get(5), parts.get(6));
        int startPosition = 7;
        boolean isConsumer = "consumer".equals(parts.get(2)) || "consumer".equals(parts.get(3));
        int endPosition = isConsumer ? parts.size() - 1 : parts.size();
        StringBuilder topicName = new StringBuilder(parts.get(startPosition));
        while (++startPosition < endPosition) {
            if (StringUtils.isEmpty(parts.get(startPosition))) continue;
            topicName.append("/").append(parts.get(startPosition));
        }
        String name = Codec.decode(topicName.toString());
        return TopicName.get(domain, namespace, name);
    }

    @VisibleForTesting
    public ScheduledFuture<?> getPingFuture() {
        return this.pingFuture;
    }

    protected abstract Boolean isAuthorized(String var1, AuthenticationDataSource var2) throws Exception;
}

