/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.RequiredTypeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRolesTokenAuthorizationProvider
extends PulsarAuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(MultiRolesTokenAuthorizationProvider.class);
    static final String HTTP_HEADER_NAME = "Authorization";
    static final String HTTP_HEADER_VALUE_PREFIX = "Bearer ";
    static final String CONF_TOKEN_SETTING_PREFIX = "tokenSettingPrefix";
    static final String CONF_TOKEN_AUTH_CLAIM = "tokenAuthClaim";
    private JwtParser parser = Jwts.parserBuilder().build();
    private String roleClaim = "sub";

    @Override
    public void initialize(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
        String confTokenAuthClaimSettingName;
        Object tokenAuthClaim;
        String prefix = (String)conf.getProperty(CONF_TOKEN_SETTING_PREFIX);
        if (null == prefix) {
            prefix = "";
        }
        if ((tokenAuthClaim = conf.getProperty(confTokenAuthClaimSettingName = prefix + CONF_TOKEN_AUTH_CLAIM)) != null && StringUtils.isNotBlank((String)tokenAuthClaim)) {
            this.roleClaim = (String)tokenAuthClaim;
        }
        super.initialize(conf, configCache);
    }

    private List<String> getRoles(AuthenticationDataSource authData) {
        String token = null;
        if (authData.hasDataFromCommand()) {
            token = authData.getCommandData();
            if (StringUtils.isBlank(token)) {
                return Collections.emptyList();
            }
        } else if (authData.hasDataFromHttp()) {
            String httpHeaderValue = authData.getHttpHeader(HTTP_HEADER_NAME);
            if (httpHeaderValue == null || !httpHeaderValue.startsWith(HTTP_HEADER_VALUE_PREFIX)) {
                return Collections.emptyList();
            }
            token = httpHeaderValue.substring(HTTP_HEADER_VALUE_PREFIX.length());
        }
        if (token == null) {
            return Collections.emptyList();
        }
        String[] splitToken = token.split("\\.");
        String unsignedToken = splitToken[0] + "." + splitToken[1] + ".";
        Jwt jwt = this.parser.parseClaimsJwt(unsignedToken);
        try {
            Collections.singletonList(((Claims)jwt.getBody()).get(this.roleClaim, String.class));
        }
        catch (RequiredTypeException requiredTypeException) {
            try {
                List list = (List)((Claims)jwt.getBody()).get(this.roleClaim, List.class);
                if (list != null) {
                    return list;
                }
            }
            catch (RequiredTypeException requiredTypeException1) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public CompletableFuture<Boolean> authorize(AuthenticationDataSource authenticationData, Function<String, CompletableFuture<Boolean>> authorizeFunc) {
        List<String> roles = this.getRoles(authenticationData);
        ArrayList futures = new ArrayList(roles.size());
        roles.forEach(r -> futures.add(authorizeFunc.apply((String)r)));
        return CompletableFuture.supplyAsync(() -> {
            do {
                try {
                    ArrayList<CompletableFuture> doneFutures = new ArrayList<CompletableFuture>();
                    FutureUtil.waitForAny(futures).get();
                    for (CompletableFuture future : futures) {
                        if (!future.isDone()) continue;
                        doneFutures.add(future);
                        if (!((Boolean)future.get()).booleanValue()) continue;
                        futures.forEach(f -> {
                            if (!f.isDone()) {
                                f.cancel(false);
                            }
                        });
                        return true;
                    }
                    futures.removeAll(doneFutures);
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            } while (!futures.isEmpty());
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(authenticationData, r -> super.canProduceAsync(topicName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        return this.authorize(authenticationData, r -> super.canConsumeAsync(topicName, (String)r, authenticationData, subscription));
    }

    @Override
    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(authenticationData, r -> super.canLookupAsync(topicName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(authenticationData, r -> super.allowFunctionOpsAsync(namespaceName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(authenticationData, r -> super.allowSourceOpsAsync(namespaceName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(authenticationData, r -> super.allowSinkOpsAsync(namespaceName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.authorize(authData, r -> super.allowTenantOperationAsync(tenantName, (String)r, operation, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.authorize(authData, r -> super.allowNamespaceOperationAsync(namespaceName, (String)r, operation, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return this.authorize(authData, r -> super.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, (String)r, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.authorize(authData, r -> super.allowTopicOperationAsync(topicName, (String)r, operation, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, String role, PolicyName policyName, PolicyOperation policyOperation, AuthenticationDataSource authData) {
        return this.authorize(authData, r -> super.allowTopicPolicyOperationAsync(topicName, (String)r, policyName, policyOperation, authData));
    }
}

