/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;

public class NamespaceEphemeralData {
    private String nativeUrl;
    private String nativeUrlTls;
    private String httpUrl;
    private String httpUrlTls;
    private boolean disabled;
    private Map<String, AdvertisedListener> advertisedListeners;

    public NamespaceEphemeralData() {
    }

    public NamespaceEphemeralData(String brokerUrl, String brokerUrlTls, String httpUrl, String httpUrlTls, boolean disabled) {
        this(brokerUrl, brokerUrlTls, httpUrl, httpUrlTls, disabled, null);
    }

    public NamespaceEphemeralData(String brokerUrl, String brokerUrlTls, String httpUrl, String httpUrlTls, boolean disabled, Map<String, AdvertisedListener> advertisedListeners) {
        this.nativeUrl = brokerUrl;
        this.nativeUrlTls = brokerUrlTls;
        this.httpUrl = httpUrl;
        this.httpUrlTls = httpUrlTls;
        this.disabled = disabled;
        this.advertisedListeners = advertisedListeners == null ? Collections.EMPTY_MAP : Maps.newHashMap(advertisedListeners);
    }

    public String getNativeUrl() {
        return this.nativeUrl;
    }

    public String getNativeUrlTls() {
        return this.nativeUrlTls;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public String getHttpUrlTls() {
        return this.httpUrlTls;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean flag) {
        this.disabled = flag;
    }

    @NotNull
    public Map<String, AdvertisedListener> getAdvertisedListeners() {
        if (this.advertisedListeners == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.advertisedListeners);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("nativeUrl", this.nativeUrl).add("httpUrl", this.httpUrl).add("disabled", this.disabled).add("advertisedListeners", this.getAdvertisedListeners()).toString();
    }
}

