/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.stats.prometheus.metrics.DataSketchesOpStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.LongAdderCounter;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusTextFormatUtil;
import org.apache.pulsar.broker.stats.prometheus.metrics.SimpleGauge;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.CachingStatsProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.shade.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;

public class PrometheusMetricsProvider
implements StatsProvider {
    private ScheduledExecutorService executor;
    public static final String PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = "prometheusStatsLatencyRolloverSeconds";
    public static final int DEFAULT_PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = 60;
    public static final String CLUSTER_NAME = "cluster";
    public static final String DEFAULT_CLUSTER_NAME = "pulsar";
    private String cluster;
    private final CachingStatsProvider cachingStatsProvider;
    public final ConcurrentMap<String, LongAdderCounter> counters = new ConcurrentSkipListMap<String, LongAdderCounter>();
    public final ConcurrentMap<String, SimpleGauge<? extends Number>> gauges = new ConcurrentSkipListMap<String, SimpleGauge<? extends Number>>();
    public final ConcurrentMap<String, DataSketchesOpStatsLogger> opStats = new ConcurrentSkipListMap<String, DataSketchesOpStatsLogger>();

    public PrometheusMetricsProvider() {
        this.cachingStatsProvider = new CachingStatsProvider(new StatsProvider(){

            @Override
            public void start(Configuration conf) {
            }

            @Override
            public void stop() {
            }

            @Override
            public StatsLogger getStatsLogger(String scope) {
                return new PrometheusStatsLogger(PrometheusMetricsProvider.this, scope);
            }

            @Override
            public String getStatsName(String ... statsComponents) {
                if (statsComponents.length == 0) {
                    return "";
                }
                String completeName = statsComponents[0].isEmpty() ? StringUtils.join((Object[])statsComponents, '_', 1, statsComponents.length) : StringUtils.join((Object[])statsComponents, '_');
                return Collector.sanitizeMetricName(completeName);
            }
        });
    }

    @Override
    public void start(Configuration conf) {
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("metrics"));
        int latencyRolloverSeconds = conf.getInt(PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS, 60);
        this.cluster = conf.getString(CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        this.executor.scheduleAtFixedRate(() -> this.rotateLatencyCollection(), 1L, latencyRolloverSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public StatsLogger getStatsLogger(String scope) {
        return this.cachingStatsProvider.getStatsLogger(scope);
    }

    @Override
    public void writeAllMetrics(Writer writer) throws IOException {
        this.gauges.forEach((name, gauge) -> PrometheusTextFormatUtil.writeGauge(writer, name, this.cluster, gauge));
        this.counters.forEach((name, counter) -> PrometheusTextFormatUtil.writeCounter(writer, name, this.cluster, counter));
        this.opStats.forEach((name, opStatLogger) -> PrometheusTextFormatUtil.writeOpStat(writer, name, this.cluster, opStatLogger));
    }

    @Override
    public String getStatsName(String ... statsComponents) {
        return this.cachingStatsProvider.getStatsName(statsComponents);
    }

    @VisibleForTesting
    void rotateLatencyCollection() {
        this.opStats.forEach((name, metric) -> metric.rotateLatencyCollection());
    }
}

