/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.functions.worker.ClusterServiceCoordinator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionAssignmentTailer;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.FunctionsManager;
import org.apache.pulsar.functions.worker.FunctionsStatsGenerator;
import org.apache.pulsar.functions.worker.LeaderService;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.MetricsGenerator;
import org.apache.pulsar.functions.worker.SchedulerManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.WorkerStatsManager;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.api.FunctionsImpl;
import org.apache.pulsar.functions.worker.rest.api.FunctionsImplV2;
import org.apache.pulsar.functions.worker.rest.api.SinksImpl;
import org.apache.pulsar.functions.worker.rest.api.SourcesImpl;
import org.apache.pulsar.functions.worker.rest.api.WorkerImpl;
import org.apache.pulsar.functions.worker.service.api.Functions;
import org.apache.pulsar.functions.worker.service.api.FunctionsV2;
import org.apache.pulsar.functions.worker.service.api.Sinks;
import org.apache.pulsar.functions.worker.service.api.Sources;
import org.apache.pulsar.functions.worker.service.api.Workers;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.path.PolicyPath;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarWorkerService
implements WorkerService {
    private static final Logger log = LoggerFactory.getLogger(PulsarWorkerService.class);
    private static final Logger LOG = LoggerFactory.getLogger(PulsarWorkerService.class);
    private WorkerConfig workerConfig;
    private PulsarClient client;
    private FunctionRuntimeManager functionRuntimeManager;
    private FunctionMetaDataManager functionMetaDataManager;
    private ClusterServiceCoordinator clusterServiceCoordinator;
    private Namespace dlogNamespace;
    private StorageAdminClient stateStoreAdminClient;
    private MembershipManager membershipManager;
    private SchedulerManager schedulerManager;
    private volatile boolean isInitialized = false;
    private ScheduledExecutorService statsUpdater;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private ConnectorsManager connectorsManager;
    private FunctionsManager functionsManager;
    private PulsarAdmin brokerAdmin;
    private PulsarAdmin functionAdmin;
    private MetricsGenerator metricsGenerator;
    @VisibleForTesting
    private URI dlogUri;
    private LeaderService leaderService;
    private FunctionAssignmentTailer functionAssignmentTailer;
    private WorkerStatsManager workerStatsManager;
    private Functions<PulsarWorkerService> functions;
    private FunctionsV2<PulsarWorkerService> functionsV2;
    private Sinks<PulsarWorkerService> sinks;
    private Sources<PulsarWorkerService> sources;
    private Workers<PulsarWorkerService> workers;
    private final PulsarClientCreator clientCreator;

    public PulsarWorkerService() {
        this.clientCreator = new PulsarClientCreator(){

            @Override
            public PulsarAdmin newPulsarAdmin(String pulsarServiceUrl, WorkerConfig workerConfig) {
                if (workerConfig.isBrokerClientAuthenticationEnabled()) {
                    return WorkerUtils.getPulsarAdminClient(pulsarServiceUrl, workerConfig.getBrokerClientAuthenticationPlugin(), workerConfig.getBrokerClientAuthenticationParameters(), workerConfig.getBrokerClientTrustCertsFilePath(), workerConfig.isTlsAllowInsecureConnection(), workerConfig.isTlsEnableHostnameVerification());
                }
                return WorkerUtils.getPulsarAdminClient(pulsarServiceUrl);
            }

            @Override
            public PulsarClient newPulsarClient(String pulsarServiceUrl, WorkerConfig workerConfig) {
                if (workerConfig.isBrokerClientAuthenticationEnabled()) {
                    return WorkerUtils.getPulsarClient(pulsarServiceUrl, workerConfig.getBrokerClientAuthenticationPlugin(), workerConfig.getBrokerClientAuthenticationParameters(), workerConfig.isUseTls(), workerConfig.getBrokerClientTrustCertsFilePath(), workerConfig.isTlsAllowInsecureConnection(), workerConfig.isTlsEnableHostnameVerification());
                }
                return WorkerUtils.getPulsarClient(pulsarServiceUrl);
            }
        };
    }

    public PulsarWorkerService(PulsarClientCreator clientCreator) {
        this.clientCreator = clientCreator;
    }

    @Override
    public void generateFunctionsStats(SimpleTextOutputStream out) {
        FunctionsStatsGenerator.generate(this, out);
    }

    @VisibleForTesting
    public void init(WorkerConfig workerConfig, URI dlogUri, boolean runAsStandalone) {
        this.statsUpdater = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("worker-stats-updater"));
        this.metricsGenerator = new MetricsGenerator(this.statsUpdater, workerConfig);
        this.workerConfig = workerConfig;
        this.dlogUri = dlogUri;
        this.workerStatsManager = new WorkerStatsManager(workerConfig, runAsStandalone);
        this.functions = new FunctionsImpl(() -> this);
        this.functionsV2 = new FunctionsImplV2(() -> this);
        this.sinks = new SinksImpl(() -> this);
        this.sources = new SourcesImpl(() -> this);
        this.workers = new WorkerImpl(() -> this);
    }

    @Override
    public void initAsStandalone(WorkerConfig workerConfig) throws Exception {
        URI dlogUri = PulsarWorkerService.initializeStandaloneWorkerService(this.clientCreator, workerConfig);
        this.init(workerConfig, dlogUri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI initializeStandaloneWorkerService(PulsarClientCreator clientCreator, WorkerConfig workerConfig) throws Exception {
        URI dlogURI;
        InternalConfigurationData internalConf;
        PulsarAdmin admin = clientCreator.newPulsarAdmin(workerConfig.getPulsarWebServiceUrl(), workerConfig);
        log.info("Checking if pulsar service at {} is up...", (Object)workerConfig.getPulsarWebServiceUrl());
        int maxRetries = workerConfig.getInitialBrokerReconnectMaxRetries();
        int retries = 0;
        while (true) {
            try {
                admin.clusters().getClusters();
            }
            catch (PulsarAdminException e) {
                log.warn("Failed to retrieve clusters from pulsar service", (Throwable)e);
                log.warn("Retry to connect to Pulsar service at {}", (Object)workerConfig.getPulsarWebServiceUrl());
                if (retries >= maxRetries) {
                    log.error("Failed to connect to Pulsar service at {} after {} attempts", (Object)workerConfig.getPulsarFunctionsNamespace(), (Object)maxRetries);
                    throw e;
                }
                ++retries;
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        log.info("Initializing Pulsar Functions namespace...");
        try {
            block17: {
                try {
                    admin.namespaces().getPolicies(workerConfig.getPulsarFunctionsNamespace());
                }
                catch (PulsarAdminException e) {
                    if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                        try {
                            Policies policies = new Policies();
                            policies.retention_policies = new RetentionPolicies(-1, -1);
                            policies.replication_clusters = new HashSet<String>();
                            policies.replication_clusters.add(workerConfig.getPulsarFunctionsCluster());
                            admin.namespaces().createNamespace(workerConfig.getPulsarFunctionsNamespace(), policies);
                        }
                        catch (PulsarAdminException e1) {
                            if (e1.getStatusCode() != Response.Status.CONFLICT.getStatusCode()) {
                                log.error("Failed to create namespace {} for pulsar functions", (Object)workerConfig.getPulsarFunctionsNamespace(), (Object)e1);
                                throw e1;
                            }
                            break block17;
                        }
                    }
                    log.error("Failed to get retention policy for pulsar function namespace {}", (Object)workerConfig.getPulsarFunctionsNamespace(), (Object)e);
                    throw e;
                }
            }
            try {
                internalConf = admin.brokers().getInternalConfigurationData();
            }
            catch (PulsarAdminException e) {
                log.error("Failed to retrieve broker internal configuration", (Throwable)e);
                throw e;
            }
        }
        finally {
            admin.close();
        }
        try {
            dlogURI = workerConfig.isInitializedDlogMetadata().booleanValue() ? WorkerUtils.newDlogNamespaceURI(internalConf.getZookeeperServers()) : WorkerUtils.initializeDlogNamespace(internalConf);
        }
        catch (IOException ioe) {
            log.error("Failed to initialize dlog namespace with zookeeper {} at metadata service uri {} for storing function packages", new Object[]{internalConf.getZookeeperServers(), internalConf.getBookkeeperMetadataServiceUri(), ioe});
            throw ioe;
        }
        return dlogURI;
    }

    @Override
    public void initInBroker(ServiceConfiguration brokerConfig, WorkerConfig workerConfig, PulsarResources pulsarResources, ConfigurationCacheService configurationCacheService, InternalConfigurationData internalConf) throws Exception {
        URI dlogURI;
        String namespace = workerConfig.getPulsarFunctionsNamespace();
        String[] a = workerConfig.getPulsarFunctionsNamespace().split("/");
        String property = a[0];
        String cluster = workerConfig.getPulsarFunctionsCluster();
        Object ar = null;
        try {
            NamedEntity.checkName(property);
            pulsarResources.getTenantResources().create(PolicyPath.path("policies", property), new TenantInfoImpl(Sets.newHashSet(workerConfig.getSuperUserRoles()), Sets.newHashSet(cluster)));
            LOG.info("Created property {} for function worker", (Object)property);
        }
        catch (MetadataStoreException.AlreadyExistsException e) {
            LOG.debug("Failed to create already existing property {} for function worker service", (Object)cluster, (Object)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Failed to create property with invalid name {} for function worker service", (Object)cluster, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to create property {} for function worker", (Object)cluster, (Object)e);
            throw e;
        }
        try {
            NamedEntity.checkName(cluster);
            ClusterDataImpl clusterData = ClusterDataImpl.builder().serviceUrl(workerConfig.getPulsarWebServiceUrl()).brokerServiceUrl(workerConfig.getPulsarServiceUrl()).build();
            pulsarResources.getClusterResources().create(PolicyPath.path("clusters", cluster), clusterData);
            LOG.info("Created cluster {} for function worker", (Object)cluster);
        }
        catch (MetadataStoreException.AlreadyExistsException e) {
            LOG.debug("Failed to create already existing cluster {} for function worker service", (Object)cluster, (Object)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Failed to create cluster with invalid name {} for function worker service", (Object)cluster, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to create cluster {} for function worker service", (Object)cluster, (Object)e);
            throw e;
        }
        try {
            Policies policies = new Policies();
            policies.retention_policies = new RetentionPolicies(-1, -1);
            policies.replication_clusters = Collections.singleton(workerConfig.getPulsarFunctionsCluster());
            int defaultNumberOfBundles = brokerConfig.getDefaultNumberOfNamespaceBundles();
            policies.bundles = PoliciesUtil.getBundles(defaultNumberOfBundles);
            configurationCacheService.policiesCache().invalidate(PolicyPath.path("policies", namespace));
            pulsarResources.getNamespaceResources().create(PolicyPath.path("policies", namespace), policies);
            LOG.info("Created namespace {} for function worker service", (Object)namespace);
        }
        catch (MetadataStoreException.AlreadyExistsException e) {
            LOG.debug("Failed to create already existing namespace {} for function worker service", (Object)namespace);
        }
        catch (Exception e) {
            LOG.error("Failed to create namespace {}", (Object)namespace, (Object)e);
            throw e;
        }
        try {
            dlogURI = workerConfig.isInitializedDlogMetadata().booleanValue() ? WorkerUtils.newDlogNamespaceURI(internalConf.getZookeeperServers()) : WorkerUtils.initializeDlogNamespace(internalConf);
        }
        catch (IOException ioe) {
            LOG.error("Failed to initialize dlog namespace with zookeeper {} at at metadata service uri {} for storing function packages", new Object[]{internalConf.getZookeeperServers(), internalConf.getBookkeeperMetadataServiceUri(), ioe});
            throw ioe;
        }
        this.init(workerConfig, dlogURI, false);
        LOG.info("Function worker service setup completed");
    }

    private void tryCreateNonPartitionedTopic(String topic) throws PulsarAdminException {
        try {
            this.getBrokerAdmin().topics().createNonPartitionedTopic(topic);
        }
        catch (PulsarAdminException e) {
            if (e instanceof PulsarAdminException.ConflictException) {
                log.warn("Failed to create topic '{}': {}", (Object)topic, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void start(AuthenticationService authenticationService, AuthorizationService authorizationService, ErrorNotifier errorNotifier) throws Exception {
        this.workerStatsManager.startupTimeStart();
        log.info("/** Starting worker id={} **/", (Object)this.workerConfig.getWorkerId());
        try {
            log.info("Worker Configs: {}", (Object)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.workerConfig));
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to print worker configs with error {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            DistributedLogConfiguration dlogConf = WorkerUtils.getDlogConf(this.workerConfig);
            try {
                this.dlogNamespace = NamespaceBuilder.newBuilder().conf(dlogConf).clientId("function-worker-" + this.workerConfig.getWorkerId()).uri(this.dlogUri).build();
            }
            catch (Exception e) {
                log.error("Failed to initialize dlog namespace {} for storing function packages", (Object)this.dlogUri, (Object)e);
                throw new RuntimeException(e);
            }
            if (this.workerConfig.getStateStorageServiceUrl() != null) {
                StorageClientSettings clientSettings = StorageClientSettings.newBuilder().serviceUri(this.workerConfig.getStateStorageServiceUrl()).build();
                this.stateStoreAdminClient = StorageClientBuilder.newBuilder().withSettings(clientSettings).buildAdmin();
            }
            String functionWebServiceUrl = StringUtils.isNotBlank(this.workerConfig.getFunctionWebServiceUrl()) ? this.workerConfig.getFunctionWebServiceUrl() : (this.workerConfig.getTlsEnabled() ? this.workerConfig.getWorkerWebAddressTls() : this.workerConfig.getWorkerWebAddress());
            this.brokerAdmin = this.clientCreator.newPulsarAdmin(this.workerConfig.getPulsarWebServiceUrl(), this.workerConfig);
            this.functionAdmin = this.clientCreator.newPulsarAdmin(functionWebServiceUrl, this.workerConfig);
            this.client = this.clientCreator.newPulsarClient(this.workerConfig.getPulsarServiceUrl(), this.workerConfig);
            this.tryCreateNonPartitionedTopic(this.workerConfig.getFunctionAssignmentTopic());
            this.tryCreateNonPartitionedTopic(this.workerConfig.getClusterCoordinationTopic());
            this.tryCreateNonPartitionedTopic(this.workerConfig.getFunctionMetadataTopic());
            this.schedulerManager = new SchedulerManager(this.workerConfig, this.client, this.getBrokerAdmin(), this.workerStatsManager, errorNotifier);
            this.functionMetaDataManager = new FunctionMetaDataManager(this.workerConfig, this.schedulerManager, this.client, errorNotifier);
            this.connectorsManager = new ConnectorsManager(this.workerConfig);
            this.functionsManager = new FunctionsManager(this.workerConfig);
            String coordinationTopic = this.workerConfig.getClusterCoordinationTopic();
            if (!this.getBrokerAdmin().topics().getSubscriptions(coordinationTopic).contains("participants")) {
                this.getBrokerAdmin().topics().createSubscription(coordinationTopic, "participants", MessageId.earliest);
            }
            this.membershipManager = new MembershipManager(this, this.client, this.getBrokerAdmin());
            this.functionRuntimeManager = new FunctionRuntimeManager(this.workerConfig, this, this.dlogNamespace, this.membershipManager, this.connectorsManager, this.functionsManager, this.functionMetaDataManager, this.workerStatsManager, errorNotifier);
            this.functionAssignmentTailer = new FunctionAssignmentTailer(this.functionRuntimeManager, this.client.newReader(), this.workerConfig, errorNotifier);
            this.leaderService = new LeaderService(this, this.client, this.functionAssignmentTailer, this.schedulerManager, this.functionRuntimeManager, this.functionMetaDataManager, this.membershipManager, errorNotifier);
            log.info("/** Start Leader Service **/");
            this.leaderService.start();
            log.info("/** Initializing Metdata Manager **/");
            this.functionMetaDataManager.initialize();
            log.info("/** Initializing Runtime Manager **/");
            MessageId lastAssignmentMessageId = this.functionRuntimeManager.initialize();
            Supplier<Boolean> checkIsStillLeader = () -> this.membershipManager.getLeader().getWorkerId().equals(this.workerConfig.getWorkerId());
            this.schedulerManager.setFunctionMetaDataManager(this.functionMetaDataManager);
            this.schedulerManager.setFunctionRuntimeManager(this.functionRuntimeManager);
            this.schedulerManager.setMembershipManager(this.membershipManager);
            this.schedulerManager.setLeaderService(this.leaderService);
            this.authenticationService = authenticationService;
            this.authorizationService = authorizationService;
            log.info("/** Starting Function Assignment Tailer **/");
            this.functionAssignmentTailer.startFromMessage(lastAssignmentMessageId);
            log.info("/** Starting Metdata Manager **/");
            this.functionMetaDataManager.start();
            this.clusterServiceCoordinator = new ClusterServiceCoordinator(this.workerConfig.getWorkerId(), this.leaderService, checkIsStillLeader);
            this.clusterServiceCoordinator.addTask("membership-monitor", this.workerConfig.getFailureCheckFreqMs(), () -> {
                this.schedulerManager.getSchedulerLock().lock();
                try {
                    this.membershipManager.checkFailures(this.functionMetaDataManager, this.functionRuntimeManager, this.schedulerManager);
                }
                finally {
                    this.schedulerManager.getSchedulerLock().unlock();
                }
            });
            if (this.workerConfig.getRebalanceCheckFreqSec() > 0L) {
                this.clusterServiceCoordinator.addTask("rebalance-periodic-check", this.workerConfig.getRebalanceCheckFreqSec() * 1000L, () -> {
                    try {
                        this.schedulerManager.rebalanceIfNotInprogress().get();
                    }
                    catch (SchedulerManager.RebalanceInProgressException e) {
                        log.info("Scheduled for rebalance but rebalance is already in progress. Ignoring.");
                    }
                    catch (Exception e) {
                        log.warn("Encountered error when running scheduled rebalance", (Throwable)e);
                    }
                });
            }
            log.info("/** Starting Cluster Service Coordinator **/");
            this.clusterServiceCoordinator.start();
            this.isInitialized = true;
            log.info("/** Started worker id={} **/", (Object)this.workerConfig.getWorkerId());
            this.workerStatsManager.setFunctionRuntimeManager(this.functionRuntimeManager);
            this.workerStatsManager.setFunctionMetaDataManager(this.functionMetaDataManager);
            this.workerStatsManager.setLeaderService(this.leaderService);
            this.workerStatsManager.setIsLeader(checkIsStillLeader);
            this.workerStatsManager.startupTimeEnd();
        }
        catch (Throwable t) {
            log.error("Error Starting up in worker", t);
            throw new RuntimeException(t);
        }
    }

    @Override
    public void stop() {
        if (null != this.functionMetaDataManager) {
            try {
                this.functionMetaDataManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function metadata manager", (Throwable)e);
            }
        }
        if (null != this.functionAssignmentTailer) {
            try {
                this.functionAssignmentTailer.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function assignment tailer", (Throwable)e);
            }
        }
        if (null != this.functionRuntimeManager) {
            try {
                this.functionRuntimeManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function runtime manager", (Throwable)e);
            }
        }
        if (null != this.clusterServiceCoordinator) {
            this.clusterServiceCoordinator.close();
        }
        if (null != this.membershipManager) {
            this.membershipManager.close();
        }
        if (null != this.schedulerManager) {
            this.schedulerManager.close();
        }
        if (null != this.leaderService) {
            try {
                this.leaderService.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close leader service", (Throwable)e);
            }
        }
        if (null != this.client) {
            try {
                this.client.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close pulsar client", (Throwable)e);
            }
        }
        if (null != this.getBrokerAdmin()) {
            this.getBrokerAdmin().close();
        }
        if (null != this.functionAdmin) {
            this.functionAdmin.close();
        }
        if (null != this.stateStoreAdminClient) {
            this.stateStoreAdminClient.close();
        }
        if (null != this.dlogNamespace) {
            this.dlogNamespace.close();
        }
        if (this.statsUpdater != null) {
            this.statsUpdater.shutdownNow();
        }
    }

    @Override
    public WorkerConfig getWorkerConfig() {
        return this.workerConfig;
    }

    public PulsarClient getClient() {
        return this.client;
    }

    public FunctionRuntimeManager getFunctionRuntimeManager() {
        return this.functionRuntimeManager;
    }

    public FunctionMetaDataManager getFunctionMetaDataManager() {
        return this.functionMetaDataManager;
    }

    public ClusterServiceCoordinator getClusterServiceCoordinator() {
        return this.clusterServiceCoordinator;
    }

    public Namespace getDlogNamespace() {
        return this.dlogNamespace;
    }

    public StorageAdminClient getStateStoreAdminClient() {
        return this.stateStoreAdminClient;
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public SchedulerManager getSchedulerManager() {
        return this.schedulerManager;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    public ScheduledExecutorService getStatsUpdater() {
        return this.statsUpdater;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ConnectorsManager getConnectorsManager() {
        return this.connectorsManager;
    }

    public FunctionsManager getFunctionsManager() {
        return this.functionsManager;
    }

    public PulsarAdmin getBrokerAdmin() {
        return this.brokerAdmin;
    }

    public PulsarAdmin getFunctionAdmin() {
        return this.functionAdmin;
    }

    public MetricsGenerator getMetricsGenerator() {
        return this.metricsGenerator;
    }

    public URI getDlogUri() {
        return this.dlogUri;
    }

    public LeaderService getLeaderService() {
        return this.leaderService;
    }

    public FunctionAssignmentTailer getFunctionAssignmentTailer() {
        return this.functionAssignmentTailer;
    }

    public WorkerStatsManager getWorkerStatsManager() {
        return this.workerStatsManager;
    }

    public Functions<PulsarWorkerService> getFunctions() {
        return this.functions;
    }

    public FunctionsV2<PulsarWorkerService> getFunctionsV2() {
        return this.functionsV2;
    }

    public Sinks<PulsarWorkerService> getSinks() {
        return this.sinks;
    }

    public Sources<PulsarWorkerService> getSources() {
        return this.sources;
    }

    public Workers<PulsarWorkerService> getWorkers() {
        return this.workers;
    }

    public PulsarClientCreator getClientCreator() {
        return this.clientCreator;
    }

    public static interface PulsarClientCreator {
        public PulsarAdmin newPulsarAdmin(String var1, WorkerConfig var2);

        public PulsarClient newPulsarClient(String var1, WorkerConfig var2);
    }
}

