/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale.CodahaleOpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale.CodahaleStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale.FastTimer;

public class FastCodahaleStatsLogger
extends CodahaleStatsLogger {
    private static final ConcurrentHashMap<String, CodahaleOpStatsLogger> statsLoggerCache = new ConcurrentHashMap();

    FastCodahaleStatsLogger(MetricRegistry metrics, String basename) {
        super(metrics, basename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER", "AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="We use synchronized (statsLoggerCache) to make get/put atomic")
    public OpStatsLogger getOpStatsLogger(String statName) {
        String nameSuccess = MetricRegistry.name((String)this.basename, (String[])new String[]{statName});
        CodahaleOpStatsLogger logger = statsLoggerCache.get(nameSuccess);
        if (logger == null) {
            ConcurrentHashMap<String, CodahaleOpStatsLogger> concurrentHashMap = statsLoggerCache;
            synchronized (concurrentHashMap) {
                logger = statsLoggerCache.get(nameSuccess);
                if (logger == null) {
                    FastTimer failure;
                    FastTimer success;
                    String nameFailure = MetricRegistry.name((String)this.basename, (String[])new String[]{statName + "-fail"});
                    SortedMap timers = this.metrics.getTimers();
                    FastTimer fastTimer = success = timers != null ? (FastTimer)((Object)timers.get(nameSuccess)) : null;
                    if (success == null) {
                        success = new FastTimer(60, FastTimer.Buckets.fine);
                        this.metrics.register(nameSuccess, (Metric)success);
                    }
                    FastTimer fastTimer2 = failure = timers != null ? (FastTimer)((Object)timers.get(nameFailure)) : null;
                    if (failure == null) {
                        failure = new FastTimer(60, FastTimer.Buckets.coarse);
                        this.metrics.register(nameFailure, (Metric)failure);
                    }
                    logger = new CodahaleOpStatsLogger(success, failure);
                    statsLoggerCache.put(nameSuccess, logger);
                }
            }
        }
        return logger;
    }

    @Override
    public StatsLogger scope(String scope) {
        String scopeName = this.basename == null || 0 == this.basename.length() ? scope : MetricRegistry.name((String)this.basename, (String[])new String[]{scope});
        return new FastCodahaleStatsLogger(this.metrics, scopeName);
    }
}

