/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers;

import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.ClientCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryCommand<DiscoveryFlagsT extends CliFlags>
extends ClientCommand<DiscoveryFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryCommand.class);

    protected DiscoveryCommand(CliSpec<DiscoveryFlagsT> spec) {
        super(spec);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean apply(ClientConfiguration clientConf, DiscoveryFlagsT cmdFlags) {
        try {
            URI metadataServiceUri = URI.create(clientConf.getMetadataServiceUri());
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            try {
                try (MetadataClientDriver driver = MetadataDrivers.getClientDriver(metadataServiceUri);){
                    driver.initialize(clientConf, executor, NullStatsLogger.INSTANCE, Optional.empty());
                    this.run(driver.getRegistrationClient(), cmdFlags);
                    boolean bl = true;
                    return bl;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (Collections.singletonList(executor).get(0) != null) {
                    executor.shutdown();
                }
            }
        }
        catch (Exception e) {
            log.error("Fail to process command '{}'", (Object)this.name(), (Object)e);
            return false;
        }
    }

    @Override
    protected void run(BookKeeper bk, DiscoveryFlagsT cmdFlags) throws Exception {
        throw new IllegalStateException("It should never be called.");
    }

    protected abstract void run(RegistrationClient var1, DiscoveryFlagsT var2) throws Exception;
}

