/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.api.raw;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.raw.RawMessage;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.raw.RawMessageId;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.raw.RawMessageIdImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.raw.ReferenceCountedMessageMetadata;

public class RawMessageImpl
implements RawMessage {
    private final RawMessageIdImpl messageId = new RawMessageIdImpl();
    private ReferenceCountedMessageMetadata msgMetadata;
    private final SingleMessageMetadata singleMessageMetadata = new SingleMessageMetadata();
    private ByteBuf payload;
    private static final Recycler<RawMessageImpl> RECYCLER = new Recycler<RawMessageImpl>(){

        @Override
        protected RawMessageImpl newObject(Recycler.Handle<RawMessageImpl> handle) {
            return new RawMessageImpl(handle);
        }
    };
    private final Recycler.Handle<RawMessageImpl> handle;

    private RawMessageImpl(Recycler.Handle<RawMessageImpl> handle) {
        this.handle = handle;
    }

    @Override
    public void release() {
        this.msgMetadata.release();
        this.msgMetadata = null;
        this.singleMessageMetadata.clear();
        this.payload.release();
        this.handle.recycle(this);
    }

    public static RawMessage get(ReferenceCountedMessageMetadata msgMetadata, SingleMessageMetadata singleMessageMetadata, ByteBuf payload, long ledgerId, long entryId, long batchIndex) {
        RawMessageImpl msg = RECYCLER.get();
        msg.msgMetadata = msgMetadata;
        msg.msgMetadata.retain();
        if (singleMessageMetadata != null) {
            msg.singleMessageMetadata.copyFrom(singleMessageMetadata);
        }
        msg.messageId.ledgerId = ledgerId;
        msg.messageId.entryId = entryId;
        msg.messageId.batchIndex = batchIndex;
        msg.payload = payload;
        return msg;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.singleMessageMetadata != null && this.singleMessageMetadata.getPropertiesCount() > 0) {
            return this.singleMessageMetadata.getPropertiesList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue, (oldValue, newValue) -> newValue));
        }
        if (this.msgMetadata.getMetadata().getPropertiesCount() > 0) {
            return this.msgMetadata.getMetadata().getPropertiesList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
        }
        return Collections.emptyMap();
    }

    @Override
    public ByteBuf getData() {
        return this.payload;
    }

    @Override
    public RawMessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public long getPublishTime() {
        return this.msgMetadata.getMetadata().getPublishTime();
    }

    @Override
    public long getEventTime() {
        if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasEventTime()) {
            return this.singleMessageMetadata.getEventTime();
        }
        if (this.msgMetadata.getMetadata().hasEventTime()) {
            return this.msgMetadata.getMetadata().getEventTime();
        }
        return 0L;
    }

    @Override
    public long getSequenceId() {
        return this.msgMetadata.getMetadata().getSequenceId() + this.messageId.batchIndex;
    }

    @Override
    public String getProducerName() {
        return this.msgMetadata.getMetadata().getProducerName();
    }

    @Override
    public Optional<String> getKey() {
        if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasPartitionKey()) {
            return Optional.of(this.singleMessageMetadata.getPartitionKey());
        }
        if (this.msgMetadata.getMetadata().hasPartitionKey()) {
            return Optional.of(this.msgMetadata.getMetadata().getPartitionKey());
        }
        return Optional.empty();
    }

    @Override
    public byte[] getSchemaVersion() {
        if (this.msgMetadata != null && this.msgMetadata.getMetadata().hasSchemaVersion()) {
            return this.msgMetadata.getMetadata().getSchemaVersion();
        }
        return null;
    }

    @Override
    public Optional<ByteBuf> getKeyBytes() {
        if (this.getKey().isPresent()) {
            if (this.hasBase64EncodedKey()) {
                return Optional.of(Unpooled.wrappedBuffer(Base64.getDecoder().decode(this.getKey().get())));
            }
            return Optional.of(Unpooled.wrappedBuffer(this.getKey().get().getBytes(StandardCharsets.UTF_8)));
        }
        return Optional.empty();
    }

    @Override
    public boolean hasBase64EncodedKey() {
        if (this.singleMessageMetadata != null) {
            return this.singleMessageMetadata.isPartitionKeyB64Encoded();
        }
        return this.msgMetadata.getMetadata().isPartitionKeyB64Encoded();
    }

    public int getBatchSize() {
        return this.msgMetadata.getMetadata().getNumMessagesInBatch();
    }
}

