/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceIsolationData;

@ApiModel(value="NamespaceIsolationData", description="The data of namespace isolation configuration")
public class NamespaceIsolationDataImpl
implements NamespaceIsolationData {
    @ApiModelProperty(name="namespaces", value="The list of namespaces to apply this namespace isolation data")
    private List<String> namespaces;
    @ApiModelProperty(name="primary", value="The list of primary brokers for serving the list of namespaces in this isolation policy")
    private List<String> primary;
    @ApiModelProperty(name="primary", value="The list of secondary brokers for serving the list of namespaces in this isolation policy")
    private List<String> secondary;
    @ApiModelProperty(name="auto_failover_policy", value="The data of auto-failover policy configuration", example="{  \"policy_type\": \"min_available\"  \"parameters\": {    \"\": \"\"  }}")
    @JsonProperty(value="auto_failover_policy")
    private AutoFailoverPolicyData autoFailoverPolicy;

    public static NamespaceIsolationDataImplBuilder builder() {
        return new NamespaceIsolationDataImplBuilder();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.namespaces != null && !this.namespaces.isEmpty() && this.primary != null && !this.primary.isEmpty() && this.validateRegex(this.primary) && this.secondary != null && this.validateRegex(this.secondary) && this.autoFailoverPolicy != null);
        this.autoFailoverPolicy.validate();
    }

    private boolean validateRegex(List<String> policies) {
        if (policies != null && !policies.isEmpty()) {
            policies.forEach(policy -> {
                try {
                    if (StringUtils.isNotBlank(policy)) {
                        Pattern.compile(policy);
                    }
                }
                catch (PatternSyntaxException exception) {
                    throw new IllegalArgumentException("invalid policy regex " + policy);
                }
            });
        }
        return true;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public List<String> getPrimary() {
        return this.primary;
    }

    @Override
    public List<String> getSecondary() {
        return this.secondary;
    }

    @Override
    public AutoFailoverPolicyData getAutoFailoverPolicy() {
        return this.autoFailoverPolicy;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public void setPrimary(List<String> primary) {
        this.primary = primary;
    }

    public void setSecondary(List<String> secondary) {
        this.secondary = secondary;
    }

    @JsonProperty(value="auto_failover_policy")
    public void setAutoFailoverPolicy(AutoFailoverPolicyData autoFailoverPolicy) {
        this.autoFailoverPolicy = autoFailoverPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamespaceIsolationDataImpl)) {
            return false;
        }
        NamespaceIsolationDataImpl other = (NamespaceIsolationDataImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$namespaces = this.getNamespaces();
        List<String> other$namespaces = other.getNamespaces();
        if (this$namespaces == null ? other$namespaces != null : !((Object)this$namespaces).equals(other$namespaces)) {
            return false;
        }
        List<String> this$primary = this.getPrimary();
        List<String> other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        List<String> this$secondary = this.getSecondary();
        List<String> other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        AutoFailoverPolicyData this$autoFailoverPolicy = this.getAutoFailoverPolicy();
        AutoFailoverPolicyData other$autoFailoverPolicy = other.getAutoFailoverPolicy();
        return !(this$autoFailoverPolicy == null ? other$autoFailoverPolicy != null : !this$autoFailoverPolicy.equals(other$autoFailoverPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NamespaceIsolationDataImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $namespaces = this.getNamespaces();
        result = result * 59 + ($namespaces == null ? 43 : ((Object)$namespaces).hashCode());
        List<String> $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        List<String> $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        AutoFailoverPolicyData $autoFailoverPolicy = this.getAutoFailoverPolicy();
        result = result * 59 + ($autoFailoverPolicy == null ? 43 : $autoFailoverPolicy.hashCode());
        return result;
    }

    public String toString() {
        return "NamespaceIsolationDataImpl(namespaces=" + this.getNamespaces() + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", autoFailoverPolicy=" + this.getAutoFailoverPolicy() + ")";
    }

    public NamespaceIsolationDataImpl(List<String> namespaces, List<String> primary, List<String> secondary, AutoFailoverPolicyData autoFailoverPolicy) {
        this.namespaces = namespaces;
        this.primary = primary;
        this.secondary = secondary;
        this.autoFailoverPolicy = autoFailoverPolicy;
    }

    public NamespaceIsolationDataImpl() {
    }

    public static class NamespaceIsolationDataImplBuilder
    implements NamespaceIsolationData.Builder {
        private List<String> namespaces = new ArrayList<String>();
        private List<String> primary = new ArrayList<String>();
        private List<String> secondary = new ArrayList<String>();
        private AutoFailoverPolicyData autoFailoverPolicy;

        @Override
        public NamespaceIsolationDataImplBuilder namespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        @Override
        public NamespaceIsolationDataImplBuilder primary(List<String> primary) {
            this.primary = primary;
            return this;
        }

        @Override
        public NamespaceIsolationDataImplBuilder secondary(List<String> secondary) {
            this.secondary = secondary;
            return this;
        }

        @Override
        public NamespaceIsolationDataImplBuilder autoFailoverPolicy(AutoFailoverPolicyData autoFailoverPolicy) {
            this.autoFailoverPolicy = autoFailoverPolicy;
            return this;
        }

        @Override
        public NamespaceIsolationDataImpl build() {
            return new NamespaceIsolationDataImpl(this.namespaces, this.primary, this.secondary, this.autoFailoverPolicy);
        }
    }
}

