/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;

public class ClassLoaderUtils {
    public static ClassLoader loadJar(File jar) throws MalformedURLException {
        URL url = jar.toURI().toURL();
        return AccessController.doPrivileged(() -> new URLClassLoader(new URL[]{url}));
    }

    public static ClassLoader extractClassLoader(File packageFile) throws Exception {
        if (packageFile != null) {
            return ClassLoaderUtils.loadJar(packageFile);
        }
        return null;
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> objectClass;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (classLoader != null) {
                objectClass = classLoader.loadClass(className);
            }
            throw e;
        }
        return objectClass;
    }

    public static void implementsClass(String className, Class<?> klass, ClassLoader classLoader) {
        Class<?> objectClass;
        try {
            objectClass = ClassLoaderUtils.loadClass(className, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException("Cannot find/load class " + className);
        }
        if (!klass.isAssignableFrom(objectClass)) {
            throw new IllegalArgumentException(String.format("%s does not implement %s", className, klass.getName()));
        }
    }
}

