/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.quorum;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SessionTracker;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.LocalSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpgradeableSessionTracker
implements SessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeableSessionTracker.class);
    private ConcurrentMap<Long, Integer> localSessionsWithTimeouts;
    private ConcurrentMap<Long, Integer> upgradingSessions;
    protected LocalSessionTracker localSessionTracker;
    protected boolean localSessionsEnabled;

    public void start() {
    }

    public void createLocalSessionTracker(SessionTracker.SessionExpirer expirer, int tickTime, long id, ZooKeeperServerListener listener) {
        this.localSessionsWithTimeouts = new ConcurrentHashMap<Long, Integer>();
        this.localSessionTracker = new LocalSessionTracker(expirer, this.localSessionsWithTimeouts, tickTime, id, listener);
        this.upgradingSessions = new ConcurrentHashMap<Long, Integer>();
    }

    @Override
    public boolean isTrackingSession(long sessionId) {
        return this.isLocalSession(sessionId) || this.isGlobalSession(sessionId);
    }

    public boolean isLocalSession(long sessionId) {
        return this.localSessionTracker != null && this.localSessionTracker.isTrackingSession(sessionId);
    }

    @Override
    public boolean isLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public boolean isUpgradingSession(long sessionId) {
        return this.upgradingSessions != null && this.upgradingSessions.containsKey(sessionId);
    }

    public void finishedUpgrading(long sessionId) {
        if (this.upgradingSessions != null) {
            this.upgradingSessions.remove(sessionId);
        }
    }

    public abstract boolean isGlobalSession(long var1);

    public int upgradeSession(long sessionId) {
        if (this.localSessionsWithTimeouts == null) {
            return -1;
        }
        Integer timeout = (Integer)this.localSessionsWithTimeouts.remove(sessionId);
        if (timeout != null) {
            LOG.info("Upgrading session 0x{}", (Object)Long.toHexString(sessionId));
            this.trackSession(sessionId, timeout);
            this.upgradingSessions.put(sessionId, timeout);
            this.localSessionTracker.removeSession(sessionId);
            return timeout;
        }
        return -1;
    }

    protected void removeLocalSession(long sessionId) {
        if (this.localSessionTracker == null) {
            return;
        }
        this.localSessionTracker.removeSession(sessionId);
    }

    @Override
    public void checkGlobalSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLocalSessionCount() {
        if (this.localSessionsWithTimeouts == null) {
            return 0L;
        }
        return this.localSessionsWithTimeouts.size();
    }
}

