/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.decoders;

import org.apache.pulsar.shade.javax.websocket.DecodeException;
import org.apache.pulsar.shade.javax.websocket.Decoder;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class ByteDecoder
extends AbstractDecoder
implements Decoder.Text<Byte> {
    public static final ByteDecoder INSTANCE = new ByteDecoder();

    @Override
    public Byte decode(String s) throws DecodeException {
        try {
            return Byte.parseByte(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Byte", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Byte.parseByte(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

