/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperSessionExpiredHandler;

public class ZookeeperSessionExpiredHandlers {
    public static final String SHUTDOWN_POLICY = "shutdown";
    public static final String RECONNECT_POLICY = "reconnect";

    public static ZookeeperSessionExpiredHandler shutdownWhenZookeeperSessionExpired(ZooKeeperSessionWatcher.ShutdownService shutdownService) {
        return new ShutDownWhenSessionExpired(shutdownService);
    }

    public static ZookeeperSessionExpiredHandler reconnectWhenZookeeperSessionExpired(PulsarService pulsarService, ZooKeeperSessionWatcher.ShutdownService shutdownService) {
        return new ReconnectWhenSessionExpired(pulsarService, shutdownService);
    }

    public static class ReconnectWhenSessionExpired
    implements ZookeeperSessionExpiredHandler {
        private final PulsarService pulsarService;
        private ZooKeeperSessionWatcher watcher;
        private final ZooKeeperSessionWatcher.ShutdownService shutdownService;

        public ReconnectWhenSessionExpired(PulsarService pulsarService, ZooKeeperSessionWatcher.ShutdownService shutdownService) {
            this.pulsarService = pulsarService;
            this.shutdownService = shutdownService;
        }

        @Override
        public void onSessionExpired() {
            if (this.pulsarService.getNamespaceService() == null) {
                this.watcher.close();
                this.shutdownService.shutdown(-1);
            }
            this.pulsarService.getNamespaceService().registerOwnedBundles();
        }

        @Override
        public void setWatcher(ZooKeeperSessionWatcher watcher) {
            this.watcher = watcher;
        }
    }

    public static class ShutDownWhenSessionExpired
    implements ZookeeperSessionExpiredHandler {
        private final ZooKeeperSessionWatcher.ShutdownService shutdownService;
        private ZooKeeperSessionWatcher watcher;

        public ShutDownWhenSessionExpired(ZooKeeperSessionWatcher.ShutdownService shutdownService) {
            this.shutdownService = shutdownService;
        }

        @Override
        public void setWatcher(ZooKeeperSessionWatcher watcher) {
            this.watcher = watcher;
        }

        @Override
        public void onSessionExpired() {
            this.watcher.close();
            this.shutdownService.shutdown(-1);
        }
    }
}

