/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.ZkAdminPaths;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.internal.TopicsImpl;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.pulsar.shade.javax.servlet.ServletContext;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminResource
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);
    public static final String POLICIES_READONLY_FLAG_PATH = "/admin/flags/policies-readonly";
    public static final String PARTITIONED_TOPIC_PATH_ZNODE = "partitioned-topics";
    private static final String MANAGED_LEDGER_PATH_ZNODE = "/managed-ledgers";
    protected NamespaceName namespaceName;
    protected TopicName topicName;

    protected BookKeeper bookKeeper() {
        return this.pulsar().getBookKeeperClient();
    }

    protected ZooKeeper localZk() {
        return this.pulsar().getZkClient();
    }

    protected ZooKeeperCache localZkCache() {
        return this.pulsar().getLocalZkCache();
    }

    protected LocalZooKeeperCacheService localCacheService() {
        return this.pulsar().getLocalZkCacheService();
    }

    protected void localZKCreate(String path, byte[] content) throws Exception {
        this.localZk().create(path, content, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    protected String domain() {
        if (this.uri.getPath().startsWith("persistent/")) {
            return "persistent";
        }
        if (this.uri.getPath().startsWith("non-persistent/")) {
            return "non-persistent";
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "domain() invoked from wrong resource");
    }

    @Override
    public void validateSuperUserAccess() {
        super.validateSuperUserAccess();
    }

    @Override
    protected void validateAdminAccessForTenant(String property) {
        super.validateAdminAccessForTenant(property);
    }

    @Override
    protected void validateBundleOwnership(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        super.validateBundleOwnership(property, cluster, namespace, authoritative, readOnly, bundle);
    }

    @Override
    protected boolean isLeaderBroker() {
        return super.isLeaderBroker();
    }

    @Override
    public void validatePoliciesReadOnlyAccess() {
        boolean arePoliciesReadOnly = true;
        try {
            arePoliciesReadOnly = this.pulsar().getPulsarResources().getNamespaceResources().exists(POLICIES_READONLY_FLAG_PATH);
        }
        catch (Exception e) {
            log.warn("Unable to fetch contents of [{}] from global zookeeper", (Object)POLICIES_READONLY_FLAG_PATH, (Object)e);
            throw new RestException(e);
        }
        if (arePoliciesReadOnly) {
            log.debug("Policies are read-only. Broker cannot do read-write operations");
            throw new RestException(Response.Status.FORBIDDEN, "Broker is forbidden to do read-write operations");
        }
        log.debug("Broker is allowed to make read-write operations");
    }

    protected CompletableFuture<Void> tryCreatePartitionsAsync(int numPartitions) {
        if (!this.topicName.isPersistent()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            futures.add(this.tryCreatePartitionAsync(i, null));
        }
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Void> tryCreatePartitionAsync(int partition, CompletableFuture<Void> reuseFuture) {
        CompletableFuture<Void> result = reuseFuture == null ? new CompletableFuture<Void>() : reuseFuture;
        Optional<MetadataStoreExtended> localStore = this.getPulsarResources().getLocalMetadataStore();
        if (!localStore.isPresent()) {
            result.completeExceptionally(new IllegalStateException("metadata store not initialized"));
            return result;
        }
        ((CompletableFuture)localStore.get().put(ZkAdminPaths.managedLedgerPath(this.topicName.getPartition(partition)), new byte[0], Optional.of(-1L)).thenAccept(r -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Topic partition {} created.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
            }
            result.complete(null);
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.AlreadyExistsException) {
                log.info("[{}] Topic partition {} is exists, doing nothing.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
                result.complete(null);
            } else if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                log.warn("[{}] Partitioned topic {} is already created.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
                result.complete(null);
            } else {
                log.error("[{}] Fail to create topic partition {}", new Object[]{this.clientAppId(), this.topicName.getPartition(partition), ex.getCause()});
                result.completeExceptionally(ex.getCause());
            }
            return null;
        });
        return result;
    }

    protected void validateNamespaceName(String property, String namespace) {
        try {
            this.namespaceName = NamespaceName.get(property, namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create namespace with invalid name {}", new Object[]{this.clientAppId(), namespace, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateGlobalNamespaceOwnership(String property, String namespace) {
        try {
            this.namespaceName = NamespaceName.get(property, namespace);
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name or namespace is not valid");
        }
        catch (RestException re) {
            if (re.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new RestException(Response.Status.NOT_FOUND, "Namespace not found");
            }
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace does not have any clusters configured");
        }
        catch (Exception e) {
            log.warn("Failed to validate global cluster configuration : ns={}  emsg={}", (Object)namespace, (Object)e.getMessage());
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Failed to validate global cluster configuration");
        }
    }

    @Deprecated
    protected void validateNamespaceName(String property, String cluster, String namespace) {
        try {
            this.namespaceName = NamespaceName.get(property, cluster, namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create namespace with invalid name {}", new Object[]{this.clientAppId(), namespace, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateTopicName(String property, String namespace, String encodedTopic) {
        String topic = Codec.decode(encodedTopic);
        try {
            this.namespaceName = NamespaceName.get(property, namespace);
            this.topicName = TopicName.get(this.domain(), this.namespaceName, topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to validate topic name {}://{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, namespace, topic, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    protected void validatePartitionedTopicName(String tenant, String namespace, String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        if (encodedTopic.contains("-partition-")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Partitioned Topic Name should not contain '-partition-'");
        }
    }

    protected void validatePartitionedTopicMetadata(String tenant, String namespace, String encodedTopic) {
        try {
            PartitionedTopicMetadata partitionedTopicMetadata = this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).get();
            if (partitionedTopicMetadata.partitions < 1) {
                throw new RestException(Response.Status.CONFLICT, "Topic is not partitioned topic");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to validate partitioned topic metadata {}://{}/{}/{}", new Object[]{this.domain(), tenant, namespace, this.topicName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Check topic partition meta failed.");
        }
    }

    @Deprecated
    protected void validateTopicName(String property, String cluster, String namespace, String encodedTopic) {
        String topic = Codec.decode(encodedTopic);
        try {
            this.namespaceName = NamespaceName.get(property, cluster, namespace);
            this.topicName = TopicName.get(this.domain(), this.namespaceName, topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to validate topic name {}://{}/{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, cluster, namespace, topic, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    protected Policies getNamespacePolicies(NamespaceName namespaceName) {
        try {
            String namespace = namespaceName.toString();
            String policyPath = AdminResource.path("policies", namespace);
            Policies policies = (Policies)this.namespaceResources().get(policyPath).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            BundlesData bundleData = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(namespaceName).getBundlesData();
            policies.bundles = bundleData != null ? bundleData : policies.bundles;
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Policies> getNamespacePoliciesAsync(NamespaceName namespaceName) {
        String namespace = namespaceName.toString();
        String policyPath = AdminResource.path("policies", namespace);
        return this.namespaceResources().getAsync(policyPath).thenCompose(policies -> {
            if (policies.isPresent()) {
                return this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundlesAsync(namespaceName).thenCompose(bundles -> {
                    BundlesData bundleData = null;
                    try {
                        bundleData = bundles.getBundlesData();
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
                        return FutureUtil.failedFuture(new RestException(e));
                    }
                    ((Policies)policies.get()).bundles = bundleData != null ? bundleData : ((Policies)policies.get()).bundles;
                    return CompletableFuture.completedFuture(policies.get());
                });
            }
            return FutureUtil.failedFuture(new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
        });
    }

    protected void mergeNamespaceWithDefaults(Policies policies, String namespace, String namespacePath) {
        ServiceConfiguration config = this.pulsar().getConfiguration();
        if (policies.max_consumers_per_subscription < 1) {
            policies.max_consumers_per_subscription = config.getMaxConsumersPerSubscription();
        }
        String cluster = config.getClusterName();
    }

    protected BacklogQuota namespaceBacklogQuota(String namespace, String namespacePath, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        return this.pulsar().getBrokerService().getBacklogQuotaManager().getBacklogQuota(namespace, namespacePath, backlogQuotaType);
    }

    protected CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsyncWithRetry(TopicName topicName) {
        try {
            this.checkTopicLevelPolicyEnable();
            return this.pulsar().getTopicPoliciesService().getTopicPoliciesAsyncWithRetry(topicName, null, this.pulsar().getExecutor());
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic policies {}", new Object[]{this.clientAppId(), topicName, e});
            return FutureUtil.failedFuture(e);
        }
    }

    protected boolean checkBacklogQuota(BacklogQuota quota, RetentionPolicies retention) {
        if (retention == null || retention.getRetentionSizeInMB() <= 0L || retention.getRetentionTimeInMinutes() <= 0) {
            return true;
        }
        if (quota == null) {
            quota = this.pulsar().getBrokerService().getBacklogQuotaManager().getDefaultQuota();
        }
        if (quota.getLimitSize() >= retention.getRetentionSizeInMB() * 1024L * 1024L) {
            return false;
        }
        return quota.getLimitTime() < retention.getRetentionTimeInMinutes() * 60;
    }

    protected void checkTopicLevelPolicyEnable() {
        if (!this.config().isTopicLevelPoliciesEnabled()) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Topic level policies is disabled, to enable the topic level policy and retry.");
        }
    }

    protected DispatchRateImpl dispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerTopicInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerTopicInByte()).ratePeriodInSecond(1).build();
    }

    protected DispatchRateImpl subscriptionDispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerSubscriptionInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerSubscriptionInByte()).ratePeriodInSecond(1).build();
    }

    protected DispatchRateImpl replicatorDispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerReplicatorInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerReplicatorInByte()).ratePeriodInSecond(1).build();
    }

    protected SubscribeRate subscribeRate() {
        return new SubscribeRate(this.pulsar().getConfiguration().getSubscribeThrottlingRatePerConsumer(), this.pulsar().getConfiguration().getSubscribeRatePeriodPerConsumerInSecond());
    }

    public static ObjectMapper jsonMapper() {
        return ObjectMapperFactory.getThreadLocal();
    }

    protected Set<String> clusters() {
        try {
            Set<String> clusters = this.clusterResources().list().stream().filter(cluster -> !"global".equals(cluster)).collect(Collectors.toSet());
            return clusters;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        try {
            this.validateClusterOwnership(topicName.getCluster());
        }
        catch (Exception e) {
            return FutureUtil.failedFuture(e);
        }
        return ((CompletableFuture)this.validateGlobalNamespaceOwnershipAsync(topicName.getNamespaceObject()).thenRun(() -> this.validateTopicOperation(topicName, TopicOperation.LOOKUP))).thenCompose(__ -> {
            if (checkAllowAutoCreation) {
                return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName);
            }
            return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(topicName);
        });
    }

    protected PartitionedTopicMetadata getPartitionedTopicMetadata(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        this.validateClusterOwnership(topicName.getCluster());
        this.validateGlobalNamespaceOwnership(topicName.getNamespaceObject());
        try {
            this.validateTopicOperation(topicName, TopicOperation.LOOKUP);
        }
        catch (Exception e) {
            log.warn("Unexpected error while authorizing lookup. topic={}, role={}. Error: {}", new Object[]{topicName, this.clientAppId(), e.getMessage(), e});
            throw new RestException(e);
        }
        PartitionedTopicMetadata partitionMetadata = checkAllowAutoCreation ? AdminResource.fetchPartitionedTopicMetadataCheckAllowAutoCreation(this.pulsar(), topicName) : AdminResource.fetchPartitionedTopicMetadata(this.pulsar(), topicName);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Total number of partitions for topic {} is {}", new Object[]{this.clientAppId(), topicName, partitionMetadata.partitions});
        }
        return partitionMetadata;
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadata(PulsarService pulsar, TopicName topicName) {
        try {
            return pulsar.getBrokerService().fetchPartitionedTopicMetadataAsync(topicName).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)e.getCause();
            }
            throw new RestException(e);
        }
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadataCheckAllowAutoCreation(PulsarService pulsar, TopicName topicName) {
        try {
            return pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)e.getCause();
            }
            throw new RestException(e);
        }
    }

    @Override
    protected void validateClusterExists(String cluster) {
        try {
            if (!this.clusterResources().get(AdminResource.path("clusters", cluster)).isPresent()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster " + cluster + " does not exist.");
            }
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected Policies getNamespacePolicies(String property, String cluster, String namespace) {
        try {
            Policies policies = (Policies)this.namespaceResources().get(AdminResource.path("policies", property, cluster, namespace)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            BundlesData bundleData = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(NamespaceName.get(property, cluster, namespace)).getBundlesData();
            policies.bundles = bundleData != null ? bundleData : policies.bundles;
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}/{}/{}", new Object[]{this.clientAppId(), property, cluster, namespace, e});
            throw new RestException(e);
        }
    }

    protected boolean isNamespaceReplicated(NamespaceName namespaceName) {
        return this.getNamespaceReplicatedClusters(namespaceName).size() > 1;
    }

    protected Set<String> getNamespaceReplicatedClusters(NamespaceName namespaceName) {
        try {
            Policies policies = (Policies)this.namespaceResources().get(ZkAdminPaths.namespacePoliciesPath(namespaceName)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            return policies.replication_clusters;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected List<String> getPartitionedTopicList(TopicDomain topicDomain) {
        List<String> partitionedTopics = Lists.newArrayList();
        try {
            String partitionedTopicPath = AdminResource.path(PARTITIONED_TOPIC_PATH_ZNODE, this.namespaceName.toString(), topicDomain.value());
            List<String> topics = this.namespaceResources().getChildren(partitionedTopicPath);
            partitionedTopics = topics.stream().map(s -> String.format("%s://%s/%s", topicDomain.value(), this.namespaceName.toString(), Codec.decode(s))).collect(Collectors.toList());
        }
        catch (MetadataStoreException.NotFoundException partitionedTopicPath) {
        }
        catch (Exception e) {
            log.error("[{}] Failed to get partitioned topic list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
        partitionedTopics.sort(null);
        return partitionedTopics;
    }

    protected List<String> getTopicPartitionList(TopicDomain topicDomain) {
        List<String> topicPartitions = Lists.newArrayList();
        try {
            String topicPartitionPath = AdminResource.joinPath(MANAGED_LEDGER_PATH_ZNODE, this.namespaceName.toString(), topicDomain.value());
            List<String> topics = this.localZk().getChildren(topicPartitionPath, false);
            topicPartitions = topics.stream().map(s -> String.format("%s://%s/%s", topicDomain.value(), this.namespaceName.toString(), Codec.decode(s))).collect(Collectors.toList());
        }
        catch (KeeperException.NoNodeException topicPartitionPath) {
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic partition list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
        topicPartitions.sort(null);
        return topicPartitions;
    }

    protected void internalCreatePartitionedTopic(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly) {
        Integer maxTopicsPerNamespace;
        block11: {
            maxTopicsPerNamespace = null;
            try {
                Policies policies = this.getNamespacePolicies(this.namespaceName);
                maxTopicsPerNamespace = policies.max_topics_per_namespace;
            }
            catch (RestException e) {
                if (e.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) break block11;
                log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        try {
            List<String> partitionedTopics;
            if (maxTopicsPerNamespace == null) {
                maxTopicsPerNamespace = this.pulsar().getConfig().getMaxTopicsPerNamespace();
            }
            if (maxTopicsPerNamespace > 0 && (partitionedTopics = this.getTopicPartitionList(TopicDomain.persistent)).size() + numPartitions > maxTopicsPerNamespace) {
                log.error("[{}] Failed to create partitioned topic {}, exceed maximum number of topics in namespace", (Object)this.clientAppId(), (Object)this.topicName);
                this.resumeAsyncResponseExceptionally(asyncResponse, new RestException(Response.Status.PRECONDITION_FAILED, "Exceed maximum number of topics in namespace."));
                return;
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
        try {
            this.validateNamespaceOperation(this.topicName.getNamespaceObject(), NamespaceOperation.CREATE_TOPIC);
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        if (numPartitions <= 0) {
            asyncResponse.resume(new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be more than 0"));
            return;
        }
        if (maxPartitions > 0 && numPartitions > maxPartitions) {
            asyncResponse.resume(new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions));
            return;
        }
        ArrayList createFutureList = new ArrayList();
        CompletableFuture createLocalFuture = new CompletableFuture();
        createFutureList.add(createLocalFuture);
        ((CompletableFuture)this.checkTopicExistsAsync(this.topicName).thenAccept(exists -> {
            if (exists.booleanValue()) {
                log.warn("[{}] Failed to create already existing topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                asyncResponse.resume(new RestException(Response.Status.CONFLICT, "This topic already exists"));
                return;
            }
            ((CompletableFuture)this.provisionPartitionedTopicPath(asyncResponse, numPartitions, createLocalTopicOnly).thenCompose(ignored -> this.tryCreatePartitionsAsync(numPartitions))).whenComplete((ignored, ex) -> {
                if (ex != null) {
                    createLocalFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                createLocalFuture.complete(null);
            });
        })).exceptionally(ex -> {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
            return null;
        });
        if (!createLocalTopicOnly && this.topicName.isGlobal() && this.isNamespaceReplicated(this.namespaceName)) {
            this.getNamespaceReplicatedClusters(this.namespaceName).stream().filter(cluster -> !cluster.equals(this.pulsar().getConfiguration().getClusterName())).forEach(cluster -> createFutureList.add(((TopicsImpl)this.pulsar().getBrokerService().getClusterPulsarAdmin((String)cluster).topics()).createPartitionedTopicAsync(this.topicName.getPartitionedTopicName(), numPartitions, true)));
        }
        FutureUtil.waitForAll(createFutureList).whenComplete((ignored, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to create partitions for topic {}", new Object[]{this.clientAppId(), this.topicName, ex.getCause()});
                if (ex.getCause() instanceof RestException) {
                    asyncResponse.resume(ex.getCause());
                } else {
                    this.resumeAsyncResponseExceptionally(asyncResponse, ex.getCause());
                }
                return;
            }
            log.info("[{}] Successfully created partitions for topic {} in cluster {}", new Object[]{this.clientAppId(), this.topicName, this.pulsar().getConfiguration().getClusterName()});
            asyncResponse.resume(Response.noContent().build());
        });
    }

    protected CompletableFuture<Boolean> checkTopicExistsAsync(TopicName topicName) {
        return this.pulsar().getNamespaceService().getListOfTopics(topicName.getNamespaceObject(), CommandGetTopicsOfNamespace.Mode.ALL).thenCompose(topics -> {
            boolean exists = false;
            for (String topic : topics) {
                if (!topicName.getPartitionedTopicName().equals(TopicName.get(topic).getPartitionedTopicName())) continue;
                exists = true;
                break;
            }
            return CompletableFuture.completedFuture(exists);
        });
    }

    private CompletableFuture<Void> provisionPartitionedTopicPath(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        String partitionedTopicPath = ZkAdminPaths.partitionedTopicPath(this.topicName);
        this.namespaceResources().getPartitionedTopicResources().createAsync(partitionedTopicPath, new PartitionedTopicMetadata(numPartitions)).whenComplete((ignored, ex) -> {
            if (ex != null) {
                if (ex instanceof MetadataStoreException.AlreadyExistsException) {
                    if (createLocalTopicOnly) {
                        future.complete(null);
                        return;
                    }
                    log.warn("[{}] Failed to create already existing partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    future.completeExceptionally(new RestException(Response.Status.CONFLICT, "Partitioned topic already exists"));
                } else if (ex instanceof MetadataStoreException.BadVersionException) {
                    log.warn("[{}] Failed to create partitioned topic {}: concurrent modification", (Object)this.clientAppId(), (Object)this.topicName);
                    future.completeExceptionally(new RestException(Response.Status.CONFLICT, "Concurrent modification"));
                } else {
                    log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    future.completeExceptionally(new RestException(ex.getCause()));
                }
                return;
            }
            log.info("[{}] Successfully created partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            future.complete(null);
        });
        return future;
    }

    protected void resumeAsyncResponseExceptionally(AsyncResponse asyncResponse, Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            asyncResponse.resume(throwable);
        } else if (throwable instanceof BrokerServiceException.NotAllowedException) {
            asyncResponse.resume(new RestException(Response.Status.CONFLICT, throwable));
        } else {
            asyncResponse.resume(new RestException(throwable));
        }
    }

    protected CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync() {
        return this.getNamespacePoliciesAsync(this.namespaceName).thenApply(policies -> {
            SchemaCompatibilityStrategy schemaCompatibilityStrategy = policies.schema_compatibility_strategy;
            if (SchemaCompatibilityStrategy.isUndefined(schemaCompatibilityStrategy) && SchemaCompatibilityStrategy.isUndefined(schemaCompatibilityStrategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy(policies.schema_auto_update_compatibility_strategy))) {
                schemaCompatibilityStrategy = this.pulsar().getConfig().getSchemaCompatibilityStrategy();
            }
            return schemaCompatibilityStrategy;
        });
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference) {
        return Preconditions.checkNotNull(reference);
    }

    protected void checkNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected boolean isManagedLedgerNotFoundException(Exception e) {
        Throwable cause = e.getCause();
        return cause instanceof ManagedLedgerException.MetadataNotFoundException || cause instanceof MetadataStoreException.NotFoundException;
    }

    protected void checkArgument(boolean b, String errorMessage) {
        if (!b) {
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected void validatePersistencePolicies(PersistencePolicies persistence) {
        this.checkNotNull(persistence, "persistence policies should not be null");
        ServiceConfiguration config = this.pulsar().getConfiguration();
        this.checkArgument(persistence.getBookkeeperEnsemble() <= config.getManagedLedgerMaxEnsembleSize(), "Bookkeeper-Ensemble must be <= " + config.getManagedLedgerMaxEnsembleSize());
        this.checkArgument(persistence.getBookkeeperWriteQuorum() <= config.getManagedLedgerMaxWriteQuorum(), "Bookkeeper-WriteQuorum must be <= " + config.getManagedLedgerMaxWriteQuorum());
        this.checkArgument(persistence.getBookkeeperAckQuorum() <= config.getManagedLedgerMaxAckQuorum(), "Bookkeeper-AckQuorum must be <= " + config.getManagedLedgerMaxAckQuorum());
        this.checkArgument(persistence.getBookkeeperEnsemble() >= persistence.getBookkeeperWriteQuorum() && persistence.getBookkeeperWriteQuorum() >= persistence.getBookkeeperAckQuorum(), String.format("Bookkeeper Ensemble (%s) >= WriteQuorum (%s) >= AckQuoru (%s)", persistence.getBookkeeperEnsemble(), persistence.getBookkeeperWriteQuorum(), persistence.getBookkeeperAckQuorum()));
    }
}

