/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.javax.ws.rs.core.UriBuilder;
import org.apache.pulsar.shade.org.apache.commons.lang.mutable.MutableObject;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.impl.AutoTopicCreationOverrideImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamespacesBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(NamespacesBase.class);

    protected List<String> internalGetTenantNamespaces(String tenant) {
        this.checkNotNull(tenant, "Tenant should not be null");
        try {
            NamedEntity.checkName(tenant);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Tenant name is invalid {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name is not valid");
        }
        this.validateTenantOperation(tenant, TenantOperation.LIST_NAMESPACES);
        try {
            return this.getListOfNamespaces(tenant);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get namespace list for tenant: {} - Does not exist", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.NOT_FOUND, "Property does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespaces list: {}", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    protected void internalCreateNamespace(Policies policies) {
        this.validateTenantOperation(this.namespaceName.getTenant(), TenantOperation.CREATE_NAMESPACE);
        this.validatePoliciesReadOnlyAccess();
        this.validatePolicies(this.namespaceName, policies);
        try {
            List<String> namespaces;
            int maxNamespacesPerTenant = this.pulsar().getConfiguration().getMaxNamespacesPerTenant();
            if (maxNamespacesPerTenant > 0 && (namespaces = this.getListOfNamespaces(this.namespaceName.getTenant())) != null && namespaces.size() > maxNamespacesPerTenant) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Exceed the maximum number of namespace in tenant :" + this.namespaceName.getTenant());
            }
            this.namespaceResources().create(NamespacesBase.path("policies", this.namespaceName.toString()), policies);
            log.info("[{}] Created namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (MetadataStoreException.AlreadyExistsException e) {
            log.warn("[{}] Failed to create namespace {} - already exists", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Namespace already exists");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteNamespace(AsyncResponse asyncResponse, boolean authoritative, boolean force) {
        if (force) {
            this.internalDeleteNamespaceForcefully(asyncResponse, authoritative);
        } else {
            this.internalDeleteNamespace(asyncResponse, authoritative);
        }
    }

    protected void internalDeleteNamespace(AsyncResponse asyncResponse, boolean authoritative) {
        boolean isEmpty;
        List<String> topics;
        this.validateTenantOperation(this.namespaceName.getTenant(), TenantOperation.DELETE_NAMESPACE);
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Object policiesNode1 = null;
        Policies policies = null;
        try {
            policies = (Policies)this.namespaceResources().get(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist."));
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = Lists.newArrayList(policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clusterResources().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank(replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri(this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", false).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume(wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        try {
            topics = this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).get(this.config().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
            topics.addAll(this.getPartitionedTopicList(TopicDomain.persistent));
            topics.addAll(this.getPartitionedTopicList(TopicDomain.non_persistent));
            isEmpty = topics.isEmpty();
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        if (!isEmpty) {
            if (log.isDebugEnabled()) {
                log.debug("Found topics on namespace {}", (Object)this.namespaceName);
            }
            boolean hasNonSystemTopic = false;
            for (String topic : topics) {
                if (SystemTopicClient.isSystemTopic(TopicName.get(topic))) continue;
                hasNonSystemTopic = true;
                break;
            }
            if (hasNonSystemTopic) {
                asyncResponse.resume(new RestException(Response.Status.CONFLICT, "Cannot delete non empty namespace"));
                return;
            }
        }
        try {
            this.namespaceResources().set(NamespacesBase.path("policies", this.namespaceName.toString()), old -> {
                old.deleted = true;
                return old;
            });
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete namespace on global ZK {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume(new RestException(e));
            return;
        }
        ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
        try {
            if (!topics.isEmpty()) {
                for (String topic : topics) {
                    this.pulsar().getBrokerService().getTopicIfExists(topic).whenComplete((topicOptional, ex) -> topicOptional.ifPresent(systemTopic -> futures.add(systemTopic.deleteForcefully())));
                }
            }
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle bundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(bundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().deleteNamespaceBundleAsync(this.namespaceName.toString(), bundle.getBundleRange()));
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume(new RestException(e));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume(new RestException((PulsarAdminException)exception.getCause()));
                    return null;
                }
                log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, exception});
                asyncResponse.resume(new RestException(exception.getCause()));
                return null;
            }
            try {
                String globalZkPolicyPath = NamespacesBase.path("policies", this.namespaceName.toString());
                String localZkPolicyPath = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
                this.namespaceResources().delete(globalZkPolicyPath);
                try {
                    this.getLocalPolicies().delete(localZkPolicyPath);
                }
                catch (MetadataStoreException.NotFoundException notFoundException) {}
            }
            catch (Exception e) {
                log.error("[{}] Failed to remove owned namespace {} from ZK", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume(new RestException(e));
                return null;
            }
            asyncResponse.resume(Response.noContent().build());
            return null;
        });
    }

    protected void internalDeleteNamespaceForcefully(AsyncResponse asyncResponse, boolean authoritative) {
        List<String> topics;
        this.validateTenantOperation(this.namespaceName.getTenant(), TenantOperation.DELETE_NAMESPACE);
        this.validatePoliciesReadOnlyAccess();
        if (!this.pulsar().getConfiguration().isForceDeleteNamespaceAllowed()) {
            asyncResponse.resume(new RestException(Response.Status.METHOD_NOT_ALLOWED, "Broker doesn't allow forced deletion of namespaces"));
            return;
        }
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Policies policies = null;
        try {
            policies = (Policies)this.namespaceResources().get(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist."));
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = Lists.newArrayList(policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clusterResources().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank(replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri(this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", false).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume(wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        try {
            topics = this.pulsar().getNamespaceService().getFullListOfTopics(this.namespaceName).get(this.config().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        try {
            this.namespaceResources().set(NamespacesBase.path("policies", this.namespaceName.toString()), old -> {
                old.deleted = true;
                return old;
            });
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete namespace on global ZK {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume(new RestException(e));
            return;
        }
        ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
        try {
            if (!topics.isEmpty()) {
                HashSet<String> partitionedTopics = new HashSet<String>();
                HashSet<String> nonPartitionedTopics = new HashSet<String>();
                for (String topic : topics) {
                    try {
                        TopicName topicName = TopicName.get(topic);
                        if (topicName.isPartitioned()) {
                            String partitionedTopic = topicName.getPartitionedTopicName();
                            if (partitionedTopics.contains(partitionedTopic)) continue;
                            futures.add(this.pulsar().getAdminClient().topics().deletePartitionedTopicAsync(partitionedTopic, true, true));
                            partitionedTopics.add(partitionedTopic);
                            continue;
                        }
                        futures.add(this.pulsar().getAdminClient().topics().deleteAsync(topic, true, true));
                        nonPartitionedTopics.add(topic);
                    }
                    catch (Exception e) {
                        String errorMessage = String.format("Failed to force delete topic %s, but the previous deletion command of partitioned-topics:%s and non-partitioned-topics:%s have been sent out asynchronously. Reason: %s", topic, partitionedTopics, nonPartitionedTopics, e.getCause());
                        log.error("[{}] {}", new Object[]{this.clientAppId(), errorMessage, e});
                        asyncResponse.resume(new RestException(Response.Status.INTERNAL_SERVER_ERROR, errorMessage));
                        return;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Successfully send deletion command of partitioned-topics:{} and non-partitioned-topics:{} in namespace:{}.", new Object[]{partitionedTopics, nonPartitionedTopics, this.namespaceName});
                }
            }
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle bundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(bundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().deleteNamespaceBundleAsync(this.namespaceName.toString(), bundle.getBundleRange(), true));
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume(new RestException(e));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume(new RestException((PulsarAdminException)exception.getCause()));
                    return null;
                }
                log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, exception});
                asyncResponse.resume(new RestException(exception.getCause()));
                return null;
            }
            try {
                String globalPartitionedPath = NamespacesBase.path("partitioned-topics", this.namespaceName.toString());
                if (this.namespaceResources().exists(globalPartitionedPath)) {
                    NamespacesBase.deleteRecursive(this.namespaceResources(), globalPartitionedPath);
                }
                String globalZkPolicyPath = NamespacesBase.path("policies", this.namespaceName.toString());
                String localZkPolicyPath = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
                this.namespaceResources().delete(globalZkPolicyPath);
                try {
                    this.getLocalPolicies().delete(localZkPolicyPath);
                }
                catch (MetadataStoreException.NotFoundException notFoundException) {}
            }
            catch (Exception e) {
                log.error("[{}] Failed to remove owned namespace {} from ZK", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume(new RestException(e));
                return null;
            }
            asyncResponse.resume(Response.noContent().build());
            return null;
        });
    }

    protected void internalDeleteNamespaceBundle(String bundleRange, boolean authoritative, boolean force) {
        if (force) {
            this.internalDeleteNamespaceBundleForcefully(bundleRange, authoritative);
        } else {
            this.internalDeleteNamespaceBundle(bundleRange, authoritative);
        }
    }

    protected void internalDeleteNamespaceBundle(String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.DELETE_BUNDLE);
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        try {
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = Lists.newArrayList(policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clusterResources().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank(replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri(this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", false).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        try {
            NamespaceBundle bundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
            List<String> topics = this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).get(this.config().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
            for (String topic : topics) {
                NamespaceBundle topicBundle = this.pulsar().getNamespaceService().getBundle(TopicName.get(topic));
                if (!bundle.equals(topicBundle)) continue;
                throw new RestException(Response.Status.CONFLICT, "Cannot delete non empty bundle");
            }
            this.pulsar().getNamespaceService().removeOwnedServiceUnit(bundle);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteNamespaceBundleForcefully(String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.DELETE_BUNDLE);
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        try {
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = Lists.newArrayList(policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clusterResources().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank(replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri(this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", false).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        try {
            NamespaceBundle bundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
            this.pulsar().getNamespaceService().removeOwnedServiceUnit(bundle);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionOnNamespace(String role, Set<AuthAction> actions) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.GRANT_PERMISSION);
        this.checkNotNull(role, "Role should not be null");
        this.checkNotNull(actions, "Actions should not be null");
        try {
            AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
            if (null == authService) {
                throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
            }
            authService.grantPermissionAsync(this.namespaceName, actions, role, null).get();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", new Object[]{this.clientAppId(), this.namespaceName, e});
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (e.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, e.getCause().getMessage(), e});
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionOnSubscription(String subscription, Set<String> roles) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.GRANT_PERMISSION);
        this.checkNotNull(subscription, "Subscription should not be null");
        this.checkNotNull(roles, "Roles should not be null");
        try {
            AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
            if (null == authService) {
                throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
            }
            authService.grantSubscriptionPermissionAsync(this.namespaceName, subscription, roles, null).get();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (e.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRevokePermissionsOnNamespace(String role) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.REVOKE_PERMISSION);
        this.validatePoliciesReadOnlyAccess();
        this.checkNotNull(role, "Role should not be null");
        this.updatePolicies(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.auth_policies.getNamespaceAuthentication().remove(role);
            return policies;
        });
    }

    protected void internalRevokePermissionsOnSubscription(String subscriptionName, String role) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.REVOKE_PERMISSION);
        this.validatePoliciesReadOnlyAccess();
        this.checkNotNull(subscriptionName, "SubscriptionName should not be null");
        this.checkNotNull(role, "Role should not be null");
        AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
        if (null == authService) {
            throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
        }
        authService.revokeSubscriptionPermissionAsync(this.namespaceName, subscriptionName, role, null);
    }

    protected Set<String> internalGetNamespaceReplicationClusters() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.REPLICATION, PolicyOperation.READ);
        if (!this.namespaceName.isGlobal()) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot get the replication clusters for a non-global namespace");
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.replication_clusters;
    }

    protected void internalSetNamespaceReplicationClusters(List<String> clusterIds) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.REPLICATION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.checkNotNull(clusterIds, "ClusterIds should not be null");
        HashSet<String> replicationClusterSet = Sets.newHashSet(clusterIds);
        if (!this.namespaceName.isGlobal()) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot set replication on a non-global namespace");
        }
        if (replicationClusterSet.contains("global")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify global in the list of replication clusters");
        }
        Set<String> clusters = this.clusters();
        for (String clusterId : replicationClusterSet) {
            if (!clusters.contains(clusterId)) {
                throw new RestException(Response.Status.FORBIDDEN, "Invalid cluster id: " + clusterId);
            }
            this.validatePeerClusterConflict(clusterId, replicationClusterSet);
            this.validateClusterForTenant(this.namespaceName.getTenant(), clusterId);
        }
        this.updatePolicies(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.replication_clusters = replicationClusterSet;
            return policies;
        });
    }

    protected void internalSetNamespaceMessageTTL(Integer messageTTL) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.TTL, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (messageTTL != null && messageTTL < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
        }
        this.updatePolicies(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.message_ttl_in_seconds = messageTTL;
            return policies;
        });
    }

    protected void internalSetSubscriptionExpirationTime(Integer expirationTime) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_EXPIRATION_TIME, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (expirationTime != null && expirationTime < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for subscription expiration time");
        }
        this.updatePolicies(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.subscription_expiration_time_minutes = expirationTime;
            return policies;
        });
    }

    protected void internalSetAutoTopicCreation(AsyncResponse asyncResponse, AutoTopicCreationOverride autoTopicCreationOverride) {
        int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.AUTO_TOPIC_CREATION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (autoTopicCreationOverride != null) {
            if (!AutoTopicCreationOverrideImpl.isValidOverride(autoTopicCreationOverride)) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid configuration for autoTopicCreationOverride");
            }
            if (maxPartitions > 0 && autoTopicCreationOverride.getDefaultNumPartitions() > maxPartitions) {
                throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions);
            }
        }
        ((CompletableFuture)this.namespaceResources().setAsync(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.autoTopicCreationOverride = autoTopicCreationOverride;
            return policies;
        }).thenApply(r -> {
            String autoOverride = autoTopicCreationOverride != null && autoTopicCreationOverride.isAllowAutoTopicCreation() ? "enabled" : "disabled";
            log.info("[{}] Successfully {} autoTopicCreation on namespace {}", new Object[]{this.clientAppId(), autoOverride != null ? autoOverride : "removed", this.namespaceName});
            asyncResponse.resume(Response.noContent().build());
            return null;
        })).exceptionally(e -> {
            log.error("[{}] Failed to modify autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e.getCause()});
            if (e.getCause() instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume(new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
                return null;
            }
            asyncResponse.resume(new RestException(e.getCause()));
            return null;
        });
    }

    protected void internalRemoveAutoTopicCreation(AsyncResponse asyncResponse) {
        this.internalSetAutoTopicCreation(asyncResponse, null);
    }

    protected void internalSetAutoSubscriptionCreation(AsyncResponse asyncResponse, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.AUTO_SUBSCRIPTION_CREATION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        ((CompletableFuture)this.namespaceResources().setAsync(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.autoSubscriptionCreationOverride = autoSubscriptionCreationOverride;
            return policies;
        }).thenApply(r -> {
            if (autoSubscriptionCreationOverride != null) {
                String autoOverride = autoSubscriptionCreationOverride.isAllowAutoSubscriptionCreation() ? "enabled" : "disabled";
                log.info("[{}] Successfully {} autoSubscriptionCreation on namespace {}", new Object[]{this.clientAppId(), autoOverride != null ? autoOverride : "removed", this.namespaceName});
            }
            asyncResponse.resume(Response.noContent().build());
            return null;
        })).exceptionally(e -> {
            log.error("[{}] Failed to modify autoSubscriptionCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e.getCause()});
            if (e.getCause() instanceof MetadataStoreException.NotFoundException) {
                asyncResponse.resume(new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
                return null;
            }
            asyncResponse.resume(new RestException(e.getCause()));
            return null;
        });
    }

    protected void internalRemoveAutoSubscriptionCreation(AsyncResponse asyncResponse) {
        this.internalSetAutoSubscriptionCreation(asyncResponse, null);
    }

    protected void internalModifyDeduplication(Boolean enableDeduplication) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DEDUPLICATION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.updatePolicies(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
            policies.deduplicationEnabled = enableDeduplication;
            return policies;
        });
    }

    protected void internalUnloadNamespace(AsyncResponse asyncResponse) {
        this.validateSuperUserAccess();
        log.info("[{}] Unloading namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
        List<String> boundaries = policies.bundles.getBoundaries();
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            String bundle = String.format("%s_%s", boundaries.get(i), boundaries.get(i + 1));
            try {
                futures.add(this.pulsar().getAdminClient().namespaces().unloadNamespaceBundleAsync(this.namespaceName.toString(), bundle));
                continue;
            }
            catch (PulsarServerException e) {
                log.error("[{}] Failed to unload namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume(new RestException(e));
                return;
            }
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.error("[{}] Failed to unload namespace {}", new Object[]{this.clientAppId(), this.namespaceName, exception});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume(new RestException((PulsarAdminException)exception.getCause()));
                    return null;
                }
                asyncResponse.resume(new RestException(exception.getCause()));
                return null;
            }
            log.info("[{}] Successfully unloaded all the bundles in namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume(Response.noContent().build());
            return null;
        });
    }

    protected void internalSetBookieAffinityGroup(BookieAffinityGroupData bookieAffinityGroup) {
        this.validateSuperUserAccess();
        log.info("[{}] Setting bookie-affinity-group {} for namespace {}", new Object[]{this.clientAppId(), bookieAffinityGroup, this.namespaceName});
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        String path = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
        try {
            this.getLocalPolicies().setWithCreate(path, oldPolicies -> {
                LocalPolicies localPolicies = oldPolicies.map(policies -> new LocalPolicies(policies.bundles, bookieAffinityGroup, policies.namespaceAntiAffinityGroup)).orElseGet(() -> new LocalPolicies(PoliciesUtil.defaultBundle(), bookieAffinityGroup, null));
                log.info("[{}] Successfully updated local-policies configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, localPolicies});
                return localPolicies;
            });
        }
        catch (MetadataStoreException.NotFoundException e) {
            log.warn("[{}] Failed to update local-policy configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update local-policy configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteBookieAffinityGroup() {
        this.internalSetBookieAffinityGroup(null);
    }

    protected BookieAffinityGroupData internalGetBookieAffinityGroup() {
        this.validateSuperUserAccess();
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        String path = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
        try {
            BookieAffinityGroupData bookkeeperAffinityGroup = ((LocalPolicies)this.getLocalPolicies().get((String)path).orElseThrow((Supplier<RestException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$internalGetBookieAffinityGroup$27(), ()Lorg/apache/pulsar/broker/web/RestException;)())).bookieAffinityGroup;
            if (bookkeeperAffinityGroup == null) {
                throw new RestException(Response.Status.NOT_FOUND, "bookie-affinity group does not exist");
            }
            return bookkeeperAffinityGroup;
        }
        catch (MetadataStoreException.NotFoundException e) {
            log.warn("[{}] Failed to update local-policy configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist");
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get local-policy configuration for namespace {} at path {}", new Object[]{this.clientAppId(), this.namespaceName, path, e});
            throw new RestException(e);
        }
    }

    public void internalUnloadNamespaceBundle(AsyncResponse asyncResponse, String bundleRange, boolean authoritative) {
        boolean isOwnedByLocalCluster;
        Policies policies;
        block5: {
            this.validateSuperUserAccess();
            this.checkNotNull(bundleRange, "BundleRange should not be null");
            log.info("[{}] Unloading namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
            policies = this.getNamespacePolicies(this.namespaceName);
            NamespaceBundle bundle = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundle(this.namespaceName.toString(), bundleRange);
            isOwnedByLocalCluster = false;
            try {
                isOwnedByLocalCluster = this.pulsar().getNamespaceService().isNamespaceBundleOwned(bundle).get();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Failed to validate cluster ownership for {}-{}, {}", new Object[]{this.namespaceName.toString(), bundleRange, e.getMessage(), e});
            }
        }
        if (!isOwnedByLocalCluster) {
            if (this.namespaceName.isGlobal()) {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            } else {
                this.validateClusterOwnership(this.namespaceName.getCluster());
                this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
            }
        }
        this.validatePoliciesReadOnlyAccess();
        ((CompletableFuture)this.isBundleOwnedByAnyBroker(this.namespaceName, policies.bundles, bundleRange).thenAccept(flag -> {
            NamespaceBundle nsBundle;
            if (!flag.booleanValue()) {
                log.info("[{}] Namespace bundle is not owned by any broker {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
                asyncResponse.resume(Response.noContent().build());
                return;
            }
            try {
                nsBundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
            }
            catch (WebApplicationException wae) {
                asyncResponse.resume(wae);
                return;
            }
            ((CompletableFuture)this.pulsar().getNamespaceService().unloadNamespaceBundle(nsBundle).thenRun(() -> {
                log.info("[{}] Successfully unloaded namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
                asyncResponse.resume(Response.noContent().build());
            })).exceptionally(ex -> {
                log.error("[{}] Failed to unload namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, ex});
                asyncResponse.resume(new RestException((Throwable)ex));
                return null;
            });
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof WebApplicationException) {
                asyncResponse.resume(ex.getCause());
            } else {
                asyncResponse.resume(new RestException(ex.getCause()));
            }
            return null;
        });
    }

    protected void internalSplitNamespaceBundle(AsyncResponse asyncResponse, String bundleRange, boolean authoritative, boolean unload, String splitAlgorithmName) {
        NamespaceBundle nsBundle;
        this.validateSuperUserAccess();
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        log.info("[{}] Split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validatePoliciesReadOnlyAccess();
        List<String> supportedNamespaceBundleSplitAlgorithms = this.pulsar().getConfig().getSupportedNamespaceBundleSplitAlgorithms();
        if (StringUtils.isNotBlank(splitAlgorithmName) && !supportedNamespaceBundleSplitAlgorithms.contains(splitAlgorithmName)) {
            asyncResponse.resume(new RestException(Response.Status.PRECONDITION_FAILED, "Unsupported namespace bundle split algorithm, supported algorithms are " + supportedNamespaceBundleSplitAlgorithms));
        }
        try {
            nsBundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        }
        catch (Exception e) {
            asyncResponse.resume(e);
            return;
        }
        ((CompletableFuture)this.pulsar().getNamespaceService().splitAndOwnBundle(nsBundle, unload, this.getNamespaceBundleSplitAlgorithmByName(splitAlgorithmName)).thenRun(() -> {
            log.info("[{}] Successfully split namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
            asyncResponse.resume(Response.noContent().build());
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof IllegalArgumentException) {
                log.error("[{}] Failed to split namespace bundle {}/{} due to {}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, ex.getMessage()});
                asyncResponse.resume(new RestException(Response.Status.PRECONDITION_FAILED, "Split bundle failed due to invalid request"));
            } else {
                log.error("[{}] Failed to split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, ex});
                asyncResponse.resume(new RestException(ex.getCause()));
            }
            return null;
        });
    }

    private NamespaceBundleSplitAlgorithm getNamespaceBundleSplitAlgorithmByName(String algorithmName) {
        NamespaceBundleSplitAlgorithm algorithm = NamespaceBundleSplitAlgorithm.of(algorithmName);
        if (algorithm == null) {
            algorithm = NamespaceBundleSplitAlgorithm.of(this.pulsar().getConfig().getDefaultNamespaceBundleSplitAlgorithm());
        }
        if (algorithm == null) {
            algorithm = NamespaceBundleSplitAlgorithm.RANGE_EQUALLY_DIVIDE_ALGO;
        }
        return algorithm;
    }

    protected void internalSetPublishRate(PublishRate maxPublishMessageRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, maxPublishMessageRate});
        String path = NamespacesBase.path("policies", this.namespaceName.toString());
        this.updatePolicies(path, policies -> {
            policies.publishMaxMessageRate.put(this.pulsar().getConfiguration().getClusterName(), maxPublishMessageRate);
            return policies;
        });
        log.info("[{}] Successfully updated the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
    }

    protected void internalRemovePublishRate() {
        this.validateSuperUserAccess();
        log.info("[{}] Remove namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName});
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                if (policies.publishMaxMessageRate != null) {
                    policies.publishMaxMessageRate.remove(this.pulsar().getConfiguration().getClusterName());
                }
                return policies;
            });
            log.info("[{}] Successfully remove the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove the publish_max_message_rate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected PublishRate internalGetPublishRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.publishMaxMessageRate.get(this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetTopicDispatchRate(DispatchRateImpl dispatchRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.topicDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
                policies.clusterDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
                return policies;
            });
            log.info("[{}] Successfully updated the dispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteTopicDispatchRate() {
        this.validateSuperUserAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.topicDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
                policies.clusterDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
                return policies;
            });
            log.info("[{}] Successfully delete the dispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete the dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetTopicDispatchRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.topicDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetSubscriptionDispatchRate(DispatchRateImpl dispatchRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace subscription dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.subscriptionDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
                return policies;
            });
            log.info("[{}] Successfully updated the subscriptionDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteSubscriptionDispatchRate() {
        this.validateSuperUserAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.subscriptionDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
                return policies;
            });
            log.info("[{}] Successfully delete the subscriptionDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete the subscriptionDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetSubscriptionDispatchRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.subscriptionDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetSubscribeRate(SubscribeRate subscribeRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace subscribe-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, subscribeRate});
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.clusterSubscribeRate.put(this.pulsar().getConfiguration().getClusterName(), subscribeRate);
                return policies;
            });
            log.info("[{}] Successfully updated the subscribeRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscribeRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteSubscribeRate() {
        this.validateSuperUserAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.clusterSubscribeRate.remove(this.pulsar().getConfiguration().getClusterName());
                return policies;
            });
            log.info("[{}] Successfully delete the subscribeRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete the subscribeRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected SubscribeRate internalGetSubscribeRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.clusterSubscribeRate.get(this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalRemoveReplicatorDispatchRate() {
        this.validateSuperUserAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.replicatorDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
                return policies;
            });
            log.info("[{}] Successfully delete the replicatorDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete the replicatorDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetReplicatorDispatchRate(DispatchRateImpl dispatchRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace replicator dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.replicatorDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
                return policies;
            });
            log.info("[{}] Successfully updated the replicatorDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the replicatorDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetReplicatorDispatchRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.REPLICATION_RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.replicatorDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        BacklogQuota.BacklogQuotaType quotaType = backlogQuotaType != null ? backlogQuotaType : BacklogQuota.BacklogQuotaType.destination_storage;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            Policies policies = (Policies)this.namespaceResources().get(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist"));
            RetentionPolicies r = policies.retention_policies;
            if (r != null) {
                Policies p2 = new Policies();
                p2.backlog_quota_map.put(quotaType, backlogQuota);
                if (!this.checkQuotas(p2, r)) {
                    log.warn("[{}] Failed to update backlog configuration for namespace {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Backlog Quota exceeds configured retention quota for namespace. Please increase retention quota and retry");
                }
            }
            policies.backlog_quota_map.put(quotaType, backlogQuota);
            this.namespaceResources().set(path, p -> policies);
            log.info("[{}] Successfully updated backlog quota map: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString(backlogQuota)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRemoveBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        BacklogQuota.BacklogQuotaType quotaType = backlogQuotaType != null ? backlogQuotaType : BacklogQuota.BacklogQuotaType.destination_storage;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.backlog_quota_map.remove((Object)quotaType);
                return policies;
            });
            log.info("[{}] Successfully removed backlog namespace={}, quota={}", new Object[]{this.clientAppId(), this.namespaceName, backlogQuotaType});
        }
        catch (Exception e) {
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetRetention(RetentionPolicies retention) {
        this.validateRetentionPolicies(retention);
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RETENTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            Policies policies = (Policies)this.namespaceResources().get(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist"));
            if (!this.checkQuotas(policies, retention)) {
                log.warn("[{}] Failed to update retention configuration for namespace {}: conflicts with backlog quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Retention Quota must exceed configured backlog quota for namespace.");
            }
            policies.retention_policies = retention;
            this.namespaceResources().set(path, p -> policies);
            log.info("[{}] Successfully updated retention configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString(retention)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update retention configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeletePersistence() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.doUpdatePersistence(null);
    }

    protected void internalSetPersistence(PersistencePolicies persistence) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.validatePersistencePolicies(persistence);
        this.doUpdatePersistence(persistence);
    }

    private void doUpdatePersistence(PersistencePolicies persistence) {
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.persistence = persistence;
                return policies;
            });
            log.info("[{}] Successfully updated persistence configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString(persistence)});
        }
        catch (Exception e) {
            log.error("[{}] Failed to update persistence configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected PersistencePolicies internalGetPersistence() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.persistence;
    }

    protected void internalClearNamespaceBacklog(AsyncResponse asyncResponse, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogAsync(this.namespaceName.toString(), nsBundle.getBundleRange()));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume(wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to clear backlog on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume(new RestException((PulsarAdminException)exception.getCause()));
                    return null;
                }
                asyncResponse.resume(new RestException(exception.getCause()));
                return null;
            }
            log.info("[{}] Successfully cleared backlog on all the bundles for namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume(Response.noContent().build());
            return null;
        });
    }

    protected void internalClearNamespaceBundleBacklog(String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, null);
        log.info("[{}] Successfully cleared backlog on namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
    }

    protected void internalClearNamespaceBacklogForSubscription(AsyncResponse asyncResponse, String subscription, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        this.checkNotNull(subscription, "Subscription should not be null");
        ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogForSubscriptionAsync(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume(wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to clear backlog for subscription {} on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), subscription, this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume(new RestException((PulsarAdminException)exception.getCause()));
                    return null;
                }
                asyncResponse.resume(new RestException(exception.getCause()));
                return null;
            }
            log.info("[{}] Successfully cleared backlog for subscription {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
            asyncResponse.resume(Response.noContent().build());
            return null;
        });
    }

    protected void internalClearNamespaceBundleBacklogForSubscription(String subscription, String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        this.checkNotNull(subscription, "Subscription should not be null");
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully cleared backlog for subscription {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalUnsubscribeNamespace(AsyncResponse asyncResponse, String subscription, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.UNSUBSCRIBE);
        this.checkNotNull(subscription, "Subscription should not be null");
        ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().unsubscribeNamespaceBundleAsync(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume(wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume(new RestException(e));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to unsubscribe {} on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), subscription, this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume(new RestException((PulsarAdminException)exception.getCause()));
                    return null;
                }
                asyncResponse.resume(new RestException(exception.getCause()));
                return null;
            }
            log.info("[{}] Successfully unsubscribed {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
            asyncResponse.resume(Response.noContent().build());
            return null;
        });
    }

    protected void internalUnsubscribeNamespaceBundle(String subscription, String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.UNSUBSCRIBE);
        this.checkNotNull(subscription, "Subscription should not be null");
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.unsubscribe(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully unsubscribed {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalSetSubscriptionAuthMode(SubscriptionAuthMode subscriptionAuthMode) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        SubscriptionAuthMode authMode = subscriptionAuthMode == null ? (subscriptionAuthMode = SubscriptionAuthMode.None) : subscriptionAuthMode;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.subscription_auth_mode = authMode;
                return policies;
            });
            log.info("[{}] Successfully updated subscription auth mode: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)authMode)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update subscription auth mode for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalModifyEncryptionRequired(boolean encryptionRequired) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ENCRYPTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            this.updatePolicies(NamespacesBase.path("policies", this.namespaceName.toString()), policies -> {
                policies.encryption_required = encryptionRequired;
                return policies;
            });
            log.info("[{}] Successfully {} on namespace {}", new Object[]{this.clientAppId(), encryptionRequired ? "true" : "false", this.namespaceName});
        }
        catch (Exception e) {
            log.error("[{}] Failed to modify encryption required status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DelayedDeliveryPolicies internalGetDelayedDelivery() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DELAYED_DELIVERY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).delayed_delivery_policies;
    }

    protected InactiveTopicPolicies internalGetInactiveTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.INACTIVE_TOPIC, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.inactive_topic_policies;
    }

    protected void internalSetInactiveTopic(InactiveTopicPolicies inactiveTopicPolicies) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        this.internalSetPolicies("inactive_topic_policies", inactiveTopicPolicies);
    }

    protected void internalSetPolicies(String fieldName, Object value) {
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            Policies policies = (Policies)this.namespaceResources().get(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist"));
            Field field = Policies.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(policies, value);
            this.namespaceResources().set(path, p -> policies);
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), fieldName, this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString(value)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), fieldName, this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetDelayedDelivery(DelayedDeliveryPolicies delayedDeliveryPolicies) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        this.internalSetPolicies("delayed_delivery_policies", delayedDeliveryPolicies);
    }

    protected void internalSetNamespaceAntiAffinityGroup(String antiAffinityGroup) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.WRITE);
        this.checkNotNull(antiAffinityGroup, "AntiAffinityGroup should not be null");
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Setting anti-affinity group {} for {}", new Object[]{this.clientAppId(), antiAffinityGroup, this.namespaceName});
        if (StringUtils.isBlank(antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "antiAffinityGroup can't be empty");
        }
        try {
            String path = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
            this.getLocalPolicies().setWithCreate(path, lp -> lp.map(policies -> new LocalPolicies(policies.bundles, policies.bookieAffinityGroup, antiAffinityGroup)).orElseGet(() -> new LocalPolicies(PoliciesUtil.defaultBundle(), null, antiAffinityGroup)));
            log.info("[{}] Successfully updated local-policies configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, antiAffinityGroup});
        }
        catch (Exception e) {
            log.error("[{}] Failed to update local-policy configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected String internalGetNamespaceAntiAffinityGroup() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.READ);
        try {
            return this.getLocalPolicies().get((String)AdminResource.joinPath((String[])new String[]{"/admin/local-policies", this.namespaceName.toString()})).orElse(new LocalPolicies()).namespaceAntiAffinityGroup;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get the antiAffinityGroup of namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(Response.Status.NOT_FOUND, "Couldn't find namespace policies");
        }
    }

    protected void internalRemoveNamespaceAntiAffinityGroup() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Deleting anti-affinity group for {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        try {
            String path = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
            this.getLocalPolicies().set(path, policies -> new LocalPolicies(policies.bundles, policies.bookieAffinityGroup, null));
            log.info("[{}] Successfully removed anti-affinity group for a namespace={}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove anti-affinity group for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected List<String> internalGetAntiAffinityNamespaces(String cluster, String antiAffinityGroup, String tenant) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.READ);
        this.checkNotNull(cluster, "Cluster should not be null");
        this.checkNotNull(antiAffinityGroup, "AntiAffinityGroup should not be null");
        this.checkNotNull(tenant, "Tenant should not be null");
        log.info("[{}]-{} Finding namespaces for {} in {}", new Object[]{this.clientAppId(), tenant, antiAffinityGroup, cluster});
        if (StringUtils.isBlank(antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "anti-affinity group can't be empty.");
        }
        this.validateClusterExists(cluster);
        try {
            List<String> namespaces = this.getListOfNamespaces(tenant);
            return namespaces.stream().filter(ns -> {
                Optional<LocalPolicies> policies;
                try {
                    policies = this.getLocalPolicies().get(AdminResource.joinPath("/admin/local-policies", ns));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String storedAntiAffinityGroup = policies.orElse(new LocalPolicies()).namespaceAntiAffinityGroup;
                return antiAffinityGroup.equalsIgnoreCase(storedAntiAffinityGroup);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("Failed to list of properties/namespace from global-zk", (Throwable)e);
            throw new RestException(e);
        }
    }

    protected RetentionPolicies internalGetRetention() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RETENTION, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.retention_policies;
    }

    private boolean checkQuotas(Policies policies, RetentionPolicies retention) {
        Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlogQuotaMap = policies.backlog_quota_map;
        if (backlogQuotaMap.isEmpty()) {
            return true;
        }
        BacklogQuota quota = backlogQuotaMap.get((Object)BacklogQuota.BacklogQuotaType.destination_storage);
        return this.checkBacklogQuota(quota, retention);
    }

    private void clearBacklog(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
            if (subscription != null) {
                if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                    subscription = PersistentReplicator.getRemoteCluster(subscription);
                }
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic) || SystemTopicClient.isSystemTopic(TopicName.get(topic.getName()))) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog(subscription));
                }
            } else {
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic) || SystemTopicClient.isSystemTopic(TopicName.get(topic.getName()))) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog());
                }
            }
            FutureUtil.waitForAll(futures).get();
        }
        catch (Exception e) {
            log.error("[{}] Failed to clear backlog for namespace {}/{}, subscription: {}", new Object[]{this.clientAppId(), nsName.toString(), bundleRange, subscription, e});
            throw new RestException(e);
        }
    }

    private void unsubscribe(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList<CompletableFuture<Void>> futures = Lists.newArrayList();
            if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot unsubscribe a replication cursor");
            }
            for (Topic topic : topicList) {
                Subscription sub = topic.getSubscription(subscription);
                if (sub == null) continue;
                futures.add(sub.delete());
            }
            FutureUtil.waitForAll(futures).get();
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to unsubscribe {} for namespace {}/{}", new Object[]{this.clientAppId(), subscription, nsName.toString(), bundleRange, e});
            if (e.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers");
            }
            throw new RestException(e.getCause());
        }
    }

    private void validatePeerClusterConflict(String clusterName, Set<String> replicationClusters) {
        try {
            Sets.SetView<String> conflictPeerClusters;
            ClusterData clusterData = (ClusterData)this.clusterResources().get(NamespacesBase.path("clusters", clusterName)).orElseThrow(() -> new RestException(Response.Status.PRECONDITION_FAILED, "Invalid replication cluster " + clusterName));
            LinkedHashSet<String> peerClusters = clusterData.getPeerClusterNames();
            if (peerClusters != null && !peerClusters.isEmpty() && !(conflictPeerClusters = Sets.intersection(peerClusters, replicationClusters)).isEmpty()) {
                log.warn("[{}] {}'s peer cluster can't be part of replication clusters {}", new Object[]{this.clientAppId(), clusterName, conflictPeerClusters});
                throw new RestException(Response.Status.CONFLICT, String.format("%s's peer-clusters %s can't be part of replication-clusters %s", clusterName, conflictPeerClusters, replicationClusters));
            }
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.warn("[{}] Failed to get cluster-data for {}", new Object[]{this.clientAppId(), clusterName, e});
        }
    }

    protected BundlesData validateBundlesData(BundlesData initialBundles) {
        TreeSet<String> partitions = new TreeSet<String>();
        for (String partition : initialBundles.getBoundaries()) {
            Long partBoundary = Long.decode(partition);
            partitions.add(String.format("0x%08x", partBoundary));
        }
        if (partitions.size() != initialBundles.getBoundaries().size() && log.isDebugEnabled()) {
            log.debug("Input bundles included repeated partition points. Ignored.");
        }
        try {
            NamespaceBundleFactory.validateFullRange(partitions);
        }
        catch (IllegalArgumentException iae) {
            throw new RestException(Response.Status.BAD_REQUEST, "Input bundles do not cover the whole hash range. first:" + (String)partitions.first() + ", last:" + (String)partitions.last());
        }
        ArrayList<String> bundles = Lists.newArrayList();
        bundles.addAll(partitions);
        return BundlesData.builder().boundaries(bundles).numBundles(bundles.size() - 1).build();
    }

    private void validatePolicies(NamespaceName ns, Policies policies) {
        if (ns.isV2() && policies.replication_clusters.isEmpty()) {
            policies.replication_clusters = Collections.singleton(this.config().getClusterName());
        }
        policies.replication_clusters.forEach(cluster -> this.validateClusterForTenant(ns.getTenant(), (String)cluster));
        if (policies.message_ttl_in_seconds != null && policies.message_ttl_in_seconds < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
        }
        if (policies.bundles != null && policies.bundles.getNumBundles() > 0) {
            policies.bundles = policies.bundles.getBoundaries() == null || policies.bundles.getBoundaries().size() == 0 ? PoliciesUtil.getBundles(policies.bundles.getNumBundles()) : this.validateBundlesData(policies.bundles);
        } else {
            int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
            policies.bundles = PoliciesUtil.getBundles(defaultNumberOfBundles);
        }
        if (policies.persistence != null) {
            this.validatePersistencePolicies(policies.persistence);
        }
        if (policies.retention_policies != null) {
            this.validateRetentionPolicies(policies.retention_policies);
        }
    }

    protected void validateRetentionPolicies(RetentionPolicies retention) {
        if (retention == null) {
            return;
        }
        this.checkArgument(retention.getRetentionSizeInMB() >= -1L, "Invalid retention policy: size limit must be >= -1");
        this.checkArgument(retention.getRetentionTimeInMinutes() >= -1, "Invalid retention policy: time limit must be >= -1");
        this.checkArgument(retention.getRetentionTimeInMinutes() != 0 && retention.getRetentionSizeInMB() != 0L || retention.getRetentionTimeInMinutes() == 0 && retention.getRetentionSizeInMB() == 0L, "Invalid retention policy: Setting a single time or size limit to 0 is invalid when one of the limits has a non-zero value. Use the value of -1 instead of 0 to ignore a specific limit. To disable retention both limits must be set to 0.");
    }

    protected Integer internalGetMaxProducersPerTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_PRODUCERS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_producers_per_topic;
    }

    protected Integer internalGetDeduplicationSnapshotInterval() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DEDUPLICATION_SNAPSHOT, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).deduplicationSnapshotIntervalSeconds;
    }

    protected void internalSetDeduplicationSnapshotInterval(Integer interval) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DEDUPLICATION_SNAPSHOT, PolicyOperation.WRITE);
        if (interval != null && interval < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "interval must be greater than or equal to 0");
        }
        this.internalSetPolicies("deduplicationSnapshotIntervalSeconds", interval);
    }

    protected void internalSetMaxProducersPerTopic(Integer maxProducersPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_PRODUCERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (maxProducersPerTopic != null && maxProducersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxProducersPerTopic must be 0 or more");
            }
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.max_producers_per_topic = maxProducersPerTopic;
                return policies;
            });
            log.info("[{}] Successfully updated maxProducersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxProducersPerTopic});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxProducersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Boolean internalGetDeduplication() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DEDUPLICATION, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).deduplicationEnabled;
    }

    protected Integer internalGetMaxConsumersPerTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_topic;
    }

    protected void internalSetMaxConsumersPerTopic(Integer maxConsumersPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (maxConsumersPerTopic != null && maxConsumersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerTopic must be 0 or more");
            }
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.max_consumers_per_topic = maxConsumersPerTopic;
                return policies;
            });
            log.info("[{}] Successfully updated maxConsumersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxConsumersPerTopic});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Integer internalGetMaxConsumersPerSubscription() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_subscription;
    }

    protected void internalSetMaxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (maxConsumersPerSubscription != null && maxConsumersPerSubscription < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerSubscription must be 0 or more");
            }
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.max_consumers_per_subscription = maxConsumersPerSubscription;
                return policies;
            });
            log.info("[{}] Successfully updated maxConsumersPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxConsumersPerSubscription});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Integer internalGetMaxUnackedMessagesPerConsumer() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_unacked_messages_per_consumer;
    }

    protected void internalSetMaxUnackedMessagesPerConsumer(Integer maxUnackedMessagesPerConsumer) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxUnackedMessagesPerConsumer != null && maxUnackedMessagesPerConsumer < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedMessagesPerConsumer must be 0 or more");
        }
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.max_unacked_messages_per_consumer = maxUnackedMessagesPerConsumer;
                return policies;
            });
            log.info("[{}] Successfully updated maxUnackedMessagesPerConsumer configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxUnackedMessagesPerConsumer});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxUnackedMessagesPerConsumer configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Integer internalGetMaxUnackedMessagesPerSubscription() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_unacked_messages_per_subscription;
    }

    protected Integer internalGetMaxSubscriptionsPerTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_SUBSCRIPTIONS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_subscriptions_per_topic;
    }

    protected void internalSetMaxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        if (maxSubscriptionsPerTopic != null && maxSubscriptionsPerTopic < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxSubscriptionsPerTopic must be 0 or more");
        }
        this.internalSetPolicies("max_subscriptions_per_topic", maxSubscriptionsPerTopic);
    }

    protected void internalSetMaxUnackedMessagesPerSubscription(Integer maxUnackedMessagesPerSubscription) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxUnackedMessagesPerSubscription != null && maxUnackedMessagesPerSubscription < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedMessagesPerSubscription must be 0 or more");
        }
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.max_unacked_messages_per_subscription = maxUnackedMessagesPerSubscription;
                return policies;
            });
            log.info("[{}] Successfully updated maxUnackedMessagesPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxUnackedMessagesPerSubscription});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxUnackedMessagesPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Long internalGetCompactionThreshold() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.COMPACTION, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).compaction_threshold;
    }

    protected void internalSetCompactionThreshold(Long newThreshold) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.COMPACTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (newThreshold != null && newThreshold < 0L) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "compactionThreshold must be 0 or more");
            }
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                policies.compaction_threshold = newThreshold;
                return policies;
            });
            log.info("[{}] Successfully updated compactionThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newThreshold});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update compactionThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected long internalGetOffloadThreshold() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.offload_policies == null) {
            return policies.offload_threshold;
        }
        return policies.offload_policies.getManagedLedgerOffloadThresholdInBytes();
    }

    protected void internalSetOffloadThreshold(long newThreshold) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                if (policies.offload_policies == null) {
                    policies.offload_policies = new OffloadPoliciesImpl();
                }
                ((OffloadPoliciesImpl)policies.offload_policies).setManagedLedgerOffloadThresholdInBytes(newThreshold);
                policies.offload_threshold = newThreshold;
                return policies;
            });
            log.info("[{}] Successfully updated offloadThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newThreshold});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Long internalGetOffloadDeletionLag() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.offload_policies == null) {
            return policies.offload_deletion_lag_ms;
        }
        return policies.offload_policies.getManagedLedgerOffloadDeletionLagInMillis();
    }

    protected void internalSetOffloadDeletionLag(Long newDeletionLagMs) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            this.updatePolicies(path, policies -> {
                if (policies.offload_policies == null) {
                    policies.offload_policies = new OffloadPoliciesImpl();
                }
                ((OffloadPoliciesImpl)policies.offload_policies).setManagedLedgerOffloadDeletionLagInMillis(newDeletionLagMs);
                policies.offload_deletion_lag_ms = newDeletionLagMs;
                return policies;
            });
            log.info("[{}] Successfully updated offloadDeletionLagMs configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newDeletionLagMs});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadDeletionLag configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    @Deprecated
    protected SchemaAutoUpdateCompatibilityStrategy internalGetSchemaAutoUpdateCompatibilityStrategy() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_auto_update_compatibility_strategy;
    }

    protected SchemaCompatibilityStrategy internalGetSchemaCompatibilityStrategy() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.schema_compatibility_strategy;
    }

    @Deprecated
    protected void internalSetSchemaAutoUpdateCompatibilityStrategy(SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_auto_update_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_auto_update_compatibility_strategy, "schemaAutoUpdateCompatibilityStrategy");
    }

    protected void internalSetSchemaCompatibilityStrategy(SchemaCompatibilityStrategy strategy) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_compatibility_strategy, "schemaCompatibilityStrategy");
    }

    protected boolean internalGetSchemaValidationEnforced(boolean applied) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        boolean schemaValidationEnforced = this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_validation_enforced;
        if (!schemaValidationEnforced && applied) {
            return this.pulsar().getConfiguration().isSchemaValidationEnforced();
        }
        return schemaValidationEnforced;
    }

    protected void internalSetSchemaValidationEnforced(boolean schemaValidationEnforced) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_validation_enforced = schemaValidationEnforced;
            return policies;
        }, policies -> policies.schema_validation_enforced, "schemaValidationEnforced");
    }

    protected boolean internalGetIsAllowAutoUpdateSchema() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        if (this.getNamespacePolicies((NamespaceName)this.namespaceName).is_allow_auto_update_schema == null) {
            return this.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
        }
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).is_allow_auto_update_schema;
    }

    protected void internalSetIsAllowAutoUpdateSchema(boolean isAllowAutoUpdateSchema) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.is_allow_auto_update_schema = isAllowAutoUpdateSchema;
            return policies;
        }, policies -> policies.is_allow_auto_update_schema, "isAllowAutoUpdateSchema");
    }

    protected Set<SubscriptionType> internalGetSubscriptionTypesEnabled() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.READ);
        HashSet<SubscriptionType> subscriptionTypes = new HashSet<SubscriptionType>();
        this.getNamespacePolicies((NamespaceName)this.namespaceName).subscription_types_enabled.forEach(subType -> subscriptionTypes.add(SubscriptionType.valueOf(subType)));
        return subscriptionTypes;
    }

    protected void internalSetSubscriptionTypesEnabled(Set<SubscriptionType> subscriptionTypesEnabled) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        HashSet subTypes = new HashSet();
        subscriptionTypesEnabled.forEach(subscriptionType -> subTypes.add(subscriptionType.name()));
        this.mutatePolicy(policies -> {
            policies.subscription_types_enabled = subTypes;
            return policies;
        }, policies -> policies.subscription_types_enabled, "subscriptionTypesEnabled");
    }

    private <T> void mutatePolicy(Function<Policies, Policies> policyTransformation, Function<Policies, T> getter, String policyName) {
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            MutableObject exception = new MutableObject(null);
            MutableObject policiesObj = new MutableObject(null);
            this.updatePolicies(path, policies -> {
                try {
                    policies = (Policies)policyTransformation.apply((Policies)policies);
                }
                catch (Exception e) {
                    exception.setValue(e);
                }
                policiesObj.setValue(policies);
                return policies;
            });
            if (exception.getValue() != null) {
                throw (Exception)exception.getValue();
            }
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), policyName, this.namespaceName, getter.apply((Policies)policiesObj.getValue())});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), policyName, this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetOffloadPolicies(AsyncResponse asyncResponse, OffloadPoliciesImpl offloadPolicies) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.validateOffloadPolicies(offloadPolicies);
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            ((CompletableFuture)this.namespaceResources().setAsync(path, policies -> {
                if (Objects.equals(offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis(), OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS)) {
                    offloadPolicies.setManagedLedgerOffloadDeletionLagInMillis(policies.offload_deletion_lag_ms);
                } else {
                    policies.offload_deletion_lag_ms = offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis();
                }
                if (Objects.equals(offloadPolicies.getManagedLedgerOffloadThresholdInBytes(), OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES)) {
                    offloadPolicies.setManagedLedgerOffloadThresholdInBytes(policies.offload_threshold);
                } else {
                    policies.offload_threshold = offloadPolicies.getManagedLedgerOffloadThresholdInBytes();
                }
                policies.offload_policies = offloadPolicies;
                return policies;
            }).thenApply(r -> {
                log.info("[{}] Successfully updated offload configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, offloadPolicies});
                asyncResponse.resume(Response.noContent().build());
                return null;
            })).exceptionally(e -> {
                log.error("[{}] Failed to update offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume(new RestException((Throwable)e));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("[{}] Failed to update offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e2});
            asyncResponse.resume(e2.getCause() instanceof MetadataStoreException.NotFoundException ? new RestException(Response.Status.CONFLICT, "Concurrent modification") : new RestException(e2));
        }
    }

    protected void internalRemoveOffloadPolicies(AsyncResponse asyncResponse) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            ((CompletableFuture)this.namespaceResources().setAsync(path, policies -> {
                policies.offload_policies = null;
                return policies;
            }).thenApply(r -> {
                log.info("[{}] Successfully remove offload configuration: namespace={}", (Object)this.clientAppId(), (Object)this.namespaceName);
                asyncResponse.resume(Response.noContent().build());
                return null;
            })).exceptionally(e -> {
                log.error("[{}] Failed to remove offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume(e.getCause() instanceof MetadataStoreException.NotFoundException ? new RestException(Response.Status.CONFLICT, "Concurrent modification") : new RestException((Throwable)e));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("[{}] Failed to remove offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e2});
            asyncResponse.resume(new RestException(e2));
        }
    }

    private void validateOffloadPolicies(OffloadPoliciesImpl offloadPolicies) {
        if (offloadPolicies == null) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: offloadPolicies is null", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The offloadPolicies must be specified for namespace offload.");
        }
        if (!offloadPolicies.driverSupported()) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: driver is not supported, support value: {}", new Object[]{this.clientAppId(), this.namespaceName, OffloadPoliciesImpl.getSupportedDriverNames()});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The driver is not supported, support value: " + OffloadPoliciesImpl.getSupportedDriverNames());
        }
        if (!offloadPolicies.bucketValid()) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: bucket must be specified", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The bucket must be specified for namespace offload.");
        }
    }

    protected OffloadPoliciesImpl internalGetOffloadPolicies() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return (OffloadPoliciesImpl)policies.offload_policies;
    }

    protected int internalGetMaxTopicsPerNamespace() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_TOPICS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_topics_per_namespace;
    }

    protected void internalRemoveMaxTopicsPerNamespace() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_TOPICS, PolicyOperation.WRITE);
        this.internalSetMaxTopicsPerNamespace(null);
    }

    protected void internalSetMaxTopicsPerNamespace(Integer maxTopicsPerNamespace) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_TOPICS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxTopicsPerNamespace != null && maxTopicsPerNamespace < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxTopicsPerNamespace must be 0 or more");
        }
        this.internalSetPolicies("max_topics_per_namespace", maxTopicsPerNamespace);
    }

    protected void internalSetProperty(String key, String value, AsyncResponse asyncResponse) {
        this.validatePoliciesReadOnlyAccess();
        String path = NamespacesBase.path("policies", this.namespaceName.toString());
        ((CompletableFuture)this.updatePoliciesAsync(path, policies -> {
            policies.properties.put(key, value);
            return policies;
        }).thenAccept(v -> {
            log.info("[{}] Successfully set property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName});
            asyncResponse.resume(Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to set property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalSetProperties(Map<String, String> properties, AsyncResponse asyncResponse) {
        this.validatePoliciesReadOnlyAccess();
        String path = NamespacesBase.path("policies", this.namespaceName.toString());
        ((CompletableFuture)this.updatePoliciesAsync(path, policies -> {
            policies.properties.putAll(properties);
            return policies;
        }).thenAccept(v -> {
            log.info("[{}] Successfully set {} properties on namespace {}", new Object[]{this.clientAppId(), properties.size(), this.namespaceName});
            asyncResponse.resume(Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to set {} properties on namespace {}", new Object[]{this.clientAppId(), properties.size(), this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalGetProperty(String key, AsyncResponse asyncResponse) {
        ((CompletableFuture)this.getNamespacePoliciesAsync(this.namespaceName).thenAccept(policies -> asyncResponse.resume(policies.properties.get(key)))).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to get property for key {} of namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalGetProperties(AsyncResponse asyncResponse) {
        ((CompletableFuture)this.getNamespacePoliciesAsync(this.namespaceName).thenAccept(policies -> asyncResponse.resume(policies.properties))).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to get properties of namespace {}", new Object[]{this.clientAppId(), this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalRemoveProperty(String key, AsyncResponse asyncResponse) {
        this.validatePoliciesReadOnlyAccess();
        String path = NamespacesBase.path("policies", this.namespaceName.toString());
        AtomicReference<Object> oldVal = new AtomicReference<Object>(null);
        ((CompletableFuture)this.updatePoliciesAsync(path, policies -> {
            oldVal.set(policies.properties.remove(key));
            return policies;
        }).thenAccept(v -> {
            asyncResponse.resume(oldVal.get());
            log.info("[{}] Successfully remove property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName});
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to remove property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalClearProperties(AsyncResponse asyncResponse) {
        this.validatePoliciesReadOnlyAccess();
        String path = NamespacesBase.path("policies", this.namespaceName.toString());
        AtomicReference<Integer> clearedCount = new AtomicReference<Integer>(0);
        ((CompletableFuture)this.updatePoliciesAsync(path, policies -> {
            clearedCount.set(policies.properties.size());
            policies.properties.clear();
            return policies;
        }).thenAccept(v -> {
            asyncResponse.resume(Response.noContent().build());
            log.info("[{}] Successfully clear {} properties for on namespace {}", new Object[]{this.clientAppId(), clearedCount.get(), this.namespaceName});
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to remove property for key {} on namespace {}", new Object[]{this.clientAppId(), clearedCount.get(), this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    private CompletableFuture<Void> updatePoliciesAsync(String path, Function<Policies, Policies> updateFunction) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.namespaceResources().setAsync(path, updateFunction).thenAccept(v -> {
            log.info("[{}] Successfully updated the {} on namespace {}", new Object[]{this.clientAppId(), path, this.namespaceName});
            result.complete(null);
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            if (cause instanceof MetadataStoreException.NotFoundException) {
                result.completeExceptionally(new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            } else if (cause instanceof MetadataStoreException.BadVersionException) {
                log.warn("[{}] Failed to update the replication clusters on namespace {} : concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                result.completeExceptionally(new RestException(Response.Status.CONFLICT, "Concurrent modification"));
            } else {
                log.error("[{}] Failed to update namespace policies {}", new Object[]{this.clientAppId(), this.namespaceName, cause});
                result.completeExceptionally(new RestException(cause));
            }
            return null;
        });
        return result;
    }

    private void updatePolicies(String path, Function<Policies, Policies> updateFunction) {
        try {
            this.updatePoliciesAsync(path, updateFunction).get(this.namespaceResources().getOperationTimeoutSec(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof RestException)) {
                throw new RestException(cause);
            }
            throw (RestException)cause;
        }
    }

    protected void internalSetNamespaceResourceGroup(String rgName) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RESOURCEGROUP, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (rgName != null) {
            String resourceGroupPath = AdminResource.path("resourcegroups", rgName);
            try {
                if (!this.resourceGroupResources().exists(resourceGroupPath)) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "ResourceGroup does not exist");
                }
            }
            catch (Exception e) {
                log.error("[{}] Invalid ResourceGroup {}: {}", new Object[]{this.clientAppId(), rgName, e});
                throw new RestException(e);
            }
        }
        this.internalSetPolicies("resource_group_name", rgName);
    }

    private static /* synthetic */ RestException lambda$internalGetBookieAffinityGroup$27() {
        return new RestException(Response.Status.NOT_FOUND, "Namespace local-policies does not exist");
    }
}

