/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.BrokerData;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.TimeAverageMessageData;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.LoadSheddingStrategy;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.shade.com.google.common.collect.ArrayListMultimap;
import org.apache.pulsar.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.shade.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.pulsar.shade.org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdShedder
implements LoadSheddingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ThresholdShedder.class);
    private final Multimap<String, String> selectedBundlesCache = ArrayListMultimap.create();
    private static final double ADDITIONAL_THRESHOLD_PERCENT_MARGIN = 0.05;
    private static final double MB = 1048576.0;
    private final Map<String, Double> brokerAvgResourceUsage = new HashMap<String, Double>();

    @Override
    public Multimap<String, String> findBundlesForUnloading(LoadData loadData, ServiceConfiguration conf) {
        this.selectedBundlesCache.clear();
        double threshold = (double)conf.getLoadBalancerBrokerThresholdShedderPercentage() / 100.0;
        Map<String, Long> recentlyUnloadedBundles = loadData.getRecentlyUnloadedBundles();
        double minThroughputThreshold = conf.getLoadBalancerBundleUnloadMinThroughputThreshold() * 1048576.0;
        double avgUsage = this.getBrokerAvgUsage(loadData, conf.getLoadBalancerHistoryResourcePercentage(), conf);
        if (avgUsage == 0.0) {
            log.warn("average max resource usage is 0");
            return this.selectedBundlesCache;
        }
        loadData.getBrokerData().forEach((broker, brokerData) -> {
            LocalBrokerData localData = brokerData.getLocalData();
            double currentUsage = this.brokerAvgResourceUsage.getOrDefault(broker, 0.0);
            if (currentUsage < avgUsage + threshold) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] broker is not overloaded, ignoring at this point", broker);
                }
                return;
            }
            double percentOfTrafficToOffload = currentUsage - avgUsage - threshold + 0.05;
            double brokerCurrentThroughput = localData.getMsgThroughputIn() + localData.getMsgThroughputOut();
            double minimumThroughputToOffload = brokerCurrentThroughput * percentOfTrafficToOffload;
            if (minimumThroughputToOffload < minThroughputThreshold) {
                if (log.isDebugEnabled()) {
                    log.info("[{}] broker is planning to shed throughput {} MByte/s less than minimumThroughputThreshold {} MByte/s, skipping bundle unload.", new Object[]{broker, minimumThroughputToOffload / 1048576.0, minThroughputThreshold / 1048576.0});
                }
                return;
            }
            log.info("Attempting to shed load on {}, which has max resource usage above avgUsage  and threshold {}% > {}% + {}% -- Offloading at least {} MByte/s of traffic, left throughput {} MByte/s", new Object[]{broker, currentUsage, avgUsage, threshold, minimumThroughputToOffload / 1048576.0, (brokerCurrentThroughput - minimumThroughputToOffload) / 1048576.0});
            MutableDouble trafficMarkedToOffload = new MutableDouble(0.0);
            MutableBoolean atLeastOneBundleSelected = new MutableBoolean(false);
            if (localData.getBundles().size() > 1) {
                loadData.getBundleData().entrySet().stream().filter(e -> !NamespaceService.HEARTBEAT_NAMESPACE_PATTERN.matcher((CharSequence)e.getKey()).matches()).map(e -> {
                    String bundle = (String)e.getKey();
                    BundleData bundleData = (BundleData)e.getValue();
                    TimeAverageMessageData shortTermData = bundleData.getShortTermData();
                    double throughput = shortTermData.getMsgThroughputIn() + shortTermData.getMsgThroughputOut();
                    return Pair.of(bundle, throughput);
                }).filter(e -> !recentlyUnloadedBundles.containsKey(e.getLeft())).filter(e -> localData.getBundles().contains(e.getLeft())).sorted((e1, e2) -> Double.compare((Double)e2.getRight(), (Double)e1.getRight())).forEach(e -> {
                    if (trafficMarkedToOffload.doubleValue() < minimumThroughputToOffload || atLeastOneBundleSelected.isFalse()) {
                        this.selectedBundlesCache.put((String)broker, (String)e.getLeft());
                        trafficMarkedToOffload.add((Number)e.getRight());
                        atLeastOneBundleSelected.setTrue();
                    }
                });
            } else if (localData.getBundles().size() == 1) {
                log.warn("HIGH USAGE WARNING : Sole namespace bundle {} is overloading broker {}. No Load Shadding will be done on this broker", (Object)localData.getBundles().iterator().next(), broker);
            } else {
                log.warn("Broker {} is overloaded despit having no bundles", broker);
            }
        });
        return this.selectedBundlesCache;
    }

    private double getBrokerAvgUsage(LoadData loadData, double historyPercentage, ServiceConfiguration conf) {
        double totalUsage = 0.0;
        int totalBrokers = 0;
        for (Map.Entry<String, BrokerData> entry : loadData.getBrokerData().entrySet()) {
            LocalBrokerData localBrokerData = entry.getValue().getLocalData();
            String broker = entry.getKey();
            totalUsage += this.updateAvgResourceUsage(broker, localBrokerData, historyPercentage, conf);
            ++totalBrokers;
        }
        return totalBrokers > 0 ? totalUsage / (double)totalBrokers : 0.0;
    }

    private double updateAvgResourceUsage(String broker, LocalBrokerData localBrokerData, double historyPercentage, ServiceConfiguration conf) {
        Double historyUsage = this.brokerAvgResourceUsage.get(broker);
        double resourceUsage = localBrokerData.getMaxResourceUsageWithWeight(conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight());
        historyUsage = historyUsage == null ? resourceUsage : historyUsage * historyPercentage + (1.0 - historyPercentage) * resourceUsage;
        this.brokerAvgResourceUsage.put(broker, historyUsage);
        return historyUsage;
    }
}

