/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.Optional;
import org.apache.pulsar.broker.resources.ClusterResources;
import org.apache.pulsar.broker.resources.DynamicConfigurationResources;
import org.apache.pulsar.broker.resources.LoadManagerReportResources;
import org.apache.pulsar.broker.resources.LocalPoliciesResources;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.ResourceGroupResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class PulsarResources {
    public static final int DEFAULT_OPERATION_TIMEOUT_SEC = 30;
    private TenantResources tenantResources;
    private ClusterResources clusterResources;
    private ResourceGroupResources resourcegroupResources;
    private NamespaceResources namespaceResources;
    private DynamicConfigurationResources dynamicConfigResources;
    private LocalPoliciesResources localPolicies;
    private LoadManagerReportResources loadReportResources;
    private Optional<MetadataStoreExtended> localMetadataStore;
    private Optional<MetadataStoreExtended> configurationMetadataStore;

    public PulsarResources(MetadataStoreExtended localMetadataStore, MetadataStoreExtended configurationMetadataStore) {
        this(localMetadataStore, configurationMetadataStore, 30);
    }

    public PulsarResources(MetadataStoreExtended localMetadataStore, MetadataStoreExtended configurationMetadataStore, int operationTimeoutSec) {
        if (configurationMetadataStore != null) {
            this.tenantResources = new TenantResources(configurationMetadataStore, operationTimeoutSec);
            this.clusterResources = new ClusterResources(configurationMetadataStore, operationTimeoutSec);
            this.namespaceResources = new NamespaceResources(configurationMetadataStore, operationTimeoutSec);
            this.resourcegroupResources = new ResourceGroupResources(configurationMetadataStore, operationTimeoutSec);
        }
        if (localMetadataStore != null) {
            this.dynamicConfigResources = new DynamicConfigurationResources(localMetadataStore, operationTimeoutSec);
            this.localPolicies = new LocalPoliciesResources(localMetadataStore, operationTimeoutSec);
            this.loadReportResources = new LoadManagerReportResources(localMetadataStore, operationTimeoutSec);
        }
        this.localMetadataStore = Optional.ofNullable(localMetadataStore);
        this.configurationMetadataStore = Optional.ofNullable(configurationMetadataStore);
    }

    public static MetadataStoreExtended createMetadataStore(String serverUrls, int sessionTimeoutMs) throws MetadataStoreException {
        return MetadataStoreExtended.create(serverUrls, MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeoutMs).allowReadOnlyOperations(false).build());
    }

    public TenantResources getTenantResources() {
        return this.tenantResources;
    }

    public ClusterResources getClusterResources() {
        return this.clusterResources;
    }

    public ResourceGroupResources getResourcegroupResources() {
        return this.resourcegroupResources;
    }

    public NamespaceResources getNamespaceResources() {
        return this.namespaceResources;
    }

    public DynamicConfigurationResources getDynamicConfigResources() {
        return this.dynamicConfigResources;
    }

    public LocalPoliciesResources getLocalPolicies() {
        return this.localPolicies;
    }

    public LoadManagerReportResources getLoadReportResources() {
        return this.loadReportResources;
    }

    public Optional<MetadataStoreExtended> getLocalMetadataStore() {
        return this.localMetadataStore;
    }

    public Optional<MetadataStoreExtended> getConfigurationMetadataStore() {
        return this.configurationMetadataStore;
    }
}

