/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionBufferClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionBufferHandler;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandEndTxnOnPartitionResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandEndTxnOnSubscriptionResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferHandlerImpl
implements TransactionBufferHandler,
TimerTask {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferHandlerImpl.class);
    private final ConcurrentSkipListMap<Long, OpRequestSend> pendingRequests;
    private final AtomicLong requestIdGenerator = new AtomicLong();
    private final long operationTimeoutInMills;
    private Timeout requestTimeout;
    private final HashedWheelTimer timer;
    private final Semaphore semaphore;
    private final boolean blockIfReachMaxPendingOps;
    private final PulsarClient pulsarClient;
    private final LoadingCache<String, CompletableFuture<ClientCnx>> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<String, CompletableFuture<ClientCnx>>(){

        @Override
        public CompletableFuture<ClientCnx> load(String topic) {
            CompletableFuture siFuture = TransactionBufferHandlerImpl.this.getClientCnx(topic);
            siFuture.whenComplete((si, cause) -> {
                if (null != cause) {
                    TransactionBufferHandlerImpl.this.cache.invalidate(topic);
                }
            });
            return siFuture;
        }
    });

    public TransactionBufferHandlerImpl(PulsarClient pulsarClient, HashedWheelTimer timer) {
        this.pulsarClient = pulsarClient;
        this.pendingRequests = new ConcurrentSkipListMap();
        this.operationTimeoutInMills = 3000L;
        this.semaphore = new Semaphore(10000);
        this.blockIfReachMaxPendingOps = true;
        this.timer = timer;
        this.requestTimeout = timer.newTimeout(this, this.operationTimeoutInMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized CompletableFuture<TxnID> endTxnOnTopic(String topic, long txnIdMostBits, long txnIdLeastBits, TxnAction action, long lowWaterMark) {
        CompletableFuture<TxnID> cb;
        if (log.isDebugEnabled()) {
            log.debug("[{}] endTxnOnTopic txnId: [{}], txnAction: [{}]", new Object[]{topic, new TxnID(txnIdMostBits, txnIdLeastBits), action.getValue()});
        }
        if (!this.canSendRequest(cb = new CompletableFuture<TxnID>())) {
            return cb;
        }
        long requestId = this.requestIdGenerator.getAndIncrement();
        ByteBuf cmd = Commands.newEndTxnOnPartition(requestId, txnIdLeastBits, txnIdMostBits, topic, action, lowWaterMark);
        return this.endTxn(requestId, topic, cmd, cb);
    }

    @Override
    public synchronized CompletableFuture<TxnID> endTxnOnSubscription(String topic, String subscription, long txnIdMostBits, long txnIdLeastBits, TxnAction action, long lowWaterMark) {
        CompletableFuture<TxnID> cb;
        if (log.isDebugEnabled()) {
            log.debug("[{}] endTxnOnSubscription txnId: [{}], txnAction: [{}]", new Object[]{topic, new TxnID(txnIdMostBits, txnIdLeastBits), action.getValue()});
        }
        if (!this.canSendRequest(cb = new CompletableFuture<TxnID>())) {
            return cb;
        }
        long requestId = this.requestIdGenerator.getAndIncrement();
        ByteBuf cmd = Commands.newEndTxnOnSubscription(requestId, txnIdLeastBits, txnIdMostBits, topic, subscription, action, lowWaterMark);
        return this.endTxn(requestId, topic, cmd, cb);
    }

    private CompletableFuture<TxnID> endTxn(long requestId, String topic, ByteBuf cmd, CompletableFuture<TxnID> cb) {
        OpRequestSend op = OpRequestSend.create(requestId, topic, cmd, cb);
        try {
            this.cache.get(topic).whenComplete((clientCnx, throwable) -> {
                if (throwable == null) {
                    if (clientCnx.ctx().channel().isActive()) {
                        clientCnx.registerTransactionBufferHandler(this);
                        TransactionBufferHandlerImpl transactionBufferHandlerImpl = this;
                        synchronized (transactionBufferHandlerImpl) {
                            this.pendingRequests.put(requestId, op);
                            cmd.retain();
                        }
                        clientCnx.ctx().writeAndFlush(cmd, clientCnx.ctx().voidPromise());
                    } else {
                        this.cache.invalidate(topic);
                        cb.completeExceptionally(new PulsarClientException.LookupException(topic + " endTxn channel is not active"));
                        op.recycle();
                    }
                } else {
                    log.error("endTxn error topic: [{}]", (Object)topic, throwable);
                    this.cache.invalidate(topic);
                    cb.completeExceptionally(new PulsarClientException.LookupException(throwable.getMessage()));
                    op.recycle();
                }
            });
        }
        catch (ExecutionException e) {
            log.error("endTxn channel is not active exception", (Throwable)e);
            this.cache.invalidate(topic);
            cb.completeExceptionally(new PulsarClientException.LookupException(e.getCause().getMessage()));
            op.recycle();
        }
        return cb;
    }

    @Override
    public synchronized void handleEndTxnOnTopicResponse(long requestId, CommandEndTxnOnPartitionResponse response) {
        OpRequestSend op = this.pendingRequests.remove(requestId);
        if (op == null) {
            if (log.isDebugEnabled()) {
                log.debug("Got end txn on topic response for timeout {} - {}", (Object)response.getTxnidMostBits(), (Object)response.getTxnidLeastBits());
            }
            return;
        }
        if (!response.hasError()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Got end txn on topic response for for request {}", (Object)op.topic, (Object)response.getRequestId());
            }
            op.cb.complete(new TxnID(response.getTxnidMostBits(), response.getTxnidLeastBits()));
        } else {
            log.error("[{}] Got end txn on topic response for request {} error {}", new Object[]{op.topic, response.getRequestId(), response.getError()});
            this.cache.invalidate(op.topic);
            op.cb.completeExceptionally(ClientCnx.getPulsarClientException(response.getError(), response.getMessage()));
        }
        this.onResponse(op);
    }

    @Override
    public synchronized void handleEndTxnOnSubscriptionResponse(long requestId, CommandEndTxnOnSubscriptionResponse response) {
        OpRequestSend op = this.pendingRequests.remove(requestId);
        if (op == null) {
            if (log.isDebugEnabled()) {
                log.debug("Got end txn on subscription response for timeout {} - {}", (Object)response.getTxnidMostBits(), (Object)response.getTxnidLeastBits());
            }
            return;
        }
        if (!response.hasError()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Got end txn on subscription response for for request {}", (Object)op.topic, (Object)response.getRequestId());
            }
            op.cb.complete(new TxnID(response.getTxnidMostBits(), response.getTxnidLeastBits()));
        } else {
            log.error("[{}] Got end txn on subscription response for request {} error {}", new Object[]{op.topic, response.getRequestId(), response.getError()});
            this.cache.invalidate(op.topic);
            op.cb.completeExceptionally(ClientCnx.getPulsarClientException(response.getError(), response.getMessage()));
        }
        this.onResponse(op);
    }

    private boolean canSendRequest(CompletableFuture<?> callback) {
        try {
            if (this.blockIfReachMaxPendingOps) {
                this.semaphore.acquire();
            } else if (!this.semaphore.tryAcquire()) {
                callback.completeExceptionally(new TransactionBufferClientException.ReachMaxPendingOpsException("Reach max pending ops."));
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            callback.completeExceptionally(TransactionBufferClientException.unwrap(e));
            return false;
        }
        return true;
    }

    @Override
    public synchronized void run(Timeout timeout) throws Exception {
        OpRequestSend peeked;
        if (timeout.isCancelled()) {
            return;
        }
        Map.Entry<Long, OpRequestSend> firstEntry = this.pendingRequests.firstEntry();
        OpRequestSend opRequestSend = peeked = firstEntry == null ? null : firstEntry.getValue();
        while (peeked != null && peeked.createdAt + this.operationTimeoutInMills - System.currentTimeMillis() <= 0L && !peeked.cb.isDone()) {
            peeked.cb.completeExceptionally(new TransactionBufferClientException.RequestTimeoutException());
            this.onResponse(peeked);
            firstEntry = this.pendingRequests.firstEntry();
            this.pendingRequests.remove(this.pendingRequests.firstKey());
            peeked = firstEntry == null ? null : firstEntry.getValue();
        }
        long timeToWaitMs = peeked == null ? this.operationTimeoutInMills : peeked.createdAt + this.operationTimeoutInMills - System.currentTimeMillis();
        this.requestTimeout = this.timer.newTimeout(this, timeToWaitMs, TimeUnit.MILLISECONDS);
    }

    void onResponse(OpRequestSend op) {
        ReferenceCountUtil.safeRelease(op.byteBuf);
        op.recycle();
        this.semaphore.release();
    }

    private CompletableFuture<ClientCnx> getClientCnx(String topic) {
        return ((PulsarClientImpl)this.pulsarClient).getConnection(topic);
    }

    @Override
    public void close() {
        this.timer.stop();
    }

    private static final class OpRequestSend {
        long requestId;
        String topic;
        ByteBuf byteBuf;
        CompletableFuture<TxnID> cb;
        long createdAt;
        private final Recycler.Handle<OpRequestSend> recyclerHandle;
        private static final Recycler<OpRequestSend> RECYCLER = new Recycler<OpRequestSend>(){

            @Override
            protected OpRequestSend newObject(Recycler.Handle<OpRequestSend> handle) {
                return new OpRequestSend(handle);
            }
        };

        static OpRequestSend create(long requestId, String topic, ByteBuf byteBuf, CompletableFuture<TxnID> cb) {
            OpRequestSend op = RECYCLER.get();
            op.requestId = requestId;
            op.topic = topic;
            op.byteBuf = byteBuf;
            op.cb = cb;
            op.createdAt = System.currentTimeMillis();
            return op;
        }

        void recycle() {
            this.recyclerHandle.recycle(this);
        }

        private OpRequestSend(Recycler.Handle<OpRequestSend> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }
    }
}

