/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.validator;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;

public final class MultipleListenerValidator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, AdvertisedListener> validateAndAnalysisAdvertisedListener(ServiceConfiguration config) {
        void var1_2;
        if (StringUtils.isNotBlank(config.getAdvertisedListeners()) && StringUtils.isNotBlank(config.getAdvertisedAddress())) {
            throw new IllegalArgumentException("`advertisedListeners` and `advertisedAddress` must not appear together");
        }
        if (StringUtils.isBlank(config.getAdvertisedListeners())) {
            return Collections.emptyMap();
        }
        Optional optional = Optional.empty();
        HashMap<String, List> listeners = Maps.newHashMap();
        for (String str : StringUtils.split(config.getAdvertisedListeners(), ",")) {
            int index = str.indexOf(":");
            if (index <= 0) {
                throw new IllegalArgumentException("the configure entry `advertisedListeners` is invalid. because " + str + " do not contain listener name");
            }
            String listenerName = StringUtils.trim(str.substring(0, index));
            if (!var1_2.isPresent()) {
                Optional<String> optional2 = Optional.of(listenerName);
            }
            String value = StringUtils.trim(str.substring(index + 1));
            listeners.computeIfAbsent(listenerName, k -> Lists.newArrayListWithCapacity(2));
            ((List)listeners.get(listenerName)).add(value);
        }
        if (StringUtils.isBlank(config.getInternalListenerName())) {
            config.setInternalListenerName((String)var1_2.get());
        }
        if (!listeners.containsKey(config.getInternalListenerName())) {
            throw new IllegalArgumentException("the `advertisedListeners` configure do not contain `internalListenerName` entry");
        }
        HashMap<String, AdvertisedListener> result = Maps.newHashMap();
        HashMap<String, Set> reverseMappings = Maps.newHashMap();
        for (Map.Entry entry : listeners.entrySet()) {
            if (((List)entry.getValue()).size() > 2) {
                throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
            }
            URI pulsarAddress = null;
            URI pulsarSslAddress = null;
            for (String strUri : (List)entry.getValue()) {
                try {
                    URI uri = URI.create(strUri);
                    if (StringUtils.equalsIgnoreCase(uri.getScheme(), "pulsar")) {
                        if (pulsarAddress != null) throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
                        pulsarAddress = uri;
                    } else if (StringUtils.equalsIgnoreCase(uri.getScheme(), "pulsar+ssl")) {
                        if (pulsarSslAddress != null) throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
                        pulsarSslAddress = uri;
                    }
                    String hostPort = String.format("%s:%d", uri.getHost(), uri.getPort());
                    Set sets = reverseMappings.computeIfAbsent(hostPort, k -> Sets.newTreeSet());
                    sets.add(entry.getKey());
                    if (sets.size() <= 1) continue;
                    throw new IllegalArgumentException("must not specify `" + hostPort + "` to different listener.");
                }
                catch (Throwable cause) {
                    throw new IllegalArgumentException("the value " + strUri + " in the `advertisedListeners` configure is invalid");
                }
            }
            if (!config.getBrokerServicePortTls().isPresent()) {
                if (pulsarSslAddress != null) {
                    throw new IllegalArgumentException("If pulsar do not start ssl port, there is no need to configure  `pulsar+ssl` in `" + (String)entry.getKey() + "` listener.");
                }
            } else if (pulsarSslAddress == null) {
                throw new IllegalArgumentException("the `" + (String)entry.getKey() + "` listener in the `advertisedListeners`  do not specify `pulsar+ssl` address.");
            }
            if (pulsarAddress == null) {
                throw new IllegalArgumentException("the `" + (String)entry.getKey() + "` listener in the `advertisedListeners`  do not specify `pulsar` address.");
            }
            result.put((String)entry.getKey(), AdvertisedListener.builder().brokerServiceUrl(pulsarAddress).brokerServiceUrlTls(pulsarSslAddress).build());
        }
        return result;
    }
}

