/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.transaction;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TransactionCoordinatorClientException
extends IOException {
    public TransactionCoordinatorClientException(Throwable t) {
        super(t);
    }

    public TransactionCoordinatorClientException(String message) {
        super(message);
    }

    public static TransactionCoordinatorClientException unwrap(Throwable t) {
        if (t instanceof TransactionCoordinatorClientException) {
            return (TransactionCoordinatorClientException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new TransactionCoordinatorClientException(t);
        }
        if (!(t instanceof ExecutionException)) {
            return new TransactionCoordinatorClientException(t);
        }
        Throwable cause = t.getCause();
        String msg = cause.getMessage();
        if (cause instanceof CoordinatorNotFoundException) {
            return new CoordinatorNotFoundException(msg);
        }
        if (cause instanceof InvalidTxnStatusException) {
            return new InvalidTxnStatusException(msg);
        }
        return new TransactionCoordinatorClientException(t);
    }

    public static class MetaStoreHandlerNotReadyException
    extends TransactionCoordinatorClientException {
        public MetaStoreHandlerNotReadyException(long tcId) {
            super("Transaction meta store handler for transaction meta store {} not ready now.");
        }

        public MetaStoreHandlerNotReadyException(String message) {
            super(message);
        }
    }

    public static class MetaStoreHandlerNotExistsException
    extends TransactionCoordinatorClientException {
        public MetaStoreHandlerNotExistsException(long tcId) {
            super("Transaction meta store handler for transaction meta store {} not exists.");
        }

        public MetaStoreHandlerNotExistsException(String message) {
            super(message);
        }
    }

    public static class TransactionNotFoundException
    extends TransactionCoordinatorClientException {
        public TransactionNotFoundException(String message) {
            super(message);
        }
    }

    public static class InvalidTxnStatusException
    extends TransactionCoordinatorClientException {
        public InvalidTxnStatusException(String message) {
            super(message);
        }
    }

    public static class CoordinatorNotFoundException
    extends TransactionCoordinatorClientException {
        public CoordinatorNotFoundException(String message) {
            super(message);
        }
    }

    public static class CoordinatorClientStateException
    extends TransactionCoordinatorClientException {
        public CoordinatorClientStateException() {
            super("Unexpected state for transaction metadata client.");
        }

        public CoordinatorClientStateException(String message) {
            super(message);
        }
    }
}

