/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger;

import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.proto.MLDataFormats;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public class ManagedLedgerFactoryConfig {
    private static final long MB = 0x100000L;
    private long maxCacheSize = 0x8000000L;
    private double cacheEvictionWatermark = 0.9;
    private int numManagedLedgerWorkerThreads = Runtime.getRuntime().availableProcessors();
    private int numManagedLedgerSchedulerThreads = Runtime.getRuntime().availableProcessors();
    private double cacheEvictionFrequency = 100.0;
    private long cacheEvictionTimeThresholdMillis = 1000L;
    private boolean copyEntriesInCache = false;
    private boolean traceTaskExecution = true;
    private int prometheusStatsLatencyRolloverSeconds = 60;
    private int cursorPositionFlushSeconds = 60;
    private String clusterName;
    private String managedLedgerInfoCompressionType = MLDataFormats.CompressionType.NONE.name();

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    public int getNumManagedLedgerWorkerThreads() {
        return this.numManagedLedgerWorkerThreads;
    }

    public int getNumManagedLedgerSchedulerThreads() {
        return this.numManagedLedgerSchedulerThreads;
    }

    public double getCacheEvictionFrequency() {
        return this.cacheEvictionFrequency;
    }

    public long getCacheEvictionTimeThresholdMillis() {
        return this.cacheEvictionTimeThresholdMillis;
    }

    public boolean isCopyEntriesInCache() {
        return this.copyEntriesInCache;
    }

    public boolean isTraceTaskExecution() {
        return this.traceTaskExecution;
    }

    public int getPrometheusStatsLatencyRolloverSeconds() {
        return this.prometheusStatsLatencyRolloverSeconds;
    }

    public int getCursorPositionFlushSeconds() {
        return this.cursorPositionFlushSeconds;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getManagedLedgerInfoCompressionType() {
        return this.managedLedgerInfoCompressionType;
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    public void setNumManagedLedgerWorkerThreads(int numManagedLedgerWorkerThreads) {
        this.numManagedLedgerWorkerThreads = numManagedLedgerWorkerThreads;
    }

    public void setNumManagedLedgerSchedulerThreads(int numManagedLedgerSchedulerThreads) {
        this.numManagedLedgerSchedulerThreads = numManagedLedgerSchedulerThreads;
    }

    public void setCacheEvictionFrequency(double cacheEvictionFrequency) {
        this.cacheEvictionFrequency = cacheEvictionFrequency;
    }

    public void setCacheEvictionTimeThresholdMillis(long cacheEvictionTimeThresholdMillis) {
        this.cacheEvictionTimeThresholdMillis = cacheEvictionTimeThresholdMillis;
    }

    public void setCopyEntriesInCache(boolean copyEntriesInCache) {
        this.copyEntriesInCache = copyEntriesInCache;
    }

    public void setTraceTaskExecution(boolean traceTaskExecution) {
        this.traceTaskExecution = traceTaskExecution;
    }

    public void setPrometheusStatsLatencyRolloverSeconds(int prometheusStatsLatencyRolloverSeconds) {
        this.prometheusStatsLatencyRolloverSeconds = prometheusStatsLatencyRolloverSeconds;
    }

    public void setCursorPositionFlushSeconds(int cursorPositionFlushSeconds) {
        this.cursorPositionFlushSeconds = cursorPositionFlushSeconds;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setManagedLedgerInfoCompressionType(String managedLedgerInfoCompressionType) {
        this.managedLedgerInfoCompressionType = managedLedgerInfoCompressionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedLedgerFactoryConfig)) {
            return false;
        }
        ManagedLedgerFactoryConfig other = (ManagedLedgerFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
            return false;
        }
        if (Double.compare(this.getCacheEvictionWatermark(), other.getCacheEvictionWatermark()) != 0) {
            return false;
        }
        if (this.getNumManagedLedgerWorkerThreads() != other.getNumManagedLedgerWorkerThreads()) {
            return false;
        }
        if (this.getNumManagedLedgerSchedulerThreads() != other.getNumManagedLedgerSchedulerThreads()) {
            return false;
        }
        if (Double.compare(this.getCacheEvictionFrequency(), other.getCacheEvictionFrequency()) != 0) {
            return false;
        }
        if (this.getCacheEvictionTimeThresholdMillis() != other.getCacheEvictionTimeThresholdMillis()) {
            return false;
        }
        if (this.isCopyEntriesInCache() != other.isCopyEntriesInCache()) {
            return false;
        }
        if (this.isTraceTaskExecution() != other.isTraceTaskExecution()) {
            return false;
        }
        if (this.getPrometheusStatsLatencyRolloverSeconds() != other.getPrometheusStatsLatencyRolloverSeconds()) {
            return false;
        }
        if (this.getCursorPositionFlushSeconds() != other.getCursorPositionFlushSeconds()) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        String other$managedLedgerInfoCompressionType = other.getManagedLedgerInfoCompressionType();
        return !(this$managedLedgerInfoCompressionType == null ? other$managedLedgerInfoCompressionType != null : !this$managedLedgerInfoCompressionType.equals(other$managedLedgerInfoCompressionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManagedLedgerFactoryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxCacheSize = this.getMaxCacheSize();
        result = result * 59 + (int)($maxCacheSize >>> 32 ^ $maxCacheSize);
        long $cacheEvictionWatermark = Double.doubleToLongBits(this.getCacheEvictionWatermark());
        result = result * 59 + (int)($cacheEvictionWatermark >>> 32 ^ $cacheEvictionWatermark);
        result = result * 59 + this.getNumManagedLedgerWorkerThreads();
        result = result * 59 + this.getNumManagedLedgerSchedulerThreads();
        long $cacheEvictionFrequency = Double.doubleToLongBits(this.getCacheEvictionFrequency());
        result = result * 59 + (int)($cacheEvictionFrequency >>> 32 ^ $cacheEvictionFrequency);
        long $cacheEvictionTimeThresholdMillis = this.getCacheEvictionTimeThresholdMillis();
        result = result * 59 + (int)($cacheEvictionTimeThresholdMillis >>> 32 ^ $cacheEvictionTimeThresholdMillis);
        result = result * 59 + (this.isCopyEntriesInCache() ? 79 : 97);
        result = result * 59 + (this.isTraceTaskExecution() ? 79 : 97);
        result = result * 59 + this.getPrometheusStatsLatencyRolloverSeconds();
        result = result * 59 + this.getCursorPositionFlushSeconds();
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        result = result * 59 + ($managedLedgerInfoCompressionType == null ? 43 : $managedLedgerInfoCompressionType.hashCode());
        return result;
    }

    public String toString() {
        return "ManagedLedgerFactoryConfig(maxCacheSize=" + this.getMaxCacheSize() + ", cacheEvictionWatermark=" + this.getCacheEvictionWatermark() + ", numManagedLedgerWorkerThreads=" + this.getNumManagedLedgerWorkerThreads() + ", numManagedLedgerSchedulerThreads=" + this.getNumManagedLedgerSchedulerThreads() + ", cacheEvictionFrequency=" + this.getCacheEvictionFrequency() + ", cacheEvictionTimeThresholdMillis=" + this.getCacheEvictionTimeThresholdMillis() + ", copyEntriesInCache=" + this.isCopyEntriesInCache() + ", traceTaskExecution=" + this.isTraceTaskExecution() + ", prometheusStatsLatencyRolloverSeconds=" + this.getPrometheusStatsLatencyRolloverSeconds() + ", cursorPositionFlushSeconds=" + this.getCursorPositionFlushSeconds() + ", clusterName=" + this.getClusterName() + ", managedLedgerInfoCompressionType=" + this.getManagedLedgerInfoCompressionType() + ")";
    }
}

