/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.cookie;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieShell;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.BookieShellCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CookieCommand<CookieFlagsT extends CliFlags>
extends BKCommand<CookieFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(CookieCommand.class);

    protected CookieCommand(CliSpec<CookieFlagsT> spec) {
        super(spec);
    }

    @Override
    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, CookieFlagsT cmdFlags) {
        ServerConfiguration serverConf = new ServerConfiguration();
        serverConf.loadConf(conf);
        if (null != serviceURI) {
            serverConf.setMetadataServiceUri(serviceURI.getUri().toString());
        }
        try {
            return MetadataDrivers.runFunctionWithRegistrationManager(serverConf, registrationManager -> {
                try {
                    this.apply((RegistrationManager)registrationManager, cmdFlags);
                    return true;
                }
                catch (Exception e) {
                    throw new UncheckedExecutionException(e);
                }
            });
        }
        catch (ExecutionException | UncheckedExecutionException | MetadataException e) {
            Throwable cause = e;
            if (!(e instanceof MetadataException) && null != e.getCause()) {
                cause = e.getCause();
            }
            this.spec.console().println("Failed to process cookie command '" + this.name() + "'");
            cause.printStackTrace(this.spec.console());
            return false;
        }
    }

    protected BookieId getBookieId(CookieFlagsT cmdFlags) throws UnknownHostException {
        Preconditions.checkArgument(((CliFlags)cmdFlags).arguments.size() == 1, "No bookie id or more bookie ids is specified");
        String bookieId = ((CliFlags)cmdFlags).arguments.get(0);
        try {
            new BookieSocketAddress(bookieId);
        }
        catch (UnknownHostException nhe) {
            this.spec.console().println("Invalid bookie id '" + bookieId + "'is used to create cookie. Bookie id should be in the format of '<hostname>:<port>'");
            throw nhe;
        }
        return BookieId.parse(bookieId);
    }

    protected byte[] readCookieDataFromFile(String cookieFile) throws IOException {
        try {
            return Files.readAllBytes(Paths.get(cookieFile, new String[0]));
        }
        catch (NoSuchFileException nfe) {
            this.spec.console().println("Cookie file '" + cookieFile + "' doesn't exist.");
            throw nfe;
        }
    }

    protected abstract void apply(RegistrationManager var1, CookieFlagsT var2) throws Exception;

    public BookieShell.Command asShellCommand(String shellCmdName, CompositeConfiguration conf) {
        return new BookieShellCommand(shellCmdName, this, conf);
    }
}

